/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.CompressionType;
import software.amazon.awssdk.services.sagemaker.model.SplitType;
import software.amazon.awssdk.services.sagemaker.model.TransformDataSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransformInput> {
    private static final SdkField<TransformDataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSource").getter(TransformInput.getter(TransformInput::dataSource)).setter(TransformInput.setter(Builder::dataSource)).constructor(TransformDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(TransformInput.getter(TransformInput::contentType)).setter(TransformInput.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()}).build();
    private static final SdkField<String> COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompressionType").getter(TransformInput.getter(TransformInput::compressionTypeAsString)).setter(TransformInput.setter(Builder::compressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionType").build()}).build();
    private static final SdkField<String> SPLIT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SplitType").getter(TransformInput.getter(TransformInput::splitTypeAsString)).setter(TransformInput.setter(Builder::splitType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplitType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD, CONTENT_TYPE_FIELD, COMPRESSION_TYPE_FIELD, SPLIT_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final TransformDataSource dataSource;
    private final String contentType;
    private final String compressionType;
    private final String splitType;

    private TransformInput(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.contentType = builder.contentType;
        this.compressionType = builder.compressionType;
        this.splitType = builder.splitType;
    }

    public final TransformDataSource dataSource() {
        return this.dataSource;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final CompressionType compressionType() {
        return CompressionType.fromValue(this.compressionType);
    }

    public final String compressionTypeAsString() {
        return this.compressionType;
    }

    public final SplitType splitType() {
        return SplitType.fromValue(this.splitType);
    }

    public final String splitTypeAsString() {
        return this.splitType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.splitTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformInput)) {
            return false;
        }
        TransformInput other = (TransformInput)obj;
        return Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.compressionTypeAsString(), other.compressionTypeAsString()) && Objects.equals(this.splitTypeAsString(), other.splitTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TransformInput").add("DataSource", (Object)this.dataSource()).add("ContentType", (Object)this.contentType()).add("CompressionType", (Object)this.compressionTypeAsString()).add("SplitType", (Object)this.splitTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "CompressionType": {
                return Optional.ofNullable(clazz.cast(this.compressionTypeAsString()));
            }
            case "SplitType": {
                return Optional.ofNullable(clazz.cast(this.splitTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransformInput, T> g) {
        return obj -> g.apply((TransformInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TransformDataSource dataSource;
        private String contentType;
        private String compressionType;
        private String splitType;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformInput model) {
            this.dataSource(model.dataSource);
            this.contentType(model.contentType);
            this.compressionType(model.compressionType);
            this.splitType(model.splitType);
        }

        public final TransformDataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(TransformDataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        @Transient
        public final Builder dataSource(TransformDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        @Transient
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getCompressionType() {
            return this.compressionType;
        }

        public final void setCompressionType(String compressionType) {
            this.compressionType = compressionType;
        }

        @Override
        @Transient
        public final Builder compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        @Override
        @Transient
        public final Builder compressionType(CompressionType compressionType) {
            this.compressionType(compressionType == null ? null : compressionType.toString());
            return this;
        }

        public final String getSplitType() {
            return this.splitType;
        }

        public final void setSplitType(String splitType) {
            this.splitType = splitType;
        }

        @Override
        @Transient
        public final Builder splitType(String splitType) {
            this.splitType = splitType;
            return this;
        }

        @Override
        @Transient
        public final Builder splitType(SplitType splitType) {
            this.splitType(splitType == null ? null : splitType.toString());
            return this;
        }

        public TransformInput build() {
            return new TransformInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransformInput> {
        public Builder dataSource(TransformDataSource var1);

        default public Builder dataSource(Consumer<TransformDataSource.Builder> dataSource) {
            return this.dataSource((TransformDataSource)((TransformDataSource.Builder)TransformDataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder contentType(String var1);

        public Builder compressionType(String var1);

        public Builder compressionType(CompressionType var1);

        public Builder splitType(String var1);

        public Builder splitType(SplitType var1);
    }
}

