/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EdgePackagingJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EdgePackagingJobSummary> {
    private static final SdkField<String> EDGE_PACKAGING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgePackagingJobArn").getter(EdgePackagingJobSummary.getter(EdgePackagingJobSummary::edgePackagingJobArn)).setter(EdgePackagingJobSummary.setter(Builder::edgePackagingJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgePackagingJobArn").build()}).build();
    private static final SdkField<String> EDGE_PACKAGING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgePackagingJobName").getter(EdgePackagingJobSummary.getter(EdgePackagingJobSummary::edgePackagingJobName)).setter(EdgePackagingJobSummary.setter(Builder::edgePackagingJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgePackagingJobName").build()}).build();
    private static final SdkField<String> EDGE_PACKAGING_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgePackagingJobStatus").getter(EdgePackagingJobSummary.getter(EdgePackagingJobSummary::edgePackagingJobStatusAsString)).setter(EdgePackagingJobSummary.setter(Builder::edgePackagingJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgePackagingJobStatus").build()}).build();
    private static final SdkField<String> COMPILATION_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompilationJobName").getter(EdgePackagingJobSummary.getter(EdgePackagingJobSummary::compilationJobName)).setter(EdgePackagingJobSummary.setter(Builder::compilationJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobName").build()}).build();
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(EdgePackagingJobSummary.getter(EdgePackagingJobSummary::modelName)).setter(EdgePackagingJobSummary.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelVersion").getter(EdgePackagingJobSummary.getter(EdgePackagingJobSummary::modelVersion)).setter(EdgePackagingJobSummary.setter(Builder::modelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(EdgePackagingJobSummary.getter(EdgePackagingJobSummary::creationTime)).setter(EdgePackagingJobSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(EdgePackagingJobSummary.getter(EdgePackagingJobSummary::lastModifiedTime)).setter(EdgePackagingJobSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDGE_PACKAGING_JOB_ARN_FIELD, EDGE_PACKAGING_JOB_NAME_FIELD, EDGE_PACKAGING_JOB_STATUS_FIELD, COMPILATION_JOB_NAME_FIELD, MODEL_NAME_FIELD, MODEL_VERSION_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String edgePackagingJobArn;
    private final String edgePackagingJobName;
    private final String edgePackagingJobStatus;
    private final String compilationJobName;
    private final String modelName;
    private final String modelVersion;
    private final Instant creationTime;
    private final Instant lastModifiedTime;

    private EdgePackagingJobSummary(BuilderImpl builder) {
        this.edgePackagingJobArn = builder.edgePackagingJobArn;
        this.edgePackagingJobName = builder.edgePackagingJobName;
        this.edgePackagingJobStatus = builder.edgePackagingJobStatus;
        this.compilationJobName = builder.compilationJobName;
        this.modelName = builder.modelName;
        this.modelVersion = builder.modelVersion;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String edgePackagingJobArn() {
        return this.edgePackagingJobArn;
    }

    public final String edgePackagingJobName() {
        return this.edgePackagingJobName;
    }

    public final EdgePackagingJobStatus edgePackagingJobStatus() {
        return EdgePackagingJobStatus.fromValue(this.edgePackagingJobStatus);
    }

    public final String edgePackagingJobStatusAsString() {
        return this.edgePackagingJobStatus;
    }

    public final String compilationJobName() {
        return this.compilationJobName;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String modelVersion() {
        return this.modelVersion;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.edgePackagingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgePackagingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgePackagingJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgePackagingJobSummary)) {
            return false;
        }
        EdgePackagingJobSummary other = (EdgePackagingJobSummary)obj;
        return Objects.equals(this.edgePackagingJobArn(), other.edgePackagingJobArn()) && Objects.equals(this.edgePackagingJobName(), other.edgePackagingJobName()) && Objects.equals(this.edgePackagingJobStatusAsString(), other.edgePackagingJobStatusAsString()) && Objects.equals(this.compilationJobName(), other.compilationJobName()) && Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.modelVersion(), other.modelVersion()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"EdgePackagingJobSummary").add("EdgePackagingJobArn", (Object)this.edgePackagingJobArn()).add("EdgePackagingJobName", (Object)this.edgePackagingJobName()).add("EdgePackagingJobStatus", (Object)this.edgePackagingJobStatusAsString()).add("CompilationJobName", (Object)this.compilationJobName()).add("ModelName", (Object)this.modelName()).add("ModelVersion", (Object)this.modelVersion()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EdgePackagingJobArn": {
                return Optional.ofNullable(clazz.cast(this.edgePackagingJobArn()));
            }
            case "EdgePackagingJobName": {
                return Optional.ofNullable(clazz.cast(this.edgePackagingJobName()));
            }
            case "EdgePackagingJobStatus": {
                return Optional.ofNullable(clazz.cast(this.edgePackagingJobStatusAsString()));
            }
            case "CompilationJobName": {
                return Optional.ofNullable(clazz.cast(this.compilationJobName()));
            }
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "ModelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EdgePackagingJobSummary, T> g) {
        return obj -> g.apply((EdgePackagingJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String edgePackagingJobArn;
        private String edgePackagingJobName;
        private String edgePackagingJobStatus;
        private String compilationJobName;
        private String modelName;
        private String modelVersion;
        private Instant creationTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgePackagingJobSummary model) {
            this.edgePackagingJobArn(model.edgePackagingJobArn);
            this.edgePackagingJobName(model.edgePackagingJobName);
            this.edgePackagingJobStatus(model.edgePackagingJobStatus);
            this.compilationJobName(model.compilationJobName);
            this.modelName(model.modelName);
            this.modelVersion(model.modelVersion);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getEdgePackagingJobArn() {
            return this.edgePackagingJobArn;
        }

        public final void setEdgePackagingJobArn(String edgePackagingJobArn) {
            this.edgePackagingJobArn = edgePackagingJobArn;
        }

        @Override
        @Transient
        public final Builder edgePackagingJobArn(String edgePackagingJobArn) {
            this.edgePackagingJobArn = edgePackagingJobArn;
            return this;
        }

        public final String getEdgePackagingJobName() {
            return this.edgePackagingJobName;
        }

        public final void setEdgePackagingJobName(String edgePackagingJobName) {
            this.edgePackagingJobName = edgePackagingJobName;
        }

        @Override
        @Transient
        public final Builder edgePackagingJobName(String edgePackagingJobName) {
            this.edgePackagingJobName = edgePackagingJobName;
            return this;
        }

        public final String getEdgePackagingJobStatus() {
            return this.edgePackagingJobStatus;
        }

        public final void setEdgePackagingJobStatus(String edgePackagingJobStatus) {
            this.edgePackagingJobStatus = edgePackagingJobStatus;
        }

        @Override
        @Transient
        public final Builder edgePackagingJobStatus(String edgePackagingJobStatus) {
            this.edgePackagingJobStatus = edgePackagingJobStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder edgePackagingJobStatus(EdgePackagingJobStatus edgePackagingJobStatus) {
            this.edgePackagingJobStatus(edgePackagingJobStatus == null ? null : edgePackagingJobStatus.toString());
            return this;
        }

        public final String getCompilationJobName() {
            return this.compilationJobName;
        }

        public final void setCompilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
        }

        @Override
        @Transient
        public final Builder compilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
            return this;
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        @Transient
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelVersion() {
            return this.modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        @Transient
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public EdgePackagingJobSummary build() {
            return new EdgePackagingJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EdgePackagingJobSummary> {
        public Builder edgePackagingJobArn(String var1);

        public Builder edgePackagingJobName(String var1);

        public Builder edgePackagingJobStatus(String var1);

        public Builder edgePackagingJobStatus(EdgePackagingJobStatus var1);

        public Builder compilationJobName(String var1);

        public Builder modelName(String var1);

        public Builder modelVersion(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

