/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.DomainSecurityGroupIdsCopier;
import software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainSettings> {
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(DomainSettings.getter(DomainSettings::securityGroupIds)).setter(DomainSettings.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RStudioServerProDomainSettings> R_STUDIO_SERVER_PRO_DOMAIN_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RStudioServerProDomainSettings").getter(DomainSettings.getter(DomainSettings::rStudioServerProDomainSettings)).setter(DomainSettings.setter(Builder::rStudioServerProDomainSettings)).constructor(RStudioServerProDomainSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RStudioServerProDomainSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_GROUP_IDS_FIELD, R_STUDIO_SERVER_PRO_DOMAIN_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> securityGroupIds;
    private final RStudioServerProDomainSettings rStudioServerProDomainSettings;

    private DomainSettings(BuilderImpl builder) {
        this.securityGroupIds = builder.securityGroupIds;
        this.rStudioServerProDomainSettings = builder.rStudioServerProDomainSettings;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final RStudioServerProDomainSettings rStudioServerProDomainSettings() {
        return this.rStudioServerProDomainSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rStudioServerProDomainSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainSettings)) {
            return false;
        }
        DomainSettings other = (DomainSettings)obj;
        return this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.rStudioServerProDomainSettings(), other.rStudioServerProDomainSettings());
    }

    public final String toString() {
        return ToString.builder((String)"DomainSettings").add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("RStudioServerProDomainSettings", (Object)this.rStudioServerProDomainSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "RStudioServerProDomainSettings": {
                return Optional.ofNullable(clazz.cast(this.rStudioServerProDomainSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainSettings, T> g) {
        return obj -> g.apply((DomainSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private RStudioServerProDomainSettings rStudioServerProDomainSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainSettings model) {
            this.securityGroupIds(model.securityGroupIds);
            this.rStudioServerProDomainSettings(model.rStudioServerProDomainSettings);
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = DomainSecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        @Transient
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = DomainSecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final RStudioServerProDomainSettings.Builder getRStudioServerProDomainSettings() {
            return this.rStudioServerProDomainSettings != null ? this.rStudioServerProDomainSettings.toBuilder() : null;
        }

        public final void setRStudioServerProDomainSettings(RStudioServerProDomainSettings.BuilderImpl rStudioServerProDomainSettings) {
            this.rStudioServerProDomainSettings = rStudioServerProDomainSettings != null ? rStudioServerProDomainSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder rStudioServerProDomainSettings(RStudioServerProDomainSettings rStudioServerProDomainSettings) {
            this.rStudioServerProDomainSettings = rStudioServerProDomainSettings;
            return this;
        }

        public DomainSettings build() {
            return new DomainSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainSettings> {
        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder rStudioServerProDomainSettings(RStudioServerProDomainSettings var1);

        default public Builder rStudioServerProDomainSettings(Consumer<RStudioServerProDomainSettings.Builder> rStudioServerProDomainSettings) {
            return this.rStudioServerProDomainSettings((RStudioServerProDomainSettings)((RStudioServerProDomainSettings.Builder)RStudioServerProDomainSettings.builder().applyMutation(rStudioServerProDomainSettings)).build());
        }
    }
}

