/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePipelineRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreatePipelineRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineName").getter(CreatePipelineRequest.getter(CreatePipelineRequest::pipelineName)).setter(CreatePipelineRequest.setter(Builder::pipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineName").build()}).build();
    private static final SdkField<String> PIPELINE_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineDisplayName").getter(CreatePipelineRequest.getter(CreatePipelineRequest::pipelineDisplayName)).setter(CreatePipelineRequest.setter(Builder::pipelineDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDisplayName").build()}).build();
    private static final SdkField<String> PIPELINE_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineDefinition").getter(CreatePipelineRequest.getter(CreatePipelineRequest::pipelineDefinition)).setter(CreatePipelineRequest.setter(Builder::pipelineDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDefinition").build()}).build();
    private static final SdkField<String> PIPELINE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineDescription").getter(CreatePipelineRequest.getter(CreatePipelineRequest::pipelineDescription)).setter(CreatePipelineRequest.setter(Builder::pipelineDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDescription").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreatePipelineRequest.getter(CreatePipelineRequest::clientRequestToken)).setter(CreatePipelineRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreatePipelineRequest.getter(CreatePipelineRequest::roleArn)).setter(CreatePipelineRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreatePipelineRequest.getter(CreatePipelineRequest::tags)).setter(CreatePipelineRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD, PIPELINE_DISPLAY_NAME_FIELD, PIPELINE_DEFINITION_FIELD, PIPELINE_DESCRIPTION_FIELD, CLIENT_REQUEST_TOKEN_FIELD, ROLE_ARN_FIELD, TAGS_FIELD));
    private final String pipelineName;
    private final String pipelineDisplayName;
    private final String pipelineDefinition;
    private final String pipelineDescription;
    private final String clientRequestToken;
    private final String roleArn;
    private final List<Tag> tags;

    private CreatePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.pipelineDisplayName = builder.pipelineDisplayName;
        this.pipelineDefinition = builder.pipelineDefinition;
        this.pipelineDescription = builder.pipelineDescription;
        this.clientRequestToken = builder.clientRequestToken;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
    }

    public final String pipelineName() {
        return this.pipelineName;
    }

    public final String pipelineDisplayName() {
        return this.pipelineDisplayName;
    }

    public final String pipelineDefinition() {
        return this.pipelineDefinition;
    }

    public final String pipelineDescription() {
        return this.pipelineDescription;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePipelineRequest)) {
            return false;
        }
        CreatePipelineRequest other = (CreatePipelineRequest)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.pipelineDisplayName(), other.pipelineDisplayName()) && Objects.equals(this.pipelineDefinition(), other.pipelineDefinition()) && Objects.equals(this.pipelineDescription(), other.pipelineDescription()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePipelineRequest").add("PipelineName", (Object)this.pipelineName()).add("PipelineDisplayName", (Object)this.pipelineDisplayName()).add("PipelineDefinition", (Object)this.pipelineDefinition()).add("PipelineDescription", (Object)this.pipelineDescription()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "PipelineDisplayName": {
                return Optional.ofNullable(clazz.cast(this.pipelineDisplayName()));
            }
            case "PipelineDefinition": {
                return Optional.ofNullable(clazz.cast(this.pipelineDefinition()));
            }
            case "PipelineDescription": {
                return Optional.ofNullable(clazz.cast(this.pipelineDescription()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePipelineRequest, T> g) {
        return obj -> g.apply((CreatePipelineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String pipelineName;
        private String pipelineDisplayName;
        private String pipelineDefinition;
        private String pipelineDescription;
        private String clientRequestToken;
        private String roleArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePipelineRequest model) {
            super(model);
            this.pipelineName(model.pipelineName);
            this.pipelineDisplayName(model.pipelineDisplayName);
            this.pipelineDefinition(model.pipelineDefinition);
            this.pipelineDescription(model.pipelineDescription);
            this.clientRequestToken(model.clientRequestToken);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        @Transient
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final String getPipelineDisplayName() {
            return this.pipelineDisplayName;
        }

        public final void setPipelineDisplayName(String pipelineDisplayName) {
            this.pipelineDisplayName = pipelineDisplayName;
        }

        @Override
        @Transient
        public final Builder pipelineDisplayName(String pipelineDisplayName) {
            this.pipelineDisplayName = pipelineDisplayName;
            return this;
        }

        public final String getPipelineDefinition() {
            return this.pipelineDefinition;
        }

        public final void setPipelineDefinition(String pipelineDefinition) {
            this.pipelineDefinition = pipelineDefinition;
        }

        @Override
        @Transient
        public final Builder pipelineDefinition(String pipelineDefinition) {
            this.pipelineDefinition = pipelineDefinition;
            return this;
        }

        public final String getPipelineDescription() {
            return this.pipelineDescription;
        }

        public final void setPipelineDescription(String pipelineDescription) {
            this.pipelineDescription = pipelineDescription;
        }

        @Override
        @Transient
        public final Builder pipelineDescription(String pipelineDescription) {
            this.pipelineDescription = pipelineDescription;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePipelineRequest build() {
            return new CreatePipelineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePipelineRequest> {
        public Builder pipelineName(String var1);

        public Builder pipelineDisplayName(String var1);

        public Builder pipelineDefinition(String var1);

        public Builder pipelineDescription(String var1);

        public Builder clientRequestToken(String var1);

        public Builder roleArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

