/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.OidcConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SourceIpConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkforceRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateWorkforceRequest> {
    private static final SdkField<String> WORKFORCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkforceName").getter(UpdateWorkforceRequest.getter(UpdateWorkforceRequest::workforceName)).setter(UpdateWorkforceRequest.setter(Builder::workforceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkforceName").build()}).build();
    private static final SdkField<SourceIpConfig> SOURCE_IP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceIpConfig").getter(UpdateWorkforceRequest.getter(UpdateWorkforceRequest::sourceIpConfig)).setter(UpdateWorkforceRequest.setter(Builder::sourceIpConfig)).constructor(SourceIpConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIpConfig").build()}).build();
    private static final SdkField<OidcConfig> OIDC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OidcConfig").getter(UpdateWorkforceRequest.getter(UpdateWorkforceRequest::oidcConfig)).setter(UpdateWorkforceRequest.setter(Builder::oidcConfig)).constructor(OidcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OidcConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFORCE_NAME_FIELD, SOURCE_IP_CONFIG_FIELD, OIDC_CONFIG_FIELD));
    private final String workforceName;
    private final SourceIpConfig sourceIpConfig;
    private final OidcConfig oidcConfig;

    private UpdateWorkforceRequest(BuilderImpl builder) {
        super(builder);
        this.workforceName = builder.workforceName;
        this.sourceIpConfig = builder.sourceIpConfig;
        this.oidcConfig = builder.oidcConfig;
    }

    public final String workforceName() {
        return this.workforceName;
    }

    public final SourceIpConfig sourceIpConfig() {
        return this.sourceIpConfig;
    }

    public final OidcConfig oidcConfig() {
        return this.oidcConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workforceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIpConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.oidcConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkforceRequest)) {
            return false;
        }
        UpdateWorkforceRequest other = (UpdateWorkforceRequest)((Object)obj);
        return Objects.equals(this.workforceName(), other.workforceName()) && Objects.equals(this.sourceIpConfig(), other.sourceIpConfig()) && Objects.equals(this.oidcConfig(), other.oidcConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWorkforceRequest").add("WorkforceName", (Object)this.workforceName()).add("SourceIpConfig", (Object)this.sourceIpConfig()).add("OidcConfig", (Object)this.oidcConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkforceName": {
                return Optional.ofNullable(clazz.cast(this.workforceName()));
            }
            case "SourceIpConfig": {
                return Optional.ofNullable(clazz.cast(this.sourceIpConfig()));
            }
            case "OidcConfig": {
                return Optional.ofNullable(clazz.cast(this.oidcConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkforceRequest, T> g) {
        return obj -> g.apply((UpdateWorkforceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String workforceName;
        private SourceIpConfig sourceIpConfig;
        private OidcConfig oidcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkforceRequest model) {
            super(model);
            this.workforceName(model.workforceName);
            this.sourceIpConfig(model.sourceIpConfig);
            this.oidcConfig(model.oidcConfig);
        }

        public final String getWorkforceName() {
            return this.workforceName;
        }

        @Override
        public final Builder workforceName(String workforceName) {
            this.workforceName = workforceName;
            return this;
        }

        public final void setWorkforceName(String workforceName) {
            this.workforceName = workforceName;
        }

        public final SourceIpConfig.Builder getSourceIpConfig() {
            return this.sourceIpConfig != null ? this.sourceIpConfig.toBuilder() : null;
        }

        @Override
        public final Builder sourceIpConfig(SourceIpConfig sourceIpConfig) {
            this.sourceIpConfig = sourceIpConfig;
            return this;
        }

        public final void setSourceIpConfig(SourceIpConfig.BuilderImpl sourceIpConfig) {
            this.sourceIpConfig = sourceIpConfig != null ? sourceIpConfig.build() : null;
        }

        public final OidcConfig.Builder getOidcConfig() {
            return this.oidcConfig != null ? this.oidcConfig.toBuilder() : null;
        }

        @Override
        public final Builder oidcConfig(OidcConfig oidcConfig) {
            this.oidcConfig = oidcConfig;
            return this;
        }

        public final void setOidcConfig(OidcConfig.BuilderImpl oidcConfig) {
            this.oidcConfig = oidcConfig != null ? oidcConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkforceRequest build() {
            return new UpdateWorkforceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkforceRequest> {
        public Builder workforceName(String var1);

        public Builder sourceIpConfig(SourceIpConfig var1);

        default public Builder sourceIpConfig(Consumer<SourceIpConfig.Builder> sourceIpConfig) {
            return this.sourceIpConfig((SourceIpConfig)((SourceIpConfig.Builder)SourceIpConfig.builder().applyMutation(sourceIpConfig)).build());
        }

        public Builder oidcConfig(OidcConfig var1);

        default public Builder oidcConfig(Consumer<OidcConfig.Builder> oidcConfig) {
            return this.oidcConfig((OidcConfig)((OidcConfig.Builder)OidcConfig.builder().applyMutation(oidcConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

