/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.EdgeOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDeviceFleetRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateDeviceFleetRequest> {
    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceFleetName").getter(UpdateDeviceFleetRequest.getter(UpdateDeviceFleetRequest::deviceFleetName)).setter(UpdateDeviceFleetRequest.setter(Builder::deviceFleetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(UpdateDeviceFleetRequest.getter(UpdateDeviceFleetRequest::roleArn)).setter(UpdateDeviceFleetRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateDeviceFleetRequest.getter(UpdateDeviceFleetRequest::description)).setter(UpdateDeviceFleetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<EdgeOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(UpdateDeviceFleetRequest.getter(UpdateDeviceFleetRequest::outputConfig)).setter(UpdateDeviceFleetRequest.setter(Builder::outputConfig)).constructor(EdgeOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<Boolean> ENABLE_IOT_ROLE_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableIotRoleAlias").getter(UpdateDeviceFleetRequest.getter(UpdateDeviceFleetRequest::enableIotRoleAlias)).setter(UpdateDeviceFleetRequest.setter(Builder::enableIotRoleAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIotRoleAlias").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_FLEET_NAME_FIELD, ROLE_ARN_FIELD, DESCRIPTION_FIELD, OUTPUT_CONFIG_FIELD, ENABLE_IOT_ROLE_ALIAS_FIELD));
    private final String deviceFleetName;
    private final String roleArn;
    private final String description;
    private final EdgeOutputConfig outputConfig;
    private final Boolean enableIotRoleAlias;

    private UpdateDeviceFleetRequest(BuilderImpl builder) {
        super(builder);
        this.deviceFleetName = builder.deviceFleetName;
        this.roleArn = builder.roleArn;
        this.description = builder.description;
        this.outputConfig = builder.outputConfig;
        this.enableIotRoleAlias = builder.enableIotRoleAlias;
    }

    public final String deviceFleetName() {
        return this.deviceFleetName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String description() {
        return this.description;
    }

    public final EdgeOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final Boolean enableIotRoleAlias() {
        return this.enableIotRoleAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceFleetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableIotRoleAlias());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeviceFleetRequest)) {
            return false;
        }
        UpdateDeviceFleetRequest other = (UpdateDeviceFleetRequest)((Object)obj);
        return Objects.equals(this.deviceFleetName(), other.deviceFleetName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.enableIotRoleAlias(), other.enableIotRoleAlias());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDeviceFleetRequest").add("DeviceFleetName", (Object)this.deviceFleetName()).add("RoleArn", (Object)this.roleArn()).add("Description", (Object)this.description()).add("OutputConfig", (Object)this.outputConfig()).add("EnableIotRoleAlias", (Object)this.enableIotRoleAlias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceFleetName": {
                return Optional.ofNullable(clazz.cast(this.deviceFleetName()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "EnableIotRoleAlias": {
                return Optional.ofNullable(clazz.cast(this.enableIotRoleAlias()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDeviceFleetRequest, T> g) {
        return obj -> g.apply((UpdateDeviceFleetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String deviceFleetName;
        private String roleArn;
        private String description;
        private EdgeOutputConfig outputConfig;
        private Boolean enableIotRoleAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeviceFleetRequest model) {
            super(model);
            this.deviceFleetName(model.deviceFleetName);
            this.roleArn(model.roleArn);
            this.description(model.description);
            this.outputConfig(model.outputConfig);
            this.enableIotRoleAlias(model.enableIotRoleAlias);
        }

        public final String getDeviceFleetName() {
            return this.deviceFleetName;
        }

        @Override
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final EdgeOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputConfig(EdgeOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final void setOutputConfig(EdgeOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        public final Boolean getEnableIotRoleAlias() {
            return this.enableIotRoleAlias;
        }

        @Override
        public final Builder enableIotRoleAlias(Boolean enableIotRoleAlias) {
            this.enableIotRoleAlias = enableIotRoleAlias;
            return this;
        }

        public final void setEnableIotRoleAlias(Boolean enableIotRoleAlias) {
            this.enableIotRoleAlias = enableIotRoleAlias;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDeviceFleetRequest build() {
            return new UpdateDeviceFleetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDeviceFleetRequest> {
        public Builder deviceFleetName(String var1);

        public Builder roleArn(String var1);

        public Builder description(String var1);

        public Builder outputConfig(EdgeOutputConfig var1);

        default public Builder outputConfig(Consumer<EdgeOutputConfig.Builder> outputConfig) {
            return this.outputConfig((EdgeOutputConfig)((EdgeOutputConfig.Builder)EdgeOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder enableIotRoleAlias(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

