/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SortOrder;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobSortByOptions;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrainingJobsForHyperParameterTuningJobRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, ListTrainingJobsForHyperParameterTuningJobRequest> {
    private static final SdkField<String> HYPER_PARAMETER_TUNING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HyperParameterTuningJobName").getter(ListTrainingJobsForHyperParameterTuningJobRequest.getter(ListTrainingJobsForHyperParameterTuningJobRequest::hyperParameterTuningJobName)).setter(ListTrainingJobsForHyperParameterTuningJobRequest.setter(Builder::hyperParameterTuningJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobName").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTrainingJobsForHyperParameterTuningJobRequest.getter(ListTrainingJobsForHyperParameterTuningJobRequest::nextToken)).setter(ListTrainingJobsForHyperParameterTuningJobRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListTrainingJobsForHyperParameterTuningJobRequest.getter(ListTrainingJobsForHyperParameterTuningJobRequest::maxResults)).setter(ListTrainingJobsForHyperParameterTuningJobRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusEquals").getter(ListTrainingJobsForHyperParameterTuningJobRequest.getter(ListTrainingJobsForHyperParameterTuningJobRequest::statusEqualsAsString)).setter(ListTrainingJobsForHyperParameterTuningJobRequest.setter(Builder::statusEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusEquals").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortBy").getter(ListTrainingJobsForHyperParameterTuningJobRequest.getter(ListTrainingJobsForHyperParameterTuningJobRequest::sortByAsString)).setter(ListTrainingJobsForHyperParameterTuningJobRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(ListTrainingJobsForHyperParameterTuningJobRequest.getter(ListTrainingJobsForHyperParameterTuningJobRequest::sortOrderAsString)).setter(ListTrainingJobsForHyperParameterTuningJobRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HYPER_PARAMETER_TUNING_JOB_NAME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STATUS_EQUALS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));
    private final String hyperParameterTuningJobName;
    private final String nextToken;
    private final Integer maxResults;
    private final String statusEquals;
    private final String sortBy;
    private final String sortOrder;

    private ListTrainingJobsForHyperParameterTuningJobRequest(BuilderImpl builder) {
        super(builder);
        this.hyperParameterTuningJobName = builder.hyperParameterTuningJobName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.statusEquals = builder.statusEquals;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    public final String hyperParameterTuningJobName() {
        return this.hyperParameterTuningJobName;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final TrainingJobStatus statusEquals() {
        return TrainingJobStatus.fromValue(this.statusEquals);
    }

    public final String statusEqualsAsString() {
        return this.statusEquals;
    }

    public final TrainingJobSortByOptions sortBy() {
        return TrainingJobSortByOptions.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameterTuningJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrainingJobsForHyperParameterTuningJobRequest)) {
            return false;
        }
        ListTrainingJobsForHyperParameterTuningJobRequest other = (ListTrainingJobsForHyperParameterTuningJobRequest)((Object)obj);
        return Objects.equals(this.hyperParameterTuningJobName(), other.hyperParameterTuningJobName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.statusEqualsAsString(), other.statusEqualsAsString()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrainingJobsForHyperParameterTuningJobRequest").add("HyperParameterTuningJobName", (Object)this.hyperParameterTuningJobName()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("StatusEquals", (Object)this.statusEqualsAsString()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HyperParameterTuningJobName": {
                return Optional.ofNullable(clazz.cast(this.hyperParameterTuningJobName()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "StatusEquals": {
                return Optional.ofNullable(clazz.cast(this.statusEqualsAsString()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrainingJobsForHyperParameterTuningJobRequest, T> g) {
        return obj -> g.apply((ListTrainingJobsForHyperParameterTuningJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String hyperParameterTuningJobName;
        private String nextToken;
        private Integer maxResults;
        private String statusEquals;
        private String sortBy;
        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrainingJobsForHyperParameterTuningJobRequest model) {
            super(model);
            this.hyperParameterTuningJobName(model.hyperParameterTuningJobName);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.statusEquals(model.statusEquals);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
        }

        public final String getHyperParameterTuningJobName() {
            return this.hyperParameterTuningJobName;
        }

        @Override
        public final Builder hyperParameterTuningJobName(String hyperParameterTuningJobName) {
            this.hyperParameterTuningJobName = hyperParameterTuningJobName;
            return this;
        }

        public final void setHyperParameterTuningJobName(String hyperParameterTuningJobName) {
            this.hyperParameterTuningJobName = hyperParameterTuningJobName;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getStatusEquals() {
            return this.statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(TrainingJobStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(TrainingJobSortByOptions sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTrainingJobsForHyperParameterTuningJobRequest build() {
            return new ListTrainingJobsForHyperParameterTuningJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrainingJobsForHyperParameterTuningJobRequest> {
        public Builder hyperParameterTuningJobName(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder statusEquals(String var1);

        public Builder statusEquals(TrainingJobStatus var1);

        public Builder sortBy(String var1);

        public Builder sortBy(TrainingJobSortByOptions var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

