/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AssociationEdgeType {
    CONTRIBUTED_TO("ContributedTo"),
    ASSOCIATED_WITH("AssociatedWith"),
    DERIVED_FROM("DerivedFrom"),
    PRODUCED("Produced"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AssociationEdgeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AssociationEdgeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AssociationEdgeType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AssociationEdgeType> knownValues() {
        return Stream.of(AssociationEdgeType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

