/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ContainerDefinition;
import software.amazon.awssdk.services.sagemaker.model.ContainerDefinitionListCopier;
import software.amazon.awssdk.services.sagemaker.model.InferenceExecutionConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateModelRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateModelRequest> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(CreateModelRequest.getter(CreateModelRequest::modelName)).setter(CreateModelRequest.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<ContainerDefinition> PRIMARY_CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrimaryContainer").getter(CreateModelRequest.getter(CreateModelRequest::primaryContainer)).setter(CreateModelRequest.setter(Builder::primaryContainer)).constructor(ContainerDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryContainer").build()}).build();
    private static final SdkField<List<ContainerDefinition>> CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Containers").getter(CreateModelRequest.getter(CreateModelRequest::containers)).setter(CreateModelRequest.setter(Builder::containers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Containers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InferenceExecutionConfig> INFERENCE_EXECUTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InferenceExecutionConfig").getter(CreateModelRequest.getter(CreateModelRequest::inferenceExecutionConfig)).setter(CreateModelRequest.setter(Builder::inferenceExecutionConfig)).constructor(InferenceExecutionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceExecutionConfig").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(CreateModelRequest.getter(CreateModelRequest::executionRoleArn)).setter(CreateModelRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateModelRequest.getter(CreateModelRequest::tags)).setter(CreateModelRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(CreateModelRequest.getter(CreateModelRequest::vpcConfig)).setter(CreateModelRequest.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<Boolean> ENABLE_NETWORK_ISOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableNetworkIsolation").getter(CreateModelRequest.getter(CreateModelRequest::enableNetworkIsolation)).setter(CreateModelRequest.setter(Builder::enableNetworkIsolation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableNetworkIsolation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, PRIMARY_CONTAINER_FIELD, CONTAINERS_FIELD, INFERENCE_EXECUTION_CONFIG_FIELD, EXECUTION_ROLE_ARN_FIELD, TAGS_FIELD, VPC_CONFIG_FIELD, ENABLE_NETWORK_ISOLATION_FIELD));
    private final String modelName;
    private final ContainerDefinition primaryContainer;
    private final List<ContainerDefinition> containers;
    private final InferenceExecutionConfig inferenceExecutionConfig;
    private final String executionRoleArn;
    private final List<Tag> tags;
    private final VpcConfig vpcConfig;
    private final Boolean enableNetworkIsolation;

    private CreateModelRequest(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.primaryContainer = builder.primaryContainer;
        this.containers = builder.containers;
        this.inferenceExecutionConfig = builder.inferenceExecutionConfig;
        this.executionRoleArn = builder.executionRoleArn;
        this.tags = builder.tags;
        this.vpcConfig = builder.vpcConfig;
        this.enableNetworkIsolation = builder.enableNetworkIsolation;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final ContainerDefinition primaryContainer() {
        return this.primaryContainer;
    }

    public final boolean hasContainers() {
        return this.containers != null && !(this.containers instanceof SdkAutoConstructList);
    }

    public final List<ContainerDefinition> containers() {
        return this.containers;
    }

    public final InferenceExecutionConfig inferenceExecutionConfig() {
        return this.inferenceExecutionConfig;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final Boolean enableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryContainer());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainers() ? this.containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceExecutionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableNetworkIsolation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelRequest)) {
            return false;
        }
        CreateModelRequest other = (CreateModelRequest)((Object)obj);
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.primaryContainer(), other.primaryContainer()) && this.hasContainers() == other.hasContainers() && Objects.equals(this.containers(), other.containers()) && Objects.equals(this.inferenceExecutionConfig(), other.inferenceExecutionConfig()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.enableNetworkIsolation(), other.enableNetworkIsolation());
    }

    public final String toString() {
        return ToString.builder((String)"CreateModelRequest").add("ModelName", (Object)this.modelName()).add("PrimaryContainer", (Object)this.primaryContainer()).add("Containers", this.hasContainers() ? this.containers() : null).add("InferenceExecutionConfig", (Object)this.inferenceExecutionConfig()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("Tags", this.hasTags() ? this.tags() : null).add("VpcConfig", (Object)this.vpcConfig()).add("EnableNetworkIsolation", (Object)this.enableNetworkIsolation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "PrimaryContainer": {
                return Optional.ofNullable(clazz.cast(this.primaryContainer()));
            }
            case "Containers": {
                return Optional.ofNullable(clazz.cast(this.containers()));
            }
            case "InferenceExecutionConfig": {
                return Optional.ofNullable(clazz.cast(this.inferenceExecutionConfig()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "EnableNetworkIsolation": {
                return Optional.ofNullable(clazz.cast(this.enableNetworkIsolation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelRequest, T> g) {
        return obj -> g.apply((CreateModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String modelName;
        private ContainerDefinition primaryContainer;
        private List<ContainerDefinition> containers = DefaultSdkAutoConstructList.getInstance();
        private InferenceExecutionConfig inferenceExecutionConfig;
        private String executionRoleArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private VpcConfig vpcConfig;
        private Boolean enableNetworkIsolation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelRequest model) {
            super(model);
            this.modelName(model.modelName);
            this.primaryContainer(model.primaryContainer);
            this.containers(model.containers);
            this.inferenceExecutionConfig(model.inferenceExecutionConfig);
            this.executionRoleArn(model.executionRoleArn);
            this.tags(model.tags);
            this.vpcConfig(model.vpcConfig);
            this.enableNetworkIsolation(model.enableNetworkIsolation);
        }

        public final String getModelName() {
            return this.modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public final ContainerDefinition.Builder getPrimaryContainer() {
            return this.primaryContainer != null ? this.primaryContainer.toBuilder() : null;
        }

        @Override
        public final Builder primaryContainer(ContainerDefinition primaryContainer) {
            this.primaryContainer = primaryContainer;
            return this;
        }

        public final void setPrimaryContainer(ContainerDefinition.BuilderImpl primaryContainer) {
            this.primaryContainer = primaryContainer != null ? primaryContainer.build() : null;
        }

        public final List<ContainerDefinition.Builder> getContainers() {
            List<ContainerDefinition.Builder> result = ContainerDefinitionListCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder containers(Collection<ContainerDefinition> containers) {
            this.containers = ContainerDefinitionListCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(ContainerDefinition ... containers) {
            this.containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<ContainerDefinition.Builder> ... containers) {
            this.containers(Stream.of(containers).map(c -> (ContainerDefinition)((ContainerDefinition.Builder)ContainerDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContainers(Collection<ContainerDefinition.BuilderImpl> containers) {
            this.containers = ContainerDefinitionListCopier.copyFromBuilder(containers);
        }

        public final InferenceExecutionConfig.Builder getInferenceExecutionConfig() {
            return this.inferenceExecutionConfig != null ? this.inferenceExecutionConfig.toBuilder() : null;
        }

        @Override
        public final Builder inferenceExecutionConfig(InferenceExecutionConfig inferenceExecutionConfig) {
            this.inferenceExecutionConfig = inferenceExecutionConfig;
            return this;
        }

        public final void setInferenceExecutionConfig(InferenceExecutionConfig.BuilderImpl inferenceExecutionConfig) {
            this.inferenceExecutionConfig = inferenceExecutionConfig != null ? inferenceExecutionConfig.build() : null;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final Boolean getEnableNetworkIsolation() {
            return this.enableNetworkIsolation;
        }

        @Override
        public final Builder enableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
            return this;
        }

        public final void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelRequest build() {
            return new CreateModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateModelRequest> {
        public Builder modelName(String var1);

        public Builder primaryContainer(ContainerDefinition var1);

        default public Builder primaryContainer(Consumer<ContainerDefinition.Builder> primaryContainer) {
            return this.primaryContainer((ContainerDefinition)((ContainerDefinition.Builder)ContainerDefinition.builder().applyMutation(primaryContainer)).build());
        }

        public Builder containers(Collection<ContainerDefinition> var1);

        public Builder containers(ContainerDefinition ... var1);

        public Builder containers(Consumer<ContainerDefinition.Builder> ... var1);

        public Builder inferenceExecutionConfig(InferenceExecutionConfig var1);

        default public Builder inferenceExecutionConfig(Consumer<InferenceExecutionConfig.Builder> inferenceExecutionConfig) {
            return this.inferenceExecutionConfig((InferenceExecutionConfig)((InferenceExecutionConfig.Builder)InferenceExecutionConfig.builder().applyMutation(inferenceExecutionConfig)).build());
        }

        public Builder executionRoleArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder enableNetworkIsolation(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

