/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.CandidateStepType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoMLCandidateStep
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoMLCandidateStep> {
    private static final SdkField<String> CANDIDATE_STEP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CandidateStepType").getter(AutoMLCandidateStep.getter(AutoMLCandidateStep::candidateStepTypeAsString)).setter(AutoMLCandidateStep.setter(Builder::candidateStepType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateStepType").build()}).build();
    private static final SdkField<String> CANDIDATE_STEP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CandidateStepArn").getter(AutoMLCandidateStep.getter(AutoMLCandidateStep::candidateStepArn)).setter(AutoMLCandidateStep.setter(Builder::candidateStepArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateStepArn").build()}).build();
    private static final SdkField<String> CANDIDATE_STEP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CandidateStepName").getter(AutoMLCandidateStep.getter(AutoMLCandidateStep::candidateStepName)).setter(AutoMLCandidateStep.setter(Builder::candidateStepName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateStepName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANDIDATE_STEP_TYPE_FIELD, CANDIDATE_STEP_ARN_FIELD, CANDIDATE_STEP_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String candidateStepType;
    private final String candidateStepArn;
    private final String candidateStepName;

    private AutoMLCandidateStep(BuilderImpl builder) {
        this.candidateStepType = builder.candidateStepType;
        this.candidateStepArn = builder.candidateStepArn;
        this.candidateStepName = builder.candidateStepName;
    }

    public final CandidateStepType candidateStepType() {
        return CandidateStepType.fromValue(this.candidateStepType);
    }

    public final String candidateStepTypeAsString() {
        return this.candidateStepType;
    }

    public final String candidateStepArn() {
        return this.candidateStepArn;
    }

    public final String candidateStepName() {
        return this.candidateStepName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.candidateStepTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.candidateStepArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.candidateStepName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLCandidateStep)) {
            return false;
        }
        AutoMLCandidateStep other = (AutoMLCandidateStep)obj;
        return Objects.equals(this.candidateStepTypeAsString(), other.candidateStepTypeAsString()) && Objects.equals(this.candidateStepArn(), other.candidateStepArn()) && Objects.equals(this.candidateStepName(), other.candidateStepName());
    }

    public final String toString() {
        return ToString.builder((String)"AutoMLCandidateStep").add("CandidateStepType", (Object)this.candidateStepTypeAsString()).add("CandidateStepArn", (Object)this.candidateStepArn()).add("CandidateStepName", (Object)this.candidateStepName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CandidateStepType": {
                return Optional.ofNullable(clazz.cast(this.candidateStepTypeAsString()));
            }
            case "CandidateStepArn": {
                return Optional.ofNullable(clazz.cast(this.candidateStepArn()));
            }
            case "CandidateStepName": {
                return Optional.ofNullable(clazz.cast(this.candidateStepName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLCandidateStep, T> g) {
        return obj -> g.apply((AutoMLCandidateStep)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String candidateStepType;
        private String candidateStepArn;
        private String candidateStepName;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLCandidateStep model) {
            this.candidateStepType(model.candidateStepType);
            this.candidateStepArn(model.candidateStepArn);
            this.candidateStepName(model.candidateStepName);
        }

        public final String getCandidateStepType() {
            return this.candidateStepType;
        }

        @Override
        public final Builder candidateStepType(String candidateStepType) {
            this.candidateStepType = candidateStepType;
            return this;
        }

        @Override
        public final Builder candidateStepType(CandidateStepType candidateStepType) {
            this.candidateStepType(candidateStepType == null ? null : candidateStepType.toString());
            return this;
        }

        public final void setCandidateStepType(String candidateStepType) {
            this.candidateStepType = candidateStepType;
        }

        public final String getCandidateStepArn() {
            return this.candidateStepArn;
        }

        @Override
        public final Builder candidateStepArn(String candidateStepArn) {
            this.candidateStepArn = candidateStepArn;
            return this;
        }

        public final void setCandidateStepArn(String candidateStepArn) {
            this.candidateStepArn = candidateStepArn;
        }

        public final String getCandidateStepName() {
            return this.candidateStepName;
        }

        @Override
        public final Builder candidateStepName(String candidateStepName) {
            this.candidateStepName = candidateStepName;
            return this;
        }

        public final void setCandidateStepName(String candidateStepName) {
            this.candidateStepName = candidateStepName;
        }

        public AutoMLCandidateStep build() {
            return new AutoMLCandidateStep(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoMLCandidateStep> {
        public Builder candidateStepType(String var1);

        public Builder candidateStepType(CandidateStepType var1);

        public Builder candidateStepArn(String var1);

        public Builder candidateStepName(String var1);
    }
}

