/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ModelApprovalStatus;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelPackageSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelPackageSummary> {
    private static final SdkField<String> MODEL_PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageName").getter(ModelPackageSummary.getter(ModelPackageSummary::modelPackageName)).setter(ModelPackageSummary.setter(Builder::modelPackageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageName").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageGroupName").getter(ModelPackageSummary.getter(ModelPackageSummary::modelPackageGroupName)).setter(ModelPackageSummary.setter(Builder::modelPackageGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupName").build()}).build();
    private static final SdkField<Integer> MODEL_PACKAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ModelPackageVersion").getter(ModelPackageSummary.getter(ModelPackageSummary::modelPackageVersion)).setter(ModelPackageSummary.setter(Builder::modelPackageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageVersion").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageArn").getter(ModelPackageSummary.getter(ModelPackageSummary::modelPackageArn)).setter(ModelPackageSummary.setter(Builder::modelPackageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageArn").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageDescription").getter(ModelPackageSummary.getter(ModelPackageSummary::modelPackageDescription)).setter(ModelPackageSummary.setter(Builder::modelPackageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageDescription").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ModelPackageSummary.getter(ModelPackageSummary::creationTime)).setter(ModelPackageSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageStatus").getter(ModelPackageSummary.getter(ModelPackageSummary::modelPackageStatusAsString)).setter(ModelPackageSummary.setter(Builder::modelPackageStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageStatus").build()}).build();
    private static final SdkField<String> MODEL_APPROVAL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelApprovalStatus").getter(ModelPackageSummary.getter(ModelPackageSummary::modelApprovalStatusAsString)).setter(ModelPackageSummary.setter(Builder::modelApprovalStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelApprovalStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_NAME_FIELD, MODEL_PACKAGE_GROUP_NAME_FIELD, MODEL_PACKAGE_VERSION_FIELD, MODEL_PACKAGE_ARN_FIELD, MODEL_PACKAGE_DESCRIPTION_FIELD, CREATION_TIME_FIELD, MODEL_PACKAGE_STATUS_FIELD, MODEL_APPROVAL_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String modelPackageName;
    private final String modelPackageGroupName;
    private final Integer modelPackageVersion;
    private final String modelPackageArn;
    private final String modelPackageDescription;
    private final Instant creationTime;
    private final String modelPackageStatus;
    private final String modelApprovalStatus;

    private ModelPackageSummary(BuilderImpl builder) {
        this.modelPackageName = builder.modelPackageName;
        this.modelPackageGroupName = builder.modelPackageGroupName;
        this.modelPackageVersion = builder.modelPackageVersion;
        this.modelPackageArn = builder.modelPackageArn;
        this.modelPackageDescription = builder.modelPackageDescription;
        this.creationTime = builder.creationTime;
        this.modelPackageStatus = builder.modelPackageStatus;
        this.modelApprovalStatus = builder.modelApprovalStatus;
    }

    public final String modelPackageName() {
        return this.modelPackageName;
    }

    public final String modelPackageGroupName() {
        return this.modelPackageGroupName;
    }

    public final Integer modelPackageVersion() {
        return this.modelPackageVersion;
    }

    public final String modelPackageArn() {
        return this.modelPackageArn;
    }

    public final String modelPackageDescription() {
        return this.modelPackageDescription;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final ModelPackageStatus modelPackageStatus() {
        return ModelPackageStatus.fromValue(this.modelPackageStatus);
    }

    public final String modelPackageStatusAsString() {
        return this.modelPackageStatus;
    }

    public final ModelApprovalStatus modelApprovalStatus() {
        return ModelApprovalStatus.fromValue(this.modelApprovalStatus);
    }

    public final String modelApprovalStatusAsString() {
        return this.modelApprovalStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelApprovalStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackageSummary)) {
            return false;
        }
        ModelPackageSummary other = (ModelPackageSummary)obj;
        return Objects.equals(this.modelPackageName(), other.modelPackageName()) && Objects.equals(this.modelPackageGroupName(), other.modelPackageGroupName()) && Objects.equals(this.modelPackageVersion(), other.modelPackageVersion()) && Objects.equals(this.modelPackageArn(), other.modelPackageArn()) && Objects.equals(this.modelPackageDescription(), other.modelPackageDescription()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.modelPackageStatusAsString(), other.modelPackageStatusAsString()) && Objects.equals(this.modelApprovalStatusAsString(), other.modelApprovalStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModelPackageSummary").add("ModelPackageName", (Object)this.modelPackageName()).add("ModelPackageGroupName", (Object)this.modelPackageGroupName()).add("ModelPackageVersion", (Object)this.modelPackageVersion()).add("ModelPackageArn", (Object)this.modelPackageArn()).add("ModelPackageDescription", (Object)this.modelPackageDescription()).add("CreationTime", (Object)this.creationTime()).add("ModelPackageStatus", (Object)this.modelPackageStatusAsString()).add("ModelApprovalStatus", (Object)this.modelApprovalStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelPackageName": {
                return Optional.ofNullable(clazz.cast(this.modelPackageName()));
            }
            case "ModelPackageGroupName": {
                return Optional.ofNullable(clazz.cast(this.modelPackageGroupName()));
            }
            case "ModelPackageVersion": {
                return Optional.ofNullable(clazz.cast(this.modelPackageVersion()));
            }
            case "ModelPackageArn": {
                return Optional.ofNullable(clazz.cast(this.modelPackageArn()));
            }
            case "ModelPackageDescription": {
                return Optional.ofNullable(clazz.cast(this.modelPackageDescription()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ModelPackageStatus": {
                return Optional.ofNullable(clazz.cast(this.modelPackageStatusAsString()));
            }
            case "ModelApprovalStatus": {
                return Optional.ofNullable(clazz.cast(this.modelApprovalStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelPackageSummary, T> g) {
        return obj -> g.apply((ModelPackageSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelPackageName;
        private String modelPackageGroupName;
        private Integer modelPackageVersion;
        private String modelPackageArn;
        private String modelPackageDescription;
        private Instant creationTime;
        private String modelPackageStatus;
        private String modelApprovalStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackageSummary model) {
            this.modelPackageName(model.modelPackageName);
            this.modelPackageGroupName(model.modelPackageGroupName);
            this.modelPackageVersion(model.modelPackageVersion);
            this.modelPackageArn(model.modelPackageArn);
            this.modelPackageDescription(model.modelPackageDescription);
            this.creationTime(model.creationTime);
            this.modelPackageStatus(model.modelPackageStatus);
            this.modelApprovalStatus(model.modelApprovalStatus);
        }

        public final String getModelPackageName() {
            return this.modelPackageName;
        }

        @Override
        public final Builder modelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
            return this;
        }

        public final void setModelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
        }

        public final String getModelPackageGroupName() {
            return this.modelPackageGroupName;
        }

        @Override
        public final Builder modelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
            return this;
        }

        public final void setModelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
        }

        public final Integer getModelPackageVersion() {
            return this.modelPackageVersion;
        }

        @Override
        public final Builder modelPackageVersion(Integer modelPackageVersion) {
            this.modelPackageVersion = modelPackageVersion;
            return this;
        }

        public final void setModelPackageVersion(Integer modelPackageVersion) {
            this.modelPackageVersion = modelPackageVersion;
        }

        public final String getModelPackageArn() {
            return this.modelPackageArn;
        }

        @Override
        public final Builder modelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
            return this;
        }

        public final void setModelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
        }

        public final String getModelPackageDescription() {
            return this.modelPackageDescription;
        }

        @Override
        public final Builder modelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
            return this;
        }

        public final void setModelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getModelPackageStatus() {
            return this.modelPackageStatus;
        }

        @Override
        public final Builder modelPackageStatus(String modelPackageStatus) {
            this.modelPackageStatus = modelPackageStatus;
            return this;
        }

        @Override
        public final Builder modelPackageStatus(ModelPackageStatus modelPackageStatus) {
            this.modelPackageStatus(modelPackageStatus == null ? null : modelPackageStatus.toString());
            return this;
        }

        public final void setModelPackageStatus(String modelPackageStatus) {
            this.modelPackageStatus = modelPackageStatus;
        }

        public final String getModelApprovalStatus() {
            return this.modelApprovalStatus;
        }

        @Override
        public final Builder modelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
            return this;
        }

        @Override
        public final Builder modelApprovalStatus(ModelApprovalStatus modelApprovalStatus) {
            this.modelApprovalStatus(modelApprovalStatus == null ? null : modelApprovalStatus.toString());
            return this;
        }

        public final void setModelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
        }

        public ModelPackageSummary build() {
            return new ModelPackageSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelPackageSummary> {
        public Builder modelPackageName(String var1);

        public Builder modelPackageGroupName(String var1);

        public Builder modelPackageVersion(Integer var1);

        public Builder modelPackageArn(String var1);

        public Builder modelPackageDescription(String var1);

        public Builder creationTime(Instant var1);

        public Builder modelPackageStatus(String var1);

        public Builder modelPackageStatus(ModelPackageStatus var1);

        public Builder modelApprovalStatus(String var1);

        public Builder modelApprovalStatus(ModelApprovalStatus var1);
    }
}

