/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageSummary;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListModelPackagesResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListModelPackagesResponse> {
    private static final SdkField<List<ModelPackageSummary>> MODEL_PACKAGE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModelPackageSummaryList").getter(ListModelPackagesResponse.getter(ListModelPackagesResponse::modelPackageSummaryList)).setter(ListModelPackagesResponse.setter(Builder::modelPackageSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelPackageSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListModelPackagesResponse.getter(ListModelPackagesResponse::nextToken)).setter(ListModelPackagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<ModelPackageSummary> modelPackageSummaryList;
    private final String nextToken;

    private ListModelPackagesResponse(BuilderImpl builder) {
        super(builder);
        this.modelPackageSummaryList = builder.modelPackageSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasModelPackageSummaryList() {
        return this.modelPackageSummaryList != null && !(this.modelPackageSummaryList instanceof SdkAutoConstructList);
    }

    public final List<ModelPackageSummary> modelPackageSummaryList() {
        return this.modelPackageSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelPackageSummaryList() ? this.modelPackageSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelPackagesResponse)) {
            return false;
        }
        ListModelPackagesResponse other = (ListModelPackagesResponse)((Object)obj);
        return this.hasModelPackageSummaryList() == other.hasModelPackageSummaryList() && Objects.equals(this.modelPackageSummaryList(), other.modelPackageSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListModelPackagesResponse").add("ModelPackageSummaryList", this.hasModelPackageSummaryList() ? this.modelPackageSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelPackageSummaryList": {
                return Optional.ofNullable(clazz.cast(this.modelPackageSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelPackagesResponse, T> g) {
        return obj -> g.apply((ListModelPackagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<ModelPackageSummary> modelPackageSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelPackagesResponse model) {
            super(model);
            this.modelPackageSummaryList(model.modelPackageSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<ModelPackageSummary.Builder> getModelPackageSummaryList() {
            List<ModelPackageSummary.Builder> result = ModelPackageSummaryListCopier.copyToBuilder(this.modelPackageSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder modelPackageSummaryList(Collection<ModelPackageSummary> modelPackageSummaryList) {
            this.modelPackageSummaryList = ModelPackageSummaryListCopier.copy(modelPackageSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelPackageSummaryList(ModelPackageSummary ... modelPackageSummaryList) {
            this.modelPackageSummaryList(Arrays.asList(modelPackageSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelPackageSummaryList(Consumer<ModelPackageSummary.Builder> ... modelPackageSummaryList) {
            this.modelPackageSummaryList(Stream.of(modelPackageSummaryList).map(c -> (ModelPackageSummary)((ModelPackageSummary.Builder)ModelPackageSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModelPackageSummaryList(Collection<ModelPackageSummary.BuilderImpl> modelPackageSummaryList) {
            this.modelPackageSummaryList = ModelPackageSummaryListCopier.copyFromBuilder(modelPackageSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListModelPackagesResponse build() {
            return new ListModelPackagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListModelPackagesResponse> {
        public Builder modelPackageSummaryList(Collection<ModelPackageSummary> var1);

        public Builder modelPackageSummaryList(ModelPackageSummary ... var1);

        public Builder modelPackageSummaryList(Consumer<ModelPackageSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

