/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.FeatureGroupSummary;
import software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsResponse;

public class ListFeatureGroupsIterable
implements SdkIterable<ListFeatureGroupsResponse> {
    private final SageMakerClient client;
    private final ListFeatureGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFeatureGroupsIterable(SageMakerClient client, ListFeatureGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFeatureGroupsResponseFetcher();
    }

    public Iterator<ListFeatureGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FeatureGroupSummary> featureGroupSummaries() {
        Function<ListFeatureGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.featureGroupSummaries() != null) {
                return response.featureGroupSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFeatureGroupsResponseFetcher
    implements SyncPageFetcher<ListFeatureGroupsResponse> {
        private ListFeatureGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListFeatureGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFeatureGroupsResponse nextPage(ListFeatureGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListFeatureGroupsIterable.this.client.listFeatureGroups(ListFeatureGroupsIterable.this.firstRequest);
            }
            return ListFeatureGroupsIterable.this.client.listFeatureGroups((ListFeatureGroupsRequest)((Object)ListFeatureGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

