/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.MemberDefinition;
import software.amazon.awssdk.services.sagemaker.model.MemberDefinitionsCopier;
import software.amazon.awssdk.services.sagemaker.model.NotificationConfiguration;
import software.amazon.awssdk.services.sagemaker.model.ProductListingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Workteam
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Workteam> {
    private static final SdkField<String> WORKTEAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkteamName").getter(Workteam.getter(Workteam::workteamName)).setter(Workteam.setter(Builder::workteamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkteamName").build()}).build();
    private static final SdkField<List<MemberDefinition>> MEMBER_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MemberDefinitions").getter(Workteam.getter(Workteam::memberDefinitions)).setter(Workteam.setter(Builder::memberDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemberDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKTEAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkteamArn").getter(Workteam.getter(Workteam::workteamArn)).setter(Workteam.setter(Builder::workteamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkteamArn").build()}).build();
    private static final SdkField<String> WORKFORCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkforceArn").getter(Workteam.getter(Workteam::workforceArn)).setter(Workteam.setter(Builder::workforceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkforceArn").build()}).build();
    private static final SdkField<List<String>> PRODUCT_LISTING_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductListingIds").getter(Workteam.getter(Workteam::productListingIds)).setter(Workteam.setter(Builder::productListingIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductListingIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Workteam.getter(Workteam::description)).setter(Workteam.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SUB_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubDomain").getter(Workteam.getter(Workteam::subDomain)).setter(Workteam.setter(Builder::subDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubDomain").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(Workteam.getter(Workteam::createDate)).setter(Workteam.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedDate").getter(Workteam.getter(Workteam::lastUpdatedDate)).setter(Workteam.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDate").build()}).build();
    private static final SdkField<NotificationConfiguration> NOTIFICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationConfiguration").getter(Workteam.getter(Workteam::notificationConfiguration)).setter(Workteam.setter(Builder::notificationConfiguration)).constructor(NotificationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKTEAM_NAME_FIELD, MEMBER_DEFINITIONS_FIELD, WORKTEAM_ARN_FIELD, WORKFORCE_ARN_FIELD, PRODUCT_LISTING_IDS_FIELD, DESCRIPTION_FIELD, SUB_DOMAIN_FIELD, CREATE_DATE_FIELD, LAST_UPDATED_DATE_FIELD, NOTIFICATION_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String workteamName;
    private final List<MemberDefinition> memberDefinitions;
    private final String workteamArn;
    private final String workforceArn;
    private final List<String> productListingIds;
    private final String description;
    private final String subDomain;
    private final Instant createDate;
    private final Instant lastUpdatedDate;
    private final NotificationConfiguration notificationConfiguration;

    private Workteam(BuilderImpl builder) {
        this.workteamName = builder.workteamName;
        this.memberDefinitions = builder.memberDefinitions;
        this.workteamArn = builder.workteamArn;
        this.workforceArn = builder.workforceArn;
        this.productListingIds = builder.productListingIds;
        this.description = builder.description;
        this.subDomain = builder.subDomain;
        this.createDate = builder.createDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.notificationConfiguration = builder.notificationConfiguration;
    }

    public final String workteamName() {
        return this.workteamName;
    }

    public final boolean hasMemberDefinitions() {
        return this.memberDefinitions != null && !(this.memberDefinitions instanceof SdkAutoConstructList);
    }

    public final List<MemberDefinition> memberDefinitions() {
        return this.memberDefinitions;
    }

    public final String workteamArn() {
        return this.workteamArn;
    }

    public final String workforceArn() {
        return this.workforceArn;
    }

    public final boolean hasProductListingIds() {
        return this.productListingIds != null && !(this.productListingIds instanceof SdkAutoConstructList);
    }

    public final List<String> productListingIds() {
        return this.productListingIds;
    }

    public final String description() {
        return this.description;
    }

    public final String subDomain() {
        return this.subDomain;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public final NotificationConfiguration notificationConfiguration() {
        return this.notificationConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workteamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemberDefinitions() ? this.memberDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workteamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workforceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductListingIds() ? this.productListingIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.subDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workteam)) {
            return false;
        }
        Workteam other = (Workteam)obj;
        return Objects.equals(this.workteamName(), other.workteamName()) && this.hasMemberDefinitions() == other.hasMemberDefinitions() && Objects.equals(this.memberDefinitions(), other.memberDefinitions()) && Objects.equals(this.workteamArn(), other.workteamArn()) && Objects.equals(this.workforceArn(), other.workforceArn()) && this.hasProductListingIds() == other.hasProductListingIds() && Objects.equals(this.productListingIds(), other.productListingIds()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.subDomain(), other.subDomain()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(this.notificationConfiguration(), other.notificationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"Workteam").add("WorkteamName", (Object)this.workteamName()).add("MemberDefinitions", this.hasMemberDefinitions() ? this.memberDefinitions() : null).add("WorkteamArn", (Object)this.workteamArn()).add("WorkforceArn", (Object)this.workforceArn()).add("ProductListingIds", this.hasProductListingIds() ? this.productListingIds() : null).add("Description", (Object)this.description()).add("SubDomain", (Object)this.subDomain()).add("CreateDate", (Object)this.createDate()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).add("NotificationConfiguration", (Object)this.notificationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkteamName": {
                return Optional.ofNullable(clazz.cast(this.workteamName()));
            }
            case "MemberDefinitions": {
                return Optional.ofNullable(clazz.cast(this.memberDefinitions()));
            }
            case "WorkteamArn": {
                return Optional.ofNullable(clazz.cast(this.workteamArn()));
            }
            case "WorkforceArn": {
                return Optional.ofNullable(clazz.cast(this.workforceArn()));
            }
            case "ProductListingIds": {
                return Optional.ofNullable(clazz.cast(this.productListingIds()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "SubDomain": {
                return Optional.ofNullable(clazz.cast(this.subDomain()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "LastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
            case "NotificationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.notificationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Workteam, T> g) {
        return obj -> g.apply((Workteam)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workteamName;
        private List<MemberDefinition> memberDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String workteamArn;
        private String workforceArn;
        private List<String> productListingIds = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String subDomain;
        private Instant createDate;
        private Instant lastUpdatedDate;
        private NotificationConfiguration notificationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Workteam model) {
            this.workteamName(model.workteamName);
            this.memberDefinitions(model.memberDefinitions);
            this.workteamArn(model.workteamArn);
            this.workforceArn(model.workforceArn);
            this.productListingIds(model.productListingIds);
            this.description(model.description);
            this.subDomain(model.subDomain);
            this.createDate(model.createDate);
            this.lastUpdatedDate(model.lastUpdatedDate);
            this.notificationConfiguration(model.notificationConfiguration);
        }

        public final String getWorkteamName() {
            return this.workteamName;
        }

        @Override
        public final Builder workteamName(String workteamName) {
            this.workteamName = workteamName;
            return this;
        }

        public final void setWorkteamName(String workteamName) {
            this.workteamName = workteamName;
        }

        public final Collection<MemberDefinition.Builder> getMemberDefinitions() {
            if (this.memberDefinitions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.memberDefinitions != null ? (Collection)this.memberDefinitions.stream().map(MemberDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder memberDefinitions(Collection<MemberDefinition> memberDefinitions) {
            this.memberDefinitions = MemberDefinitionsCopier.copy(memberDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDefinitions(MemberDefinition ... memberDefinitions) {
            this.memberDefinitions(Arrays.asList(memberDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDefinitions(Consumer<MemberDefinition.Builder> ... memberDefinitions) {
            this.memberDefinitions(Stream.of(memberDefinitions).map(c -> (MemberDefinition)((MemberDefinition.Builder)MemberDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMemberDefinitions(Collection<MemberDefinition.BuilderImpl> memberDefinitions) {
            this.memberDefinitions = MemberDefinitionsCopier.copyFromBuilder(memberDefinitions);
        }

        public final String getWorkteamArn() {
            return this.workteamArn;
        }

        @Override
        public final Builder workteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
            return this;
        }

        public final void setWorkteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
        }

        public final String getWorkforceArn() {
            return this.workforceArn;
        }

        @Override
        public final Builder workforceArn(String workforceArn) {
            this.workforceArn = workforceArn;
            return this;
        }

        public final void setWorkforceArn(String workforceArn) {
            this.workforceArn = workforceArn;
        }

        public final Collection<String> getProductListingIds() {
            if (this.productListingIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.productListingIds;
        }

        @Override
        public final Builder productListingIds(Collection<String> productListingIds) {
            this.productListingIds = ProductListingsCopier.copy(productListingIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productListingIds(String ... productListingIds) {
            this.productListingIds(Arrays.asList(productListingIds));
            return this;
        }

        public final void setProductListingIds(Collection<String> productListingIds) {
            this.productListingIds = ProductListingsCopier.copy(productListingIds);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSubDomain() {
            return this.subDomain;
        }

        @Override
        public final Builder subDomain(String subDomain) {
            this.subDomain = subDomain;
            return this;
        }

        public final void setSubDomain(String subDomain) {
            this.subDomain = subDomain;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final NotificationConfiguration.Builder getNotificationConfiguration() {
            return this.notificationConfiguration != null ? this.notificationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder notificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final void setNotificationConfiguration(NotificationConfiguration.BuilderImpl notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration != null ? notificationConfiguration.build() : null;
        }

        public Workteam build() {
            return new Workteam(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Workteam> {
        public Builder workteamName(String var1);

        public Builder memberDefinitions(Collection<MemberDefinition> var1);

        public Builder memberDefinitions(MemberDefinition ... var1);

        public Builder memberDefinitions(Consumer<MemberDefinition.Builder> ... var1);

        public Builder workteamArn(String var1);

        public Builder workforceArn(String var1);

        public Builder productListingIds(Collection<String> var1);

        public Builder productListingIds(String ... var1);

        public Builder description(String var1);

        public Builder subDomain(String var1);

        public Builder createDate(Instant var1);

        public Builder lastUpdatedDate(Instant var1);

        public Builder notificationConfiguration(NotificationConfiguration var1);

        default public Builder notificationConfiguration(Consumer<NotificationConfiguration.Builder> notificationConfiguration) {
            return this.notificationConfiguration((NotificationConfiguration)((NotificationConfiguration.Builder)NotificationConfiguration.builder().applyMutation(notificationConfiguration)).build());
        }
    }
}

