/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AutoMLCandidate;
import software.amazon.awssdk.services.sagemaker.model.AutoMLChannel;
import software.amazon.awssdk.services.sagemaker.model.AutoMLInputDataConfigCopier;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobArtifacts;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobConfig;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjective;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus;
import software.amazon.awssdk.services.sagemaker.model.AutoMLOutputDataConfig;
import software.amazon.awssdk.services.sagemaker.model.AutoMLPartialFailureReason;
import software.amazon.awssdk.services.sagemaker.model.AutoMLPartialFailureReasonsCopier;
import software.amazon.awssdk.services.sagemaker.model.ProblemType;
import software.amazon.awssdk.services.sagemaker.model.ResolvedAttributes;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAutoMlJobResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeAutoMlJobResponse> {
    private static final SdkField<String> AUTO_ML_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoMLJobName").getter(DescribeAutoMlJobResponse.getter(DescribeAutoMlJobResponse::autoMLJobName)).setter(DescribeAutoMlJobResponse.setter(Builder::autoMLJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobName").build()}).build();
    private static final SdkField<String> AUTO_ML_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoMLJobArn").getter(DescribeAutoMlJobResponse.getter(DescribeAutoMlJobResponse::autoMLJobArn)).setter(DescribeAutoMlJobResponse.setter(Builder::autoMLJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobArn").build()}).build();
    private static final SdkField<List<AutoMLChannel>> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputDataConfig").getter(DescribeAutoMlJobResponse.getter(DescribeAutoMlJobResponse::inputDataConfig)).setter(DescribeAutoMlJobResponse.setter(Builder::inputDataConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoMLChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AutoMLOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputDataConfig").getter(DescribeAutoMlJobResponse.getter(DescribeAutoMlJobResponse::outputDataConfig)).setter(DescribeAutoMlJobResponse.setter(Builder::outputDataConfig)).constructor(AutoMLOutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeAutoMlJobResponse.getter(DescribeAutoMlJobResponse::roleArn)).setter(DescribeAutoMlJobResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<AutoMLJobObjective> AUTO_ML_JOB_OBJECTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoMLJobObjective").getter(DescribeAutoMlJobResponse.getter(DescribeAutoMlJobResponse::autoMLJobObjective)).setter(DescribeAutoMlJobResponse.setter(Builder::autoMLJobObjective)).constructor(AutoMLJobObjective::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobObjective").build()}).build();
    private static final SdkField<String> PROBLEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProblemType").getter(DescribeAutoMlJobResponse.getter(DescribeAutoMlJobResponse::problemTypeAsString)).setter(DescribeAutoMlJobResponse.setter(Builder::problemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProblemType").build()}).build();
    private static final SdkField<AutoMLJobConfig> AUTO_ML_JOB_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoMLJobConfig").getter(DescribeAutoMlJobResponse.getter(DescribeAutoMlJobResponse::autoMLJobConfig)).setter(DescribeAutoMlJobResponse.setter(Builder::autoMLJobConfig)).constructor(AutoMLJobConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobConfig").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeAutoMlJobResponse.getter(DescribeAutoMlJobResponse::creationTime)).setter(DescribeAutoMlJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(DescribeAutoMlJobResponse.getter(DescribeAutoMlJobResponse::endTime)).setter(DescribeAutoMlJobResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeAutoMlJobResponse.getter(DescribeAutoMlJobResponse::lastModifiedTime)).setter(DescribeAutoMlJobResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeAutoMlJobResponse.getter(DescribeAutoMlJobResponse::failureReason)).setter(DescribeAutoMlJobResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<List<AutoMLPartialFailureReason>> PARTIAL_FAILURE_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartialFailureReasons").getter(DescribeAutoMlJobResponse.getter(DescribeAutoMlJobResponse::partialFailureReasons)).setter(DescribeAutoMlJobResponse.setter(Builder::partialFailureReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartialFailureReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoMLPartialFailureReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AutoMLCandidate> BEST_CANDIDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BestCandidate").getter(DescribeAutoMlJobResponse.getter(DescribeAutoMlJobResponse::bestCandidate)).setter(DescribeAutoMlJobResponse.setter(Builder::bestCandidate)).constructor(AutoMLCandidate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BestCandidate").build()}).build();
    private static final SdkField<String> AUTO_ML_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoMLJobStatus").getter(DescribeAutoMlJobResponse.getter(DescribeAutoMlJobResponse::autoMLJobStatusAsString)).setter(DescribeAutoMlJobResponse.setter(Builder::autoMLJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobStatus").build()}).build();
    private static final SdkField<String> AUTO_ML_JOB_SECONDARY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoMLJobSecondaryStatus").getter(DescribeAutoMlJobResponse.getter(DescribeAutoMlJobResponse::autoMLJobSecondaryStatusAsString)).setter(DescribeAutoMlJobResponse.setter(Builder::autoMLJobSecondaryStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobSecondaryStatus").build()}).build();
    private static final SdkField<Boolean> GENERATE_CANDIDATE_DEFINITIONS_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("GenerateCandidateDefinitionsOnly").getter(DescribeAutoMlJobResponse.getter(DescribeAutoMlJobResponse::generateCandidateDefinitionsOnly)).setter(DescribeAutoMlJobResponse.setter(Builder::generateCandidateDefinitionsOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerateCandidateDefinitionsOnly").build()}).build();
    private static final SdkField<AutoMLJobArtifacts> AUTO_ML_JOB_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoMLJobArtifacts").getter(DescribeAutoMlJobResponse.getter(DescribeAutoMlJobResponse::autoMLJobArtifacts)).setter(DescribeAutoMlJobResponse.setter(Builder::autoMLJobArtifacts)).constructor(AutoMLJobArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobArtifacts").build()}).build();
    private static final SdkField<ResolvedAttributes> RESOLVED_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResolvedAttributes").getter(DescribeAutoMlJobResponse.getter(DescribeAutoMlJobResponse::resolvedAttributes)).setter(DescribeAutoMlJobResponse.setter(Builder::resolvedAttributes)).constructor(ResolvedAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ML_JOB_NAME_FIELD, AUTO_ML_JOB_ARN_FIELD, INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, ROLE_ARN_FIELD, AUTO_ML_JOB_OBJECTIVE_FIELD, PROBLEM_TYPE_FIELD, AUTO_ML_JOB_CONFIG_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD, PARTIAL_FAILURE_REASONS_FIELD, BEST_CANDIDATE_FIELD, AUTO_ML_JOB_STATUS_FIELD, AUTO_ML_JOB_SECONDARY_STATUS_FIELD, GENERATE_CANDIDATE_DEFINITIONS_ONLY_FIELD, AUTO_ML_JOB_ARTIFACTS_FIELD, RESOLVED_ATTRIBUTES_FIELD));
    private final String autoMLJobName;
    private final String autoMLJobArn;
    private final List<AutoMLChannel> inputDataConfig;
    private final AutoMLOutputDataConfig outputDataConfig;
    private final String roleArn;
    private final AutoMLJobObjective autoMLJobObjective;
    private final String problemType;
    private final AutoMLJobConfig autoMLJobConfig;
    private final Instant creationTime;
    private final Instant endTime;
    private final Instant lastModifiedTime;
    private final String failureReason;
    private final List<AutoMLPartialFailureReason> partialFailureReasons;
    private final AutoMLCandidate bestCandidate;
    private final String autoMLJobStatus;
    private final String autoMLJobSecondaryStatus;
    private final Boolean generateCandidateDefinitionsOnly;
    private final AutoMLJobArtifacts autoMLJobArtifacts;
    private final ResolvedAttributes resolvedAttributes;

    private DescribeAutoMlJobResponse(BuilderImpl builder) {
        super(builder);
        this.autoMLJobName = builder.autoMLJobName;
        this.autoMLJobArn = builder.autoMLJobArn;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.roleArn = builder.roleArn;
        this.autoMLJobObjective = builder.autoMLJobObjective;
        this.problemType = builder.problemType;
        this.autoMLJobConfig = builder.autoMLJobConfig;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
        this.partialFailureReasons = builder.partialFailureReasons;
        this.bestCandidate = builder.bestCandidate;
        this.autoMLJobStatus = builder.autoMLJobStatus;
        this.autoMLJobSecondaryStatus = builder.autoMLJobSecondaryStatus;
        this.generateCandidateDefinitionsOnly = builder.generateCandidateDefinitionsOnly;
        this.autoMLJobArtifacts = builder.autoMLJobArtifacts;
        this.resolvedAttributes = builder.resolvedAttributes;
    }

    public final String autoMLJobName() {
        return this.autoMLJobName;
    }

    public final String autoMLJobArn() {
        return this.autoMLJobArn;
    }

    public final boolean hasInputDataConfig() {
        return this.inputDataConfig != null && !(this.inputDataConfig instanceof SdkAutoConstructList);
    }

    public final List<AutoMLChannel> inputDataConfig() {
        return this.inputDataConfig;
    }

    public final AutoMLOutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final AutoMLJobObjective autoMLJobObjective() {
        return this.autoMLJobObjective;
    }

    public final ProblemType problemType() {
        return ProblemType.fromValue(this.problemType);
    }

    public final String problemTypeAsString() {
        return this.problemType;
    }

    public final AutoMLJobConfig autoMLJobConfig() {
        return this.autoMLJobConfig;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final boolean hasPartialFailureReasons() {
        return this.partialFailureReasons != null && !(this.partialFailureReasons instanceof SdkAutoConstructList);
    }

    public final List<AutoMLPartialFailureReason> partialFailureReasons() {
        return this.partialFailureReasons;
    }

    public final AutoMLCandidate bestCandidate() {
        return this.bestCandidate;
    }

    public final AutoMLJobStatus autoMLJobStatus() {
        return AutoMLJobStatus.fromValue(this.autoMLJobStatus);
    }

    public final String autoMLJobStatusAsString() {
        return this.autoMLJobStatus;
    }

    public final AutoMLJobSecondaryStatus autoMLJobSecondaryStatus() {
        return AutoMLJobSecondaryStatus.fromValue(this.autoMLJobSecondaryStatus);
    }

    public final String autoMLJobSecondaryStatusAsString() {
        return this.autoMLJobSecondaryStatus;
    }

    public final Boolean generateCandidateDefinitionsOnly() {
        return this.generateCandidateDefinitionsOnly;
    }

    public final AutoMLJobArtifacts autoMLJobArtifacts() {
        return this.autoMLJobArtifacts;
    }

    public final ResolvedAttributes resolvedAttributes() {
        return this.resolvedAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputDataConfig() ? this.inputDataConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobObjective());
        hashCode = 31 * hashCode + Objects.hashCode(this.problemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartialFailureReasons() ? this.partialFailureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.bestCandidate());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobSecondaryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.generateCandidateDefinitionsOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutoMlJobResponse)) {
            return false;
        }
        DescribeAutoMlJobResponse other = (DescribeAutoMlJobResponse)((Object)obj);
        return Objects.equals(this.autoMLJobName(), other.autoMLJobName()) && Objects.equals(this.autoMLJobArn(), other.autoMLJobArn()) && this.hasInputDataConfig() == other.hasInputDataConfig() && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.autoMLJobObjective(), other.autoMLJobObjective()) && Objects.equals(this.problemTypeAsString(), other.problemTypeAsString()) && Objects.equals(this.autoMLJobConfig(), other.autoMLJobConfig()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.failureReason(), other.failureReason()) && this.hasPartialFailureReasons() == other.hasPartialFailureReasons() && Objects.equals(this.partialFailureReasons(), other.partialFailureReasons()) && Objects.equals(this.bestCandidate(), other.bestCandidate()) && Objects.equals(this.autoMLJobStatusAsString(), other.autoMLJobStatusAsString()) && Objects.equals(this.autoMLJobSecondaryStatusAsString(), other.autoMLJobSecondaryStatusAsString()) && Objects.equals(this.generateCandidateDefinitionsOnly(), other.generateCandidateDefinitionsOnly()) && Objects.equals(this.autoMLJobArtifacts(), other.autoMLJobArtifacts()) && Objects.equals(this.resolvedAttributes(), other.resolvedAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAutoMlJobResponse").add("AutoMLJobName", (Object)this.autoMLJobName()).add("AutoMLJobArn", (Object)this.autoMLJobArn()).add("InputDataConfig", this.hasInputDataConfig() ? this.inputDataConfig() : null).add("OutputDataConfig", (Object)this.outputDataConfig()).add("RoleArn", (Object)this.roleArn()).add("AutoMLJobObjective", (Object)this.autoMLJobObjective()).add("ProblemType", (Object)this.problemTypeAsString()).add("AutoMLJobConfig", (Object)this.autoMLJobConfig()).add("CreationTime", (Object)this.creationTime()).add("EndTime", (Object)this.endTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("FailureReason", (Object)this.failureReason()).add("PartialFailureReasons", this.hasPartialFailureReasons() ? this.partialFailureReasons() : null).add("BestCandidate", (Object)this.bestCandidate()).add("AutoMLJobStatus", (Object)this.autoMLJobStatusAsString()).add("AutoMLJobSecondaryStatus", (Object)this.autoMLJobSecondaryStatusAsString()).add("GenerateCandidateDefinitionsOnly", (Object)this.generateCandidateDefinitionsOnly()).add("AutoMLJobArtifacts", (Object)this.autoMLJobArtifacts()).add("ResolvedAttributes", (Object)this.resolvedAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoMLJobName": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobName()));
            }
            case "AutoMLJobArn": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobArn()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "AutoMLJobObjective": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobObjective()));
            }
            case "ProblemType": {
                return Optional.ofNullable(clazz.cast(this.problemTypeAsString()));
            }
            case "AutoMLJobConfig": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobConfig()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "PartialFailureReasons": {
                return Optional.ofNullable(clazz.cast(this.partialFailureReasons()));
            }
            case "BestCandidate": {
                return Optional.ofNullable(clazz.cast(this.bestCandidate()));
            }
            case "AutoMLJobStatus": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobStatusAsString()));
            }
            case "AutoMLJobSecondaryStatus": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobSecondaryStatusAsString()));
            }
            case "GenerateCandidateDefinitionsOnly": {
                return Optional.ofNullable(clazz.cast(this.generateCandidateDefinitionsOnly()));
            }
            case "AutoMLJobArtifacts": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobArtifacts()));
            }
            case "ResolvedAttributes": {
                return Optional.ofNullable(clazz.cast(this.resolvedAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAutoMlJobResponse, T> g) {
        return obj -> g.apply((DescribeAutoMlJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String autoMLJobName;
        private String autoMLJobArn;
        private List<AutoMLChannel> inputDataConfig = DefaultSdkAutoConstructList.getInstance();
        private AutoMLOutputDataConfig outputDataConfig;
        private String roleArn;
        private AutoMLJobObjective autoMLJobObjective;
        private String problemType;
        private AutoMLJobConfig autoMLJobConfig;
        private Instant creationTime;
        private Instant endTime;
        private Instant lastModifiedTime;
        private String failureReason;
        private List<AutoMLPartialFailureReason> partialFailureReasons = DefaultSdkAutoConstructList.getInstance();
        private AutoMLCandidate bestCandidate;
        private String autoMLJobStatus;
        private String autoMLJobSecondaryStatus;
        private Boolean generateCandidateDefinitionsOnly;
        private AutoMLJobArtifacts autoMLJobArtifacts;
        private ResolvedAttributes resolvedAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutoMlJobResponse model) {
            super(model);
            this.autoMLJobName(model.autoMLJobName);
            this.autoMLJobArn(model.autoMLJobArn);
            this.inputDataConfig(model.inputDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.roleArn(model.roleArn);
            this.autoMLJobObjective(model.autoMLJobObjective);
            this.problemType(model.problemType);
            this.autoMLJobConfig(model.autoMLJobConfig);
            this.creationTime(model.creationTime);
            this.endTime(model.endTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.failureReason(model.failureReason);
            this.partialFailureReasons(model.partialFailureReasons);
            this.bestCandidate(model.bestCandidate);
            this.autoMLJobStatus(model.autoMLJobStatus);
            this.autoMLJobSecondaryStatus(model.autoMLJobSecondaryStatus);
            this.generateCandidateDefinitionsOnly(model.generateCandidateDefinitionsOnly);
            this.autoMLJobArtifacts(model.autoMLJobArtifacts);
            this.resolvedAttributes(model.resolvedAttributes);
        }

        public final String getAutoMLJobName() {
            return this.autoMLJobName;
        }

        @Override
        public final Builder autoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
            return this;
        }

        public final void setAutoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
        }

        public final String getAutoMLJobArn() {
            return this.autoMLJobArn;
        }

        @Override
        public final Builder autoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
            return this;
        }

        public final void setAutoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
        }

        public final Collection<AutoMLChannel.Builder> getInputDataConfig() {
            if (this.inputDataConfig instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputDataConfig != null ? (Collection)this.inputDataConfig.stream().map(AutoMLChannel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputDataConfig(Collection<AutoMLChannel> inputDataConfig) {
            this.inputDataConfig = AutoMLInputDataConfigCopier.copy(inputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(AutoMLChannel ... inputDataConfig) {
            this.inputDataConfig(Arrays.asList(inputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Consumer<AutoMLChannel.Builder> ... inputDataConfig) {
            this.inputDataConfig(Stream.of(inputDataConfig).map(c -> (AutoMLChannel)((AutoMLChannel.Builder)AutoMLChannel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputDataConfig(Collection<AutoMLChannel.BuilderImpl> inputDataConfig) {
            this.inputDataConfig = AutoMLInputDataConfigCopier.copyFromBuilder(inputDataConfig);
        }

        public final AutoMLOutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputDataConfig(AutoMLOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final void setOutputDataConfig(AutoMLOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final AutoMLJobObjective.Builder getAutoMLJobObjective() {
            return this.autoMLJobObjective != null ? this.autoMLJobObjective.toBuilder() : null;
        }

        @Override
        public final Builder autoMLJobObjective(AutoMLJobObjective autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective;
            return this;
        }

        public final void setAutoMLJobObjective(AutoMLJobObjective.BuilderImpl autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective != null ? autoMLJobObjective.build() : null;
        }

        public final String getProblemType() {
            return this.problemType;
        }

        @Override
        public final Builder problemType(String problemType) {
            this.problemType = problemType;
            return this;
        }

        @Override
        public final Builder problemType(ProblemType problemType) {
            this.problemType(problemType == null ? null : problemType.toString());
            return this;
        }

        public final void setProblemType(String problemType) {
            this.problemType = problemType;
        }

        public final AutoMLJobConfig.Builder getAutoMLJobConfig() {
            return this.autoMLJobConfig != null ? this.autoMLJobConfig.toBuilder() : null;
        }

        @Override
        public final Builder autoMLJobConfig(AutoMLJobConfig autoMLJobConfig) {
            this.autoMLJobConfig = autoMLJobConfig;
            return this;
        }

        public final void setAutoMLJobConfig(AutoMLJobConfig.BuilderImpl autoMLJobConfig) {
            this.autoMLJobConfig = autoMLJobConfig != null ? autoMLJobConfig.build() : null;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final Collection<AutoMLPartialFailureReason.Builder> getPartialFailureReasons() {
            if (this.partialFailureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.partialFailureReasons != null ? (Collection)this.partialFailureReasons.stream().map(AutoMLPartialFailureReason::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder partialFailureReasons(Collection<AutoMLPartialFailureReason> partialFailureReasons) {
            this.partialFailureReasons = AutoMLPartialFailureReasonsCopier.copy(partialFailureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partialFailureReasons(AutoMLPartialFailureReason ... partialFailureReasons) {
            this.partialFailureReasons(Arrays.asList(partialFailureReasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partialFailureReasons(Consumer<AutoMLPartialFailureReason.Builder> ... partialFailureReasons) {
            this.partialFailureReasons(Stream.of(partialFailureReasons).map(c -> (AutoMLPartialFailureReason)((AutoMLPartialFailureReason.Builder)AutoMLPartialFailureReason.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPartialFailureReasons(Collection<AutoMLPartialFailureReason.BuilderImpl> partialFailureReasons) {
            this.partialFailureReasons = AutoMLPartialFailureReasonsCopier.copyFromBuilder(partialFailureReasons);
        }

        public final AutoMLCandidate.Builder getBestCandidate() {
            return this.bestCandidate != null ? this.bestCandidate.toBuilder() : null;
        }

        @Override
        public final Builder bestCandidate(AutoMLCandidate bestCandidate) {
            this.bestCandidate = bestCandidate;
            return this;
        }

        public final void setBestCandidate(AutoMLCandidate.BuilderImpl bestCandidate) {
            this.bestCandidate = bestCandidate != null ? bestCandidate.build() : null;
        }

        public final String getAutoMLJobStatus() {
            return this.autoMLJobStatus;
        }

        @Override
        public final Builder autoMLJobStatus(String autoMLJobStatus) {
            this.autoMLJobStatus = autoMLJobStatus;
            return this;
        }

        @Override
        public final Builder autoMLJobStatus(AutoMLJobStatus autoMLJobStatus) {
            this.autoMLJobStatus(autoMLJobStatus == null ? null : autoMLJobStatus.toString());
            return this;
        }

        public final void setAutoMLJobStatus(String autoMLJobStatus) {
            this.autoMLJobStatus = autoMLJobStatus;
        }

        public final String getAutoMLJobSecondaryStatus() {
            return this.autoMLJobSecondaryStatus;
        }

        @Override
        public final Builder autoMLJobSecondaryStatus(String autoMLJobSecondaryStatus) {
            this.autoMLJobSecondaryStatus = autoMLJobSecondaryStatus;
            return this;
        }

        @Override
        public final Builder autoMLJobSecondaryStatus(AutoMLJobSecondaryStatus autoMLJobSecondaryStatus) {
            this.autoMLJobSecondaryStatus(autoMLJobSecondaryStatus == null ? null : autoMLJobSecondaryStatus.toString());
            return this;
        }

        public final void setAutoMLJobSecondaryStatus(String autoMLJobSecondaryStatus) {
            this.autoMLJobSecondaryStatus = autoMLJobSecondaryStatus;
        }

        public final Boolean getGenerateCandidateDefinitionsOnly() {
            return this.generateCandidateDefinitionsOnly;
        }

        @Override
        public final Builder generateCandidateDefinitionsOnly(Boolean generateCandidateDefinitionsOnly) {
            this.generateCandidateDefinitionsOnly = generateCandidateDefinitionsOnly;
            return this;
        }

        public final void setGenerateCandidateDefinitionsOnly(Boolean generateCandidateDefinitionsOnly) {
            this.generateCandidateDefinitionsOnly = generateCandidateDefinitionsOnly;
        }

        public final AutoMLJobArtifacts.Builder getAutoMLJobArtifacts() {
            return this.autoMLJobArtifacts != null ? this.autoMLJobArtifacts.toBuilder() : null;
        }

        @Override
        public final Builder autoMLJobArtifacts(AutoMLJobArtifacts autoMLJobArtifacts) {
            this.autoMLJobArtifacts = autoMLJobArtifacts;
            return this;
        }

        public final void setAutoMLJobArtifacts(AutoMLJobArtifacts.BuilderImpl autoMLJobArtifacts) {
            this.autoMLJobArtifacts = autoMLJobArtifacts != null ? autoMLJobArtifacts.build() : null;
        }

        public final ResolvedAttributes.Builder getResolvedAttributes() {
            return this.resolvedAttributes != null ? this.resolvedAttributes.toBuilder() : null;
        }

        @Override
        public final Builder resolvedAttributes(ResolvedAttributes resolvedAttributes) {
            this.resolvedAttributes = resolvedAttributes;
            return this;
        }

        public final void setResolvedAttributes(ResolvedAttributes.BuilderImpl resolvedAttributes) {
            this.resolvedAttributes = resolvedAttributes != null ? resolvedAttributes.build() : null;
        }

        @Override
        public DescribeAutoMlJobResponse build() {
            return new DescribeAutoMlJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAutoMlJobResponse> {
        public Builder autoMLJobName(String var1);

        public Builder autoMLJobArn(String var1);

        public Builder inputDataConfig(Collection<AutoMLChannel> var1);

        public Builder inputDataConfig(AutoMLChannel ... var1);

        public Builder inputDataConfig(Consumer<AutoMLChannel.Builder> ... var1);

        public Builder outputDataConfig(AutoMLOutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<AutoMLOutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((AutoMLOutputDataConfig)((AutoMLOutputDataConfig.Builder)AutoMLOutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder autoMLJobObjective(AutoMLJobObjective var1);

        default public Builder autoMLJobObjective(Consumer<AutoMLJobObjective.Builder> autoMLJobObjective) {
            return this.autoMLJobObjective((AutoMLJobObjective)((AutoMLJobObjective.Builder)AutoMLJobObjective.builder().applyMutation(autoMLJobObjective)).build());
        }

        public Builder problemType(String var1);

        public Builder problemType(ProblemType var1);

        public Builder autoMLJobConfig(AutoMLJobConfig var1);

        default public Builder autoMLJobConfig(Consumer<AutoMLJobConfig.Builder> autoMLJobConfig) {
            return this.autoMLJobConfig((AutoMLJobConfig)((AutoMLJobConfig.Builder)AutoMLJobConfig.builder().applyMutation(autoMLJobConfig)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder failureReason(String var1);

        public Builder partialFailureReasons(Collection<AutoMLPartialFailureReason> var1);

        public Builder partialFailureReasons(AutoMLPartialFailureReason ... var1);

        public Builder partialFailureReasons(Consumer<AutoMLPartialFailureReason.Builder> ... var1);

        public Builder bestCandidate(AutoMLCandidate var1);

        default public Builder bestCandidate(Consumer<AutoMLCandidate.Builder> bestCandidate) {
            return this.bestCandidate((AutoMLCandidate)((AutoMLCandidate.Builder)AutoMLCandidate.builder().applyMutation(bestCandidate)).build());
        }

        public Builder autoMLJobStatus(String var1);

        public Builder autoMLJobStatus(AutoMLJobStatus var1);

        public Builder autoMLJobSecondaryStatus(String var1);

        public Builder autoMLJobSecondaryStatus(AutoMLJobSecondaryStatus var1);

        public Builder generateCandidateDefinitionsOnly(Boolean var1);

        public Builder autoMLJobArtifacts(AutoMLJobArtifacts var1);

        default public Builder autoMLJobArtifacts(Consumer<AutoMLJobArtifacts.Builder> autoMLJobArtifacts) {
            return this.autoMLJobArtifacts((AutoMLJobArtifacts)((AutoMLJobArtifacts.Builder)AutoMLJobArtifacts.builder().applyMutation(autoMLJobArtifacts)).build());
        }

        public Builder resolvedAttributes(ResolvedAttributes var1);

        default public Builder resolvedAttributes(Consumer<ResolvedAttributes.Builder> resolvedAttributes) {
            return this.resolvedAttributes((ResolvedAttributes)((ResolvedAttributes.Builder)ResolvedAttributes.builder().applyMutation(resolvedAttributes)).build());
        }
    }
}

