/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SecondaryStatus {
    STARTING("Starting"),
    LAUNCHING_ML_INSTANCES("LaunchingMLInstances"),
    PREPARING_TRAINING_STACK("PreparingTrainingStack"),
    DOWNLOADING("Downloading"),
    DOWNLOADING_TRAINING_IMAGE("DownloadingTrainingImage"),
    TRAINING("Training"),
    UPLOADING("Uploading"),
    STOPPING("Stopping"),
    STOPPED("Stopped"),
    MAX_RUNTIME_EXCEEDED("MaxRuntimeExceeded"),
    COMPLETED("Completed"),
    FAILED("Failed"),
    INTERRUPTED("Interrupted"),
    MAX_WAIT_TIME_EXCEEDED("MaxWaitTimeExceeded"),
    UPDATING("Updating"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SecondaryStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SecondaryStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SecondaryStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SecondaryStatus> knownValues() {
        return Stream.of(SecondaryStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

