/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricsSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricsSource> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(MetricsSource.getter(MetricsSource::contentType)).setter(MetricsSource.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()}).build();
    private static final SdkField<String> CONTENT_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentDigest").getter(MetricsSource.getter(MetricsSource::contentDigest)).setter(MetricsSource.setter(Builder::contentDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentDigest").build()}).build();
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Uri").getter(MetricsSource.getter(MetricsSource::s3Uri)).setter(MetricsSource.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD, CONTENT_DIGEST_FIELD, S3_URI_FIELD));
    private static final long serialVersionUID = 1L;
    private final String contentType;
    private final String contentDigest;
    private final String s3Uri;

    private MetricsSource(BuilderImpl builder) {
        this.contentType = builder.contentType;
        this.contentDigest = builder.contentDigest;
        this.s3Uri = builder.s3Uri;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String contentDigest() {
        return this.contentDigest;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricsSource)) {
            return false;
        }
        MetricsSource other = (MetricsSource)obj;
        return Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.contentDigest(), other.contentDigest()) && Objects.equals(this.s3Uri(), other.s3Uri());
    }

    public final String toString() {
        return ToString.builder((String)"MetricsSource").add("ContentType", (Object)this.contentType()).add("ContentDigest", (Object)this.contentDigest()).add("S3Uri", (Object)this.s3Uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "ContentDigest": {
                return Optional.ofNullable(clazz.cast(this.contentDigest()));
            }
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricsSource, T> g) {
        return obj -> g.apply((MetricsSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contentType;
        private String contentDigest;
        private String s3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricsSource model) {
            this.contentType(model.contentType);
            this.contentDigest(model.contentDigest);
            this.s3Uri(model.s3Uri);
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getContentDigest() {
            return this.contentDigest;
        }

        @Override
        public final Builder contentDigest(String contentDigest) {
            this.contentDigest = contentDigest;
            return this;
        }

        public final void setContentDigest(String contentDigest) {
            this.contentDigest = contentDigest;
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        public MetricsSource build() {
            return new MetricsSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricsSource> {
        public Builder contentType(String var1);

        public Builder contentDigest(String var1);

        public Builder s3Uri(String var1);
    }
}

