/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AutoMLCandidate;
import software.amazon.awssdk.services.sagemaker.model.AutoMLCandidatesCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCandidatesForAutoMlJobResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListCandidatesForAutoMlJobResponse> {
    private static final SdkField<List<AutoMLCandidate>> CANDIDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Candidates").getter(ListCandidatesForAutoMlJobResponse.getter(ListCandidatesForAutoMlJobResponse::candidates)).setter(ListCandidatesForAutoMlJobResponse.setter(Builder::candidates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Candidates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoMLCandidate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCandidatesForAutoMlJobResponse.getter(ListCandidatesForAutoMlJobResponse::nextToken)).setter(ListCandidatesForAutoMlJobResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANDIDATES_FIELD, NEXT_TOKEN_FIELD));
    private final List<AutoMLCandidate> candidates;
    private final String nextToken;

    private ListCandidatesForAutoMlJobResponse(BuilderImpl builder) {
        super(builder);
        this.candidates = builder.candidates;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCandidates() {
        return this.candidates != null && !(this.candidates instanceof SdkAutoConstructList);
    }

    public final List<AutoMLCandidate> candidates() {
        return this.candidates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCandidates() ? this.candidates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCandidatesForAutoMlJobResponse)) {
            return false;
        }
        ListCandidatesForAutoMlJobResponse other = (ListCandidatesForAutoMlJobResponse)((Object)obj);
        return this.hasCandidates() == other.hasCandidates() && Objects.equals(this.candidates(), other.candidates()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCandidatesForAutoMlJobResponse").add("Candidates", this.hasCandidates() ? this.candidates() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Candidates": {
                return Optional.ofNullable(clazz.cast(this.candidates()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCandidatesForAutoMlJobResponse, T> g) {
        return obj -> g.apply((ListCandidatesForAutoMlJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<AutoMLCandidate> candidates = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCandidatesForAutoMlJobResponse model) {
            super(model);
            this.candidates(model.candidates);
            this.nextToken(model.nextToken);
        }

        public final Collection<AutoMLCandidate.Builder> getCandidates() {
            if (this.candidates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.candidates != null ? (Collection)this.candidates.stream().map(AutoMLCandidate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder candidates(Collection<AutoMLCandidate> candidates) {
            this.candidates = AutoMLCandidatesCopier.copy(candidates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder candidates(AutoMLCandidate ... candidates) {
            this.candidates(Arrays.asList(candidates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder candidates(Consumer<AutoMLCandidate.Builder> ... candidates) {
            this.candidates(Stream.of(candidates).map(c -> (AutoMLCandidate)((AutoMLCandidate.Builder)AutoMLCandidate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCandidates(Collection<AutoMLCandidate.BuilderImpl> candidates) {
            this.candidates = AutoMLCandidatesCopier.copyFromBuilder(candidates);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCandidatesForAutoMlJobResponse build() {
            return new ListCandidatesForAutoMlJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCandidatesForAutoMlJobResponse> {
        public Builder candidates(Collection<AutoMLCandidate> var1);

        public Builder candidates(AutoMLCandidate ... var1);

        public Builder candidates(Consumer<AutoMLCandidate.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

