/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AutoMLCandidateStep;
import software.amazon.awssdk.services.sagemaker.model.AutoMLContainerDefinition;
import software.amazon.awssdk.services.sagemaker.model.AutoMLContainerDefinitionsCopier;
import software.amazon.awssdk.services.sagemaker.model.CandidateStatus;
import software.amazon.awssdk.services.sagemaker.model.CandidateStepsCopier;
import software.amazon.awssdk.services.sagemaker.model.FinalAutoMLJobObjectiveMetric;
import software.amazon.awssdk.services.sagemaker.model.ObjectiveStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoMLCandidate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoMLCandidate> {
    private static final SdkField<String> CANDIDATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CandidateName").getter(AutoMLCandidate.getter(AutoMLCandidate::candidateName)).setter(AutoMLCandidate.setter(Builder::candidateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateName").build()}).build();
    private static final SdkField<FinalAutoMLJobObjectiveMetric> FINAL_AUTO_ML_JOB_OBJECTIVE_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FinalAutoMLJobObjectiveMetric").getter(AutoMLCandidate.getter(AutoMLCandidate::finalAutoMLJobObjectiveMetric)).setter(AutoMLCandidate.setter(Builder::finalAutoMLJobObjectiveMetric)).constructor(FinalAutoMLJobObjectiveMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalAutoMLJobObjectiveMetric").build()}).build();
    private static final SdkField<String> OBJECTIVE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectiveStatus").getter(AutoMLCandidate.getter(AutoMLCandidate::objectiveStatusAsString)).setter(AutoMLCandidate.setter(Builder::objectiveStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectiveStatus").build()}).build();
    private static final SdkField<List<AutoMLCandidateStep>> CANDIDATE_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CandidateSteps").getter(AutoMLCandidate.getter(AutoMLCandidate::candidateSteps)).setter(AutoMLCandidate.setter(Builder::candidateSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoMLCandidateStep::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CANDIDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CandidateStatus").getter(AutoMLCandidate.getter(AutoMLCandidate::candidateStatusAsString)).setter(AutoMLCandidate.setter(Builder::candidateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateStatus").build()}).build();
    private static final SdkField<List<AutoMLContainerDefinition>> INFERENCE_CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InferenceContainers").getter(AutoMLCandidate.getter(AutoMLCandidate::inferenceContainers)).setter(AutoMLCandidate.setter(Builder::inferenceContainers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceContainers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoMLContainerDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(AutoMLCandidate.getter(AutoMLCandidate::creationTime)).setter(AutoMLCandidate.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(AutoMLCandidate.getter(AutoMLCandidate::endTime)).setter(AutoMLCandidate.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(AutoMLCandidate.getter(AutoMLCandidate::lastModifiedTime)).setter(AutoMLCandidate.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(AutoMLCandidate.getter(AutoMLCandidate::failureReason)).setter(AutoMLCandidate.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANDIDATE_NAME_FIELD, FINAL_AUTO_ML_JOB_OBJECTIVE_METRIC_FIELD, OBJECTIVE_STATUS_FIELD, CANDIDATE_STEPS_FIELD, CANDIDATE_STATUS_FIELD, INFERENCE_CONTAINERS_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String candidateName;
    private final FinalAutoMLJobObjectiveMetric finalAutoMLJobObjectiveMetric;
    private final String objectiveStatus;
    private final List<AutoMLCandidateStep> candidateSteps;
    private final String candidateStatus;
    private final List<AutoMLContainerDefinition> inferenceContainers;
    private final Instant creationTime;
    private final Instant endTime;
    private final Instant lastModifiedTime;
    private final String failureReason;

    private AutoMLCandidate(BuilderImpl builder) {
        this.candidateName = builder.candidateName;
        this.finalAutoMLJobObjectiveMetric = builder.finalAutoMLJobObjectiveMetric;
        this.objectiveStatus = builder.objectiveStatus;
        this.candidateSteps = builder.candidateSteps;
        this.candidateStatus = builder.candidateStatus;
        this.inferenceContainers = builder.inferenceContainers;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
    }

    public final String candidateName() {
        return this.candidateName;
    }

    public final FinalAutoMLJobObjectiveMetric finalAutoMLJobObjectiveMetric() {
        return this.finalAutoMLJobObjectiveMetric;
    }

    public final ObjectiveStatus objectiveStatus() {
        return ObjectiveStatus.fromValue(this.objectiveStatus);
    }

    public final String objectiveStatusAsString() {
        return this.objectiveStatus;
    }

    public final boolean hasCandidateSteps() {
        return this.candidateSteps != null && !(this.candidateSteps instanceof SdkAutoConstructList);
    }

    public final List<AutoMLCandidateStep> candidateSteps() {
        return this.candidateSteps;
    }

    public final CandidateStatus candidateStatus() {
        return CandidateStatus.fromValue(this.candidateStatus);
    }

    public final String candidateStatusAsString() {
        return this.candidateStatus;
    }

    public final boolean hasInferenceContainers() {
        return this.inferenceContainers != null && !(this.inferenceContainers instanceof SdkAutoConstructList);
    }

    public final List<AutoMLContainerDefinition> inferenceContainers() {
        return this.inferenceContainers;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.candidateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalAutoMLJobObjectiveMetric());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectiveStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCandidateSteps() ? this.candidateSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.candidateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInferenceContainers() ? this.inferenceContainers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLCandidate)) {
            return false;
        }
        AutoMLCandidate other = (AutoMLCandidate)obj;
        return Objects.equals(this.candidateName(), other.candidateName()) && Objects.equals(this.finalAutoMLJobObjectiveMetric(), other.finalAutoMLJobObjectiveMetric()) && Objects.equals(this.objectiveStatusAsString(), other.objectiveStatusAsString()) && this.hasCandidateSteps() == other.hasCandidateSteps() && Objects.equals(this.candidateSteps(), other.candidateSteps()) && Objects.equals(this.candidateStatusAsString(), other.candidateStatusAsString()) && this.hasInferenceContainers() == other.hasInferenceContainers() && Objects.equals(this.inferenceContainers(), other.inferenceContainers()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"AutoMLCandidate").add("CandidateName", (Object)this.candidateName()).add("FinalAutoMLJobObjectiveMetric", (Object)this.finalAutoMLJobObjectiveMetric()).add("ObjectiveStatus", (Object)this.objectiveStatusAsString()).add("CandidateSteps", this.hasCandidateSteps() ? this.candidateSteps() : null).add("CandidateStatus", (Object)this.candidateStatusAsString()).add("InferenceContainers", this.hasInferenceContainers() ? this.inferenceContainers() : null).add("CreationTime", (Object)this.creationTime()).add("EndTime", (Object)this.endTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CandidateName": {
                return Optional.ofNullable(clazz.cast(this.candidateName()));
            }
            case "FinalAutoMLJobObjectiveMetric": {
                return Optional.ofNullable(clazz.cast(this.finalAutoMLJobObjectiveMetric()));
            }
            case "ObjectiveStatus": {
                return Optional.ofNullable(clazz.cast(this.objectiveStatusAsString()));
            }
            case "CandidateSteps": {
                return Optional.ofNullable(clazz.cast(this.candidateSteps()));
            }
            case "CandidateStatus": {
                return Optional.ofNullable(clazz.cast(this.candidateStatusAsString()));
            }
            case "InferenceContainers": {
                return Optional.ofNullable(clazz.cast(this.inferenceContainers()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLCandidate, T> g) {
        return obj -> g.apply((AutoMLCandidate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String candidateName;
        private FinalAutoMLJobObjectiveMetric finalAutoMLJobObjectiveMetric;
        private String objectiveStatus;
        private List<AutoMLCandidateStep> candidateSteps = DefaultSdkAutoConstructList.getInstance();
        private String candidateStatus;
        private List<AutoMLContainerDefinition> inferenceContainers = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private Instant endTime;
        private Instant lastModifiedTime;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLCandidate model) {
            this.candidateName(model.candidateName);
            this.finalAutoMLJobObjectiveMetric(model.finalAutoMLJobObjectiveMetric);
            this.objectiveStatus(model.objectiveStatus);
            this.candidateSteps(model.candidateSteps);
            this.candidateStatus(model.candidateStatus);
            this.inferenceContainers(model.inferenceContainers);
            this.creationTime(model.creationTime);
            this.endTime(model.endTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.failureReason(model.failureReason);
        }

        public final String getCandidateName() {
            return this.candidateName;
        }

        @Override
        public final Builder candidateName(String candidateName) {
            this.candidateName = candidateName;
            return this;
        }

        public final void setCandidateName(String candidateName) {
            this.candidateName = candidateName;
        }

        public final FinalAutoMLJobObjectiveMetric.Builder getFinalAutoMLJobObjectiveMetric() {
            return this.finalAutoMLJobObjectiveMetric != null ? this.finalAutoMLJobObjectiveMetric.toBuilder() : null;
        }

        @Override
        public final Builder finalAutoMLJobObjectiveMetric(FinalAutoMLJobObjectiveMetric finalAutoMLJobObjectiveMetric) {
            this.finalAutoMLJobObjectiveMetric = finalAutoMLJobObjectiveMetric;
            return this;
        }

        public final void setFinalAutoMLJobObjectiveMetric(FinalAutoMLJobObjectiveMetric.BuilderImpl finalAutoMLJobObjectiveMetric) {
            this.finalAutoMLJobObjectiveMetric = finalAutoMLJobObjectiveMetric != null ? finalAutoMLJobObjectiveMetric.build() : null;
        }

        public final String getObjectiveStatus() {
            return this.objectiveStatus;
        }

        @Override
        public final Builder objectiveStatus(String objectiveStatus) {
            this.objectiveStatus = objectiveStatus;
            return this;
        }

        @Override
        public final Builder objectiveStatus(ObjectiveStatus objectiveStatus) {
            this.objectiveStatus(objectiveStatus == null ? null : objectiveStatus.toString());
            return this;
        }

        public final void setObjectiveStatus(String objectiveStatus) {
            this.objectiveStatus = objectiveStatus;
        }

        public final Collection<AutoMLCandidateStep.Builder> getCandidateSteps() {
            if (this.candidateSteps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.candidateSteps != null ? (Collection)this.candidateSteps.stream().map(AutoMLCandidateStep::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder candidateSteps(Collection<AutoMLCandidateStep> candidateSteps) {
            this.candidateSteps = CandidateStepsCopier.copy(candidateSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder candidateSteps(AutoMLCandidateStep ... candidateSteps) {
            this.candidateSteps(Arrays.asList(candidateSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder candidateSteps(Consumer<AutoMLCandidateStep.Builder> ... candidateSteps) {
            this.candidateSteps(Stream.of(candidateSteps).map(c -> (AutoMLCandidateStep)((AutoMLCandidateStep.Builder)AutoMLCandidateStep.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCandidateSteps(Collection<AutoMLCandidateStep.BuilderImpl> candidateSteps) {
            this.candidateSteps = CandidateStepsCopier.copyFromBuilder(candidateSteps);
        }

        public final String getCandidateStatus() {
            return this.candidateStatus;
        }

        @Override
        public final Builder candidateStatus(String candidateStatus) {
            this.candidateStatus = candidateStatus;
            return this;
        }

        @Override
        public final Builder candidateStatus(CandidateStatus candidateStatus) {
            this.candidateStatus(candidateStatus == null ? null : candidateStatus.toString());
            return this;
        }

        public final void setCandidateStatus(String candidateStatus) {
            this.candidateStatus = candidateStatus;
        }

        public final Collection<AutoMLContainerDefinition.Builder> getInferenceContainers() {
            if (this.inferenceContainers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inferenceContainers != null ? (Collection)this.inferenceContainers.stream().map(AutoMLContainerDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inferenceContainers(Collection<AutoMLContainerDefinition> inferenceContainers) {
            this.inferenceContainers = AutoMLContainerDefinitionsCopier.copy(inferenceContainers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceContainers(AutoMLContainerDefinition ... inferenceContainers) {
            this.inferenceContainers(Arrays.asList(inferenceContainers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceContainers(Consumer<AutoMLContainerDefinition.Builder> ... inferenceContainers) {
            this.inferenceContainers(Stream.of(inferenceContainers).map(c -> (AutoMLContainerDefinition)((AutoMLContainerDefinition.Builder)AutoMLContainerDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInferenceContainers(Collection<AutoMLContainerDefinition.BuilderImpl> inferenceContainers) {
            this.inferenceContainers = AutoMLContainerDefinitionsCopier.copyFromBuilder(inferenceContainers);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public AutoMLCandidate build() {
            return new AutoMLCandidate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoMLCandidate> {
        public Builder candidateName(String var1);

        public Builder finalAutoMLJobObjectiveMetric(FinalAutoMLJobObjectiveMetric var1);

        default public Builder finalAutoMLJobObjectiveMetric(Consumer<FinalAutoMLJobObjectiveMetric.Builder> finalAutoMLJobObjectiveMetric) {
            return this.finalAutoMLJobObjectiveMetric((FinalAutoMLJobObjectiveMetric)((FinalAutoMLJobObjectiveMetric.Builder)FinalAutoMLJobObjectiveMetric.builder().applyMutation(finalAutoMLJobObjectiveMetric)).build());
        }

        public Builder objectiveStatus(String var1);

        public Builder objectiveStatus(ObjectiveStatus var1);

        public Builder candidateSteps(Collection<AutoMLCandidateStep> var1);

        public Builder candidateSteps(AutoMLCandidateStep ... var1);

        public Builder candidateSteps(Consumer<AutoMLCandidateStep.Builder> ... var1);

        public Builder candidateStatus(String var1);

        public Builder candidateStatus(CandidateStatus var1);

        public Builder inferenceContainers(Collection<AutoMLContainerDefinition> var1);

        public Builder inferenceContainers(AutoMLContainerDefinition ... var1);

        public Builder inferenceContainers(Consumer<AutoMLContainerDefinition.Builder> ... var1);

        public Builder creationTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder failureReason(String var1);
    }
}

