/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrialComponentsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListTrialComponentsResponse.Builder, ListTrialComponentsResponse> {
    private static final SdkField<List<TrialComponentSummary>> TRIAL_COMPONENT_SUMMARIES_FIELD = SdkField
            .<List<TrialComponentSummary>> builder(MarshallingType.LIST)
            .memberName("TrialComponentSummaries")
            .getter(getter(ListTrialComponentsResponse::trialComponentSummaries))
            .setter(setter(Builder::trialComponentSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrialComponentSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialComponentSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTrialComponentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRIAL_COMPONENT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<TrialComponentSummary> trialComponentSummaries;

    private final String nextToken;

    private ListTrialComponentsResponse(BuilderImpl builder) {
        super(builder);
        this.trialComponentSummaries = builder.trialComponentSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the TrialComponentSummaries property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTrialComponentSummaries() {
        return trialComponentSummaries != null && !(trialComponentSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the summaries of your trial components.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTrialComponentSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the summaries of your trial components.
     */
    public final List<TrialComponentSummary> trialComponentSummaries() {
        return trialComponentSummaries;
    }

    /**
     * <p>
     * A token for getting the next set of components, if there are any.
     * </p>
     * 
     * @return A token for getting the next set of components, if there are any.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTrialComponentSummaries() ? trialComponentSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrialComponentsResponse)) {
            return false;
        }
        ListTrialComponentsResponse other = (ListTrialComponentsResponse) obj;
        return hasTrialComponentSummaries() == other.hasTrialComponentSummaries()
                && Objects.equals(trialComponentSummaries(), other.trialComponentSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTrialComponentsResponse")
                .add("TrialComponentSummaries", hasTrialComponentSummaries() ? trialComponentSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrialComponentSummaries":
            return Optional.ofNullable(clazz.cast(trialComponentSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrialComponentsResponse, T> g) {
        return obj -> g.apply((ListTrialComponentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTrialComponentsResponse> {
        /**
         * <p>
         * A list of the summaries of your trial components.
         * </p>
         * 
         * @param trialComponentSummaries
         *        A list of the summaries of your trial components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponentSummaries(Collection<TrialComponentSummary> trialComponentSummaries);

        /**
         * <p>
         * A list of the summaries of your trial components.
         * </p>
         * 
         * @param trialComponentSummaries
         *        A list of the summaries of your trial components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponentSummaries(TrialComponentSummary... trialComponentSummaries);

        /**
         * <p>
         * A list of the summaries of your trial components.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TrialComponentSummary>.Builder} avoiding
         * the need to create one manually via {@link List<TrialComponentSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TrialComponentSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #trialComponentSummaries(List<TrialComponentSummary>)}.
         * 
         * @param trialComponentSummaries
         *        a consumer that will call methods on {@link List<TrialComponentSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trialComponentSummaries(List<TrialComponentSummary>)
         */
        Builder trialComponentSummaries(Consumer<TrialComponentSummary.Builder>... trialComponentSummaries);

        /**
         * <p>
         * A token for getting the next set of components, if there are any.
         * </p>
         * 
         * @param nextToken
         *        A token for getting the next set of components, if there are any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<TrialComponentSummary> trialComponentSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrialComponentsResponse model) {
            super(model);
            trialComponentSummaries(model.trialComponentSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<TrialComponentSummary.Builder> getTrialComponentSummaries() {
            if (trialComponentSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return trialComponentSummaries != null ? trialComponentSummaries.stream().map(TrialComponentSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder trialComponentSummaries(Collection<TrialComponentSummary> trialComponentSummaries) {
            this.trialComponentSummaries = TrialComponentSummariesCopier.copy(trialComponentSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trialComponentSummaries(TrialComponentSummary... trialComponentSummaries) {
            trialComponentSummaries(Arrays.asList(trialComponentSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trialComponentSummaries(Consumer<TrialComponentSummary.Builder>... trialComponentSummaries) {
            trialComponentSummaries(Stream.of(trialComponentSummaries)
                    .map(c -> TrialComponentSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTrialComponentSummaries(Collection<TrialComponentSummary.BuilderImpl> trialComponentSummaries) {
            this.trialComponentSummaries = TrialComponentSummariesCopier.copyFromBuilder(trialComponentSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTrialComponentsResponse build() {
            return new ListTrialComponentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
