/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCompilationJobsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListCompilationJobsResponse.Builder, ListCompilationJobsResponse> {
    private static final SdkField<List<CompilationJobSummary>> COMPILATION_JOB_SUMMARIES_FIELD = SdkField
            .<List<CompilationJobSummary>> builder(MarshallingType.LIST)
            .memberName("CompilationJobSummaries")
            .getter(getter(ListCompilationJobsResponse::compilationJobSummaries))
            .setter(setter(Builder::compilationJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CompilationJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CompilationJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCompilationJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COMPILATION_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<CompilationJobSummary> compilationJobSummaries;

    private final String nextToken;

    private ListCompilationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.compilationJobSummaries = builder.compilationJobSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the CompilationJobSummaries property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCompilationJobSummaries() {
        return compilationJobSummaries != null && !(compilationJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a>CompilationJobSummary</a> objects, each describing a model compilation job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCompilationJobSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <a>CompilationJobSummary</a> objects, each describing a model compilation job.
     */
    public final List<CompilationJobSummary> compilationJobSummaries() {
        return compilationJobSummaries;
    }

    /**
     * <p>
     * If the response is truncated, Amazon SageMaker returns this <code>NextToken</code>. To retrieve the next set of
     * model compilation jobs, use this token in the next request.
     * </p>
     * 
     * @return If the response is truncated, Amazon SageMaker returns this <code>NextToken</code>. To retrieve the next
     *         set of model compilation jobs, use this token in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCompilationJobSummaries() ? compilationJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCompilationJobsResponse)) {
            return false;
        }
        ListCompilationJobsResponse other = (ListCompilationJobsResponse) obj;
        return hasCompilationJobSummaries() == other.hasCompilationJobSummaries()
                && Objects.equals(compilationJobSummaries(), other.compilationJobSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCompilationJobsResponse")
                .add("CompilationJobSummaries", hasCompilationJobSummaries() ? compilationJobSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompilationJobSummaries":
            return Optional.ofNullable(clazz.cast(compilationJobSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCompilationJobsResponse, T> g) {
        return obj -> g.apply((ListCompilationJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCompilationJobsResponse> {
        /**
         * <p>
         * An array of <a>CompilationJobSummary</a> objects, each describing a model compilation job.
         * </p>
         * 
         * @param compilationJobSummaries
         *        An array of <a>CompilationJobSummary</a> objects, each describing a model compilation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compilationJobSummaries(Collection<CompilationJobSummary> compilationJobSummaries);

        /**
         * <p>
         * An array of <a>CompilationJobSummary</a> objects, each describing a model compilation job.
         * </p>
         * 
         * @param compilationJobSummaries
         *        An array of <a>CompilationJobSummary</a> objects, each describing a model compilation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compilationJobSummaries(CompilationJobSummary... compilationJobSummaries);

        /**
         * <p>
         * An array of <a>CompilationJobSummary</a> objects, each describing a model compilation job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CompilationJobSummary>.Builder} avoiding
         * the need to create one manually via {@link List<CompilationJobSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CompilationJobSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #compilationJobSummaries(List<CompilationJobSummary>)}.
         * 
         * @param compilationJobSummaries
         *        a consumer that will call methods on {@link List<CompilationJobSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compilationJobSummaries(List<CompilationJobSummary>)
         */
        Builder compilationJobSummaries(Consumer<CompilationJobSummary.Builder>... compilationJobSummaries);

        /**
         * <p>
         * If the response is truncated, Amazon SageMaker returns this <code>NextToken</code>. To retrieve the next set
         * of model compilation jobs, use this token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon SageMaker returns this <code>NextToken</code>. To retrieve the
         *        next set of model compilation jobs, use this token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<CompilationJobSummary> compilationJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCompilationJobsResponse model) {
            super(model);
            compilationJobSummaries(model.compilationJobSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<CompilationJobSummary.Builder> getCompilationJobSummaries() {
            if (compilationJobSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return compilationJobSummaries != null ? compilationJobSummaries.stream().map(CompilationJobSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder compilationJobSummaries(Collection<CompilationJobSummary> compilationJobSummaries) {
            this.compilationJobSummaries = CompilationJobSummariesCopier.copy(compilationJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compilationJobSummaries(CompilationJobSummary... compilationJobSummaries) {
            compilationJobSummaries(Arrays.asList(compilationJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compilationJobSummaries(Consumer<CompilationJobSummary.Builder>... compilationJobSummaries) {
            compilationJobSummaries(Stream.of(compilationJobSummaries)
                    .map(c -> CompilationJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCompilationJobSummaries(Collection<CompilationJobSummary.BuilderImpl> compilationJobSummaries) {
            this.compilationJobSummaries = CompilationJobSummariesCopier.copyFromBuilder(compilationJobSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCompilationJobsResponse build() {
            return new ListCompilationJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
