/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for configuring the source of human task requests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HumanLoopRequestSource implements SdkPojo, Serializable,
        ToCopyableBuilder<HumanLoopRequestSource.Builder, HumanLoopRequestSource> {
    private static final SdkField<String> AWS_MANAGED_HUMAN_LOOP_REQUEST_SOURCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AwsManagedHumanLoopRequestSource")
            .getter(getter(HumanLoopRequestSource::awsManagedHumanLoopRequestSourceAsString))
            .setter(setter(Builder::awsManagedHumanLoopRequestSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsManagedHumanLoopRequestSource")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AWS_MANAGED_HUMAN_LOOP_REQUEST_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String awsManagedHumanLoopRequestSource;

    private HumanLoopRequestSource(BuilderImpl builder) {
        this.awsManagedHumanLoopRequestSource = builder.awsManagedHumanLoopRequestSource;
    }

    /**
     * <p>
     * Specifies whether Amazon Rekognition or Amazon Textract are used as the integration source. The default field
     * settings and JSON parsing rules are different based on the integration source. Valid values:
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #awsManagedHumanLoopRequestSource} will return
     * {@link AwsManagedHumanLoopRequestSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #awsManagedHumanLoopRequestSourceAsString}.
     * </p>
     * 
     * @return Specifies whether Amazon Rekognition or Amazon Textract are used as the integration source. The default
     *         field settings and JSON parsing rules are different based on the integration source. Valid values:
     * @see AwsManagedHumanLoopRequestSource
     */
    public final AwsManagedHumanLoopRequestSource awsManagedHumanLoopRequestSource() {
        return AwsManagedHumanLoopRequestSource.fromValue(awsManagedHumanLoopRequestSource);
    }

    /**
     * <p>
     * Specifies whether Amazon Rekognition or Amazon Textract are used as the integration source. The default field
     * settings and JSON parsing rules are different based on the integration source. Valid values:
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #awsManagedHumanLoopRequestSource} will return
     * {@link AwsManagedHumanLoopRequestSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #awsManagedHumanLoopRequestSourceAsString}.
     * </p>
     * 
     * @return Specifies whether Amazon Rekognition or Amazon Textract are used as the integration source. The default
     *         field settings and JSON parsing rules are different based on the integration source. Valid values:
     * @see AwsManagedHumanLoopRequestSource
     */
    public final String awsManagedHumanLoopRequestSourceAsString() {
        return awsManagedHumanLoopRequestSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsManagedHumanLoopRequestSourceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanLoopRequestSource)) {
            return false;
        }
        HumanLoopRequestSource other = (HumanLoopRequestSource) obj;
        return Objects.equals(awsManagedHumanLoopRequestSourceAsString(), other.awsManagedHumanLoopRequestSourceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HumanLoopRequestSource")
                .add("AwsManagedHumanLoopRequestSource", awsManagedHumanLoopRequestSourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsManagedHumanLoopRequestSource":
            return Optional.ofNullable(clazz.cast(awsManagedHumanLoopRequestSourceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HumanLoopRequestSource, T> g) {
        return obj -> g.apply((HumanLoopRequestSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HumanLoopRequestSource> {
        /**
         * <p>
         * Specifies whether Amazon Rekognition or Amazon Textract are used as the integration source. The default field
         * settings and JSON parsing rules are different based on the integration source. Valid values:
         * </p>
         * 
         * @param awsManagedHumanLoopRequestSource
         *        Specifies whether Amazon Rekognition or Amazon Textract are used as the integration source. The
         *        default field settings and JSON parsing rules are different based on the integration source. Valid
         *        values:
         * @see AwsManagedHumanLoopRequestSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsManagedHumanLoopRequestSource
         */
        Builder awsManagedHumanLoopRequestSource(String awsManagedHumanLoopRequestSource);

        /**
         * <p>
         * Specifies whether Amazon Rekognition or Amazon Textract are used as the integration source. The default field
         * settings and JSON parsing rules are different based on the integration source. Valid values:
         * </p>
         * 
         * @param awsManagedHumanLoopRequestSource
         *        Specifies whether Amazon Rekognition or Amazon Textract are used as the integration source. The
         *        default field settings and JSON parsing rules are different based on the integration source. Valid
         *        values:
         * @see AwsManagedHumanLoopRequestSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsManagedHumanLoopRequestSource
         */
        Builder awsManagedHumanLoopRequestSource(AwsManagedHumanLoopRequestSource awsManagedHumanLoopRequestSource);
    }

    static final class BuilderImpl implements Builder {
        private String awsManagedHumanLoopRequestSource;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanLoopRequestSource model) {
            awsManagedHumanLoopRequestSource(model.awsManagedHumanLoopRequestSource);
        }

        public final String getAwsManagedHumanLoopRequestSource() {
            return awsManagedHumanLoopRequestSource;
        }

        @Override
        public final Builder awsManagedHumanLoopRequestSource(String awsManagedHumanLoopRequestSource) {
            this.awsManagedHumanLoopRequestSource = awsManagedHumanLoopRequestSource;
            return this;
        }

        @Override
        public final Builder awsManagedHumanLoopRequestSource(AwsManagedHumanLoopRequestSource awsManagedHumanLoopRequestSource) {
            this.awsManagedHumanLoopRequestSource(awsManagedHumanLoopRequestSource == null ? null
                    : awsManagedHumanLoopRequestSource.toString());
            return this;
        }

        public final void setAwsManagedHumanLoopRequestSource(String awsManagedHumanLoopRequestSource) {
            this.awsManagedHumanLoopRequestSource = awsManagedHumanLoopRequestSource;
        }

        @Override
        public HumanLoopRequestSource build() {
            return new HumanLoopRequestSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
