/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImageVersionResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeImageVersionResponse.Builder, DescribeImageVersionResponse> {
    private static final SdkField<String> BASE_IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseImage").getter(getter(DescribeImageVersionResponse::baseImage)).setter(setter(Builder::baseImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseImage").build()).build();

    private static final SdkField<String> CONTAINER_IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContainerImage").getter(getter(DescribeImageVersionResponse::containerImage))
            .setter(setter(Builder::containerImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerImage").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeImageVersionResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeImageVersionResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> IMAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageArn").getter(getter(DescribeImageVersionResponse::imageArn)).setter(setter(Builder::imageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageArn").build()).build();

    private static final SdkField<String> IMAGE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageVersionArn").getter(getter(DescribeImageVersionResponse::imageVersionArn))
            .setter(setter(Builder::imageVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageVersionArn").build()).build();

    private static final SdkField<String> IMAGE_VERSION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageVersionStatus").getter(getter(DescribeImageVersionResponse::imageVersionStatusAsString))
            .setter(setter(Builder::imageVersionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageVersionStatus").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeImageVersionResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Integer> VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Version").getter(getter(DescribeImageVersionResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_IMAGE_FIELD,
            CONTAINER_IMAGE_FIELD, CREATION_TIME_FIELD, FAILURE_REASON_FIELD, IMAGE_ARN_FIELD, IMAGE_VERSION_ARN_FIELD,
            IMAGE_VERSION_STATUS_FIELD, LAST_MODIFIED_TIME_FIELD, VERSION_FIELD));

    private final String baseImage;

    private final String containerImage;

    private final Instant creationTime;

    private final String failureReason;

    private final String imageArn;

    private final String imageVersionArn;

    private final String imageVersionStatus;

    private final Instant lastModifiedTime;

    private final Integer version;

    private DescribeImageVersionResponse(BuilderImpl builder) {
        super(builder);
        this.baseImage = builder.baseImage;
        this.containerImage = builder.containerImage;
        this.creationTime = builder.creationTime;
        this.failureReason = builder.failureReason;
        this.imageArn = builder.imageArn;
        this.imageVersionArn = builder.imageVersionArn;
        this.imageVersionStatus = builder.imageVersionStatus;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.version = builder.version;
    }

    /**
     * <p>
     * The registry path of the container image on which this image version is based.
     * </p>
     * 
     * @return The registry path of the container image on which this image version is based.
     */
    public final String baseImage() {
        return baseImage;
    }

    /**
     * <p>
     * The registry path of the container image that contains this image version.
     * </p>
     * 
     * @return The registry path of the container image that contains this image version.
     */
    public final String containerImage() {
        return containerImage;
    }

    /**
     * <p>
     * When the version was created.
     * </p>
     * 
     * @return When the version was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When a create or delete operation fails, the reason for the failure.
     * </p>
     * 
     * @return When a create or delete operation fails, the reason for the failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the image the version is based on.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the image the version is based on.
     */
    public final String imageArn() {
        return imageArn;
    }

    /**
     * <p>
     * The ARN of the version.
     * </p>
     * 
     * @return The ARN of the version.
     */
    public final String imageVersionArn() {
        return imageVersionArn;
    }

    /**
     * <p>
     * The status of the version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageVersionStatus} will return {@link ImageVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #imageVersionStatusAsString}.
     * </p>
     * 
     * @return The status of the version.
     * @see ImageVersionStatus
     */
    public final ImageVersionStatus imageVersionStatus() {
        return ImageVersionStatus.fromValue(imageVersionStatus);
    }

    /**
     * <p>
     * The status of the version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageVersionStatus} will return {@link ImageVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #imageVersionStatusAsString}.
     * </p>
     * 
     * @return The status of the version.
     * @see ImageVersionStatus
     */
    public final String imageVersionStatusAsString() {
        return imageVersionStatus;
    }

    /**
     * <p>
     * When the version was last modified.
     * </p>
     * 
     * @return When the version was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The version number.
     * </p>
     * 
     * @return The version number.
     */
    public final Integer version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(baseImage());
        hashCode = 31 * hashCode + Objects.hashCode(containerImage());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(imageArn());
        hashCode = 31 * hashCode + Objects.hashCode(imageVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(imageVersionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageVersionResponse)) {
            return false;
        }
        DescribeImageVersionResponse other = (DescribeImageVersionResponse) obj;
        return Objects.equals(baseImage(), other.baseImage()) && Objects.equals(containerImage(), other.containerImage())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(imageArn(), other.imageArn()) && Objects.equals(imageVersionArn(), other.imageVersionArn())
                && Objects.equals(imageVersionStatusAsString(), other.imageVersionStatusAsString())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImageVersionResponse").add("BaseImage", baseImage())
                .add("ContainerImage", containerImage()).add("CreationTime", creationTime())
                .add("FailureReason", failureReason()).add("ImageArn", imageArn()).add("ImageVersionArn", imageVersionArn())
                .add("ImageVersionStatus", imageVersionStatusAsString()).add("LastModifiedTime", lastModifiedTime())
                .add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaseImage":
            return Optional.ofNullable(clazz.cast(baseImage()));
        case "ContainerImage":
            return Optional.ofNullable(clazz.cast(containerImage()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "ImageArn":
            return Optional.ofNullable(clazz.cast(imageArn()));
        case "ImageVersionArn":
            return Optional.ofNullable(clazz.cast(imageVersionArn()));
        case "ImageVersionStatus":
            return Optional.ofNullable(clazz.cast(imageVersionStatusAsString()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageVersionResponse, T> g) {
        return obj -> g.apply((DescribeImageVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImageVersionResponse> {
        /**
         * <p>
         * The registry path of the container image on which this image version is based.
         * </p>
         * 
         * @param baseImage
         *        The registry path of the container image on which this image version is based.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseImage(String baseImage);

        /**
         * <p>
         * The registry path of the container image that contains this image version.
         * </p>
         * 
         * @param containerImage
         *        The registry path of the container image that contains this image version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerImage(String containerImage);

        /**
         * <p>
         * When the version was created.
         * </p>
         * 
         * @param creationTime
         *        When the version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When a create or delete operation fails, the reason for the failure.
         * </p>
         * 
         * @param failureReason
         *        When a create or delete operation fails, the reason for the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the image the version is based on.
         * </p>
         * 
         * @param imageArn
         *        The Amazon Resource Name (ARN) of the image the version is based on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageArn(String imageArn);

        /**
         * <p>
         * The ARN of the version.
         * </p>
         * 
         * @param imageVersionArn
         *        The ARN of the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageVersionArn(String imageVersionArn);

        /**
         * <p>
         * The status of the version.
         * </p>
         * 
         * @param imageVersionStatus
         *        The status of the version.
         * @see ImageVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageVersionStatus
         */
        Builder imageVersionStatus(String imageVersionStatus);

        /**
         * <p>
         * The status of the version.
         * </p>
         * 
         * @param imageVersionStatus
         *        The status of the version.
         * @see ImageVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageVersionStatus
         */
        Builder imageVersionStatus(ImageVersionStatus imageVersionStatus);

        /**
         * <p>
         * When the version was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        When the version was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The version number.
         * </p>
         * 
         * @param version
         *        The version number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String baseImage;

        private String containerImage;

        private Instant creationTime;

        private String failureReason;

        private String imageArn;

        private String imageVersionArn;

        private String imageVersionStatus;

        private Instant lastModifiedTime;

        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageVersionResponse model) {
            super(model);
            baseImage(model.baseImage);
            containerImage(model.containerImage);
            creationTime(model.creationTime);
            failureReason(model.failureReason);
            imageArn(model.imageArn);
            imageVersionArn(model.imageVersionArn);
            imageVersionStatus(model.imageVersionStatus);
            lastModifiedTime(model.lastModifiedTime);
            version(model.version);
        }

        public final String getBaseImage() {
            return baseImage;
        }

        @Override
        public final Builder baseImage(String baseImage) {
            this.baseImage = baseImage;
            return this;
        }

        public final void setBaseImage(String baseImage) {
            this.baseImage = baseImage;
        }

        public final String getContainerImage() {
            return containerImage;
        }

        @Override
        public final Builder containerImage(String containerImage) {
            this.containerImage = containerImage;
            return this;
        }

        public final void setContainerImage(String containerImage) {
            this.containerImage = containerImage;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getImageArn() {
            return imageArn;
        }

        @Override
        public final Builder imageArn(String imageArn) {
            this.imageArn = imageArn;
            return this;
        }

        public final void setImageArn(String imageArn) {
            this.imageArn = imageArn;
        }

        public final String getImageVersionArn() {
            return imageVersionArn;
        }

        @Override
        public final Builder imageVersionArn(String imageVersionArn) {
            this.imageVersionArn = imageVersionArn;
            return this;
        }

        public final void setImageVersionArn(String imageVersionArn) {
            this.imageVersionArn = imageVersionArn;
        }

        public final String getImageVersionStatus() {
            return imageVersionStatus;
        }

        @Override
        public final Builder imageVersionStatus(String imageVersionStatus) {
            this.imageVersionStatus = imageVersionStatus;
            return this;
        }

        @Override
        public final Builder imageVersionStatus(ImageVersionStatus imageVersionStatus) {
            this.imageVersionStatus(imageVersionStatus == null ? null : imageVersionStatus.toString());
            return this;
        }

        public final void setImageVersionStatus(String imageVersionStatus) {
            this.imageVersionStatus = imageVersionStatus;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final Integer getVersion() {
            return version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public DescribeImageVersionResponse build() {
            return new DescribeImageVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
