/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackagesResponse;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageSummary;

public class ListModelPackagesPublisher
implements SdkPublisher<ListModelPackagesResponse> {
    private final SageMakerAsyncClient client;
    private final ListModelPackagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListModelPackagesPublisher(SageMakerAsyncClient client, ListModelPackagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListModelPackagesPublisher(SageMakerAsyncClient client, ListModelPackagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListModelPackagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListModelPackagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ModelPackageSummary> modelPackageSummaryList() {
        Function<ListModelPackagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.modelPackageSummaryList() != null) {
                return response.modelPackageSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListModelPackagesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListModelPackagesResponseFetcher
    implements AsyncPageFetcher<ListModelPackagesResponse> {
        private ListModelPackagesResponseFetcher() {
        }

        public boolean hasNextPage(ListModelPackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListModelPackagesResponse> nextPage(ListModelPackagesResponse previousPage) {
            if (previousPage == null) {
                return ListModelPackagesPublisher.this.client.listModelPackages(ListModelPackagesPublisher.this.firstRequest);
            }
            return ListModelPackagesPublisher.this.client.listModelPackages((ListModelPackagesRequest)((Object)ListModelPackagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

