/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ContextSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.ContextSummary;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListContextsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListContextsResponse> {
    private static final SdkField<List<ContextSummary>> CONTEXT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContextSummaries").getter(ListContextsResponse.getter(ListContextsResponse::contextSummaries)).setter(ListContextsResponse.setter(Builder::contextSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContextSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListContextsResponse.getter(ListContextsResponse::nextToken)).setter(ListContextsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ContextSummary> contextSummaries;
    private final String nextToken;

    private ListContextsResponse(BuilderImpl builder) {
        super(builder);
        this.contextSummaries = builder.contextSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasContextSummaries() {
        return this.contextSummaries != null && !(this.contextSummaries instanceof SdkAutoConstructList);
    }

    public final List<ContextSummary> contextSummaries() {
        return this.contextSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContextSummaries() ? this.contextSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContextsResponse)) {
            return false;
        }
        ListContextsResponse other = (ListContextsResponse)((Object)obj);
        return this.hasContextSummaries() == other.hasContextSummaries() && Objects.equals(this.contextSummaries(), other.contextSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListContextsResponse").add("ContextSummaries", this.hasContextSummaries() ? this.contextSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContextSummaries": {
                return Optional.ofNullable(clazz.cast(this.contextSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListContextsResponse, T> g) {
        return obj -> g.apply((ListContextsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<ContextSummary> contextSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContextsResponse model) {
            super(model);
            this.contextSummaries(model.contextSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<ContextSummary.Builder> getContextSummaries() {
            if (this.contextSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.contextSummaries != null ? (Collection)this.contextSummaries.stream().map(ContextSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder contextSummaries(Collection<ContextSummary> contextSummaries) {
            this.contextSummaries = ContextSummariesCopier.copy(contextSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextSummaries(ContextSummary ... contextSummaries) {
            this.contextSummaries(Arrays.asList(contextSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextSummaries(Consumer<ContextSummary.Builder> ... contextSummaries) {
            this.contextSummaries(Stream.of(contextSummaries).map(c -> (ContextSummary)((ContextSummary.Builder)ContextSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContextSummaries(Collection<ContextSummary.BuilderImpl> contextSummaries) {
            this.contextSummaries = ContextSummariesCopier.copyFromBuilder(contextSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListContextsResponse build() {
            return new ListContextsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListContextsResponse> {
        public Builder contextSummaries(Collection<ContextSummary> var1);

        public Builder contextSummaries(ContextSummary ... var1);

        public Builder contextSummaries(Consumer<ContextSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

