/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ExperimentSummary;
import software.amazon.awssdk.services.sagemaker.model.ListExperimentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListExperimentsResponse;

public class ListExperimentsPublisher
implements SdkPublisher<ListExperimentsResponse> {
    private final SageMakerAsyncClient client;
    private final ListExperimentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListExperimentsPublisher(SageMakerAsyncClient client, ListExperimentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListExperimentsPublisher(SageMakerAsyncClient client, ListExperimentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListExperimentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListExperimentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ExperimentSummary> experimentSummaries() {
        Function<ListExperimentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.experimentSummaries() != null) {
                return response.experimentSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListExperimentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListExperimentsResponseFetcher
    implements AsyncPageFetcher<ListExperimentsResponse> {
        private ListExperimentsResponseFetcher() {
        }

        public boolean hasNextPage(ListExperimentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListExperimentsResponse> nextPage(ListExperimentsResponse previousPage) {
            if (previousPage == null) {
                return ListExperimentsPublisher.this.client.listExperiments(ListExperimentsPublisher.this.firstRequest);
            }
            return ListExperimentsPublisher.this.client.listExperiments((ListExperimentsRequest)((Object)ListExperimentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

