/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsResponse;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentSummary;

public class ListTrialComponentsPublisher
implements SdkPublisher<ListTrialComponentsResponse> {
    private final SageMakerAsyncClient client;
    private final ListTrialComponentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTrialComponentsPublisher(SageMakerAsyncClient client, ListTrialComponentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTrialComponentsPublisher(SageMakerAsyncClient client, ListTrialComponentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTrialComponentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTrialComponentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrialComponentSummary> trialComponentSummaries() {
        Function<ListTrialComponentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trialComponentSummaries() != null) {
                return response.trialComponentSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTrialComponentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTrialComponentsResponseFetcher
    implements AsyncPageFetcher<ListTrialComponentsResponse> {
        private ListTrialComponentsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrialComponentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTrialComponentsResponse> nextPage(ListTrialComponentsResponse previousPage) {
            if (previousPage == null) {
                return ListTrialComponentsPublisher.this.client.listTrialComponents(ListTrialComponentsPublisher.this.firstRequest);
            }
            return ListTrialComponentsPublisher.this.client.listTrialComponents((ListTrialComponentsRequest)((Object)ListTrialComponentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

