/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelDeployConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelDeployConfig> {
    private static final SdkField<Boolean> AUTO_GENERATE_ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoGenerateEndpointName").getter(ModelDeployConfig.getter(ModelDeployConfig::autoGenerateEndpointName)).setter(ModelDeployConfig.setter(Builder::autoGenerateEndpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoGenerateEndpointName").build()}).build();
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(ModelDeployConfig.getter(ModelDeployConfig::endpointName)).setter(ModelDeployConfig.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_GENERATE_ENDPOINT_NAME_FIELD, ENDPOINT_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean autoGenerateEndpointName;
    private final String endpointName;

    private ModelDeployConfig(BuilderImpl builder) {
        this.autoGenerateEndpointName = builder.autoGenerateEndpointName;
        this.endpointName = builder.endpointName;
    }

    public final Boolean autoGenerateEndpointName() {
        return this.autoGenerateEndpointName;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoGenerateEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelDeployConfig)) {
            return false;
        }
        ModelDeployConfig other = (ModelDeployConfig)obj;
        return Objects.equals(this.autoGenerateEndpointName(), other.autoGenerateEndpointName()) && Objects.equals(this.endpointName(), other.endpointName());
    }

    public final String toString() {
        return ToString.builder((String)"ModelDeployConfig").add("AutoGenerateEndpointName", (Object)this.autoGenerateEndpointName()).add("EndpointName", (Object)this.endpointName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoGenerateEndpointName": {
                return Optional.ofNullable(clazz.cast(this.autoGenerateEndpointName()));
            }
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelDeployConfig, T> g) {
        return obj -> g.apply((ModelDeployConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean autoGenerateEndpointName;
        private String endpointName;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelDeployConfig model) {
            this.autoGenerateEndpointName(model.autoGenerateEndpointName);
            this.endpointName(model.endpointName);
        }

        public final Boolean getAutoGenerateEndpointName() {
            return this.autoGenerateEndpointName;
        }

        @Override
        public final Builder autoGenerateEndpointName(Boolean autoGenerateEndpointName) {
            this.autoGenerateEndpointName = autoGenerateEndpointName;
            return this;
        }

        public final void setAutoGenerateEndpointName(Boolean autoGenerateEndpointName) {
            this.autoGenerateEndpointName = autoGenerateEndpointName;
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public ModelDeployConfig build() {
            return new ModelDeployConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelDeployConfig> {
        public Builder autoGenerateEndpointName(Boolean var1);

        public Builder endpointName(String var1);
    }
}

