/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.EdgeModelSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.EdgeModelSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceSummary> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceName").getter(DeviceSummary.getter(DeviceSummary::deviceName)).setter(DeviceSummary.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()}).build();
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceArn").getter(DeviceSummary.getter(DeviceSummary::deviceArn)).setter(DeviceSummary.setter(Builder::deviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DeviceSummary.getter(DeviceSummary::description)).setter(DeviceSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceFleetName").getter(DeviceSummary.getter(DeviceSummary::deviceFleetName)).setter(DeviceSummary.setter(Builder::deviceFleetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()}).build();
    private static final SdkField<String> IOT_THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IotThingName").getter(DeviceSummary.getter(DeviceSummary::iotThingName)).setter(DeviceSummary.setter(Builder::iotThingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IotThingName").build()}).build();
    private static final SdkField<Instant> REGISTRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RegistrationTime").getter(DeviceSummary.getter(DeviceSummary::registrationTime)).setter(DeviceSummary.setter(Builder::registrationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationTime").build()}).build();
    private static final SdkField<Instant> LATEST_HEARTBEAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestHeartbeat").getter(DeviceSummary.getter(DeviceSummary::latestHeartbeat)).setter(DeviceSummary.setter(Builder::latestHeartbeat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestHeartbeat").build()}).build();
    private static final SdkField<List<EdgeModelSummary>> MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Models").getter(DeviceSummary.getter(DeviceSummary::models)).setter(DeviceSummary.setter(Builder::models)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Models").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EdgeModelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD, DEVICE_ARN_FIELD, DESCRIPTION_FIELD, DEVICE_FLEET_NAME_FIELD, IOT_THING_NAME_FIELD, REGISTRATION_TIME_FIELD, LATEST_HEARTBEAT_FIELD, MODELS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deviceName;
    private final String deviceArn;
    private final String description;
    private final String deviceFleetName;
    private final String iotThingName;
    private final Instant registrationTime;
    private final Instant latestHeartbeat;
    private final List<EdgeModelSummary> models;

    private DeviceSummary(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.deviceArn = builder.deviceArn;
        this.description = builder.description;
        this.deviceFleetName = builder.deviceFleetName;
        this.iotThingName = builder.iotThingName;
        this.registrationTime = builder.registrationTime;
        this.latestHeartbeat = builder.latestHeartbeat;
        this.models = builder.models;
    }

    public final String deviceName() {
        return this.deviceName;
    }

    public final String deviceArn() {
        return this.deviceArn;
    }

    public final String description() {
        return this.description;
    }

    public final String deviceFleetName() {
        return this.deviceFleetName;
    }

    public final String iotThingName() {
        return this.iotThingName;
    }

    public final Instant registrationTime() {
        return this.registrationTime;
    }

    public final Instant latestHeartbeat() {
        return this.latestHeartbeat;
    }

    public final boolean hasModels() {
        return this.models != null && !(this.models instanceof SdkAutoConstructList);
    }

    public final List<EdgeModelSummary> models() {
        return this.models;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceFleetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotThingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestHeartbeat());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModels() ? this.models() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceSummary)) {
            return false;
        }
        DeviceSummary other = (DeviceSummary)obj;
        return Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.deviceFleetName(), other.deviceFleetName()) && Objects.equals(this.iotThingName(), other.iotThingName()) && Objects.equals(this.registrationTime(), other.registrationTime()) && Objects.equals(this.latestHeartbeat(), other.latestHeartbeat()) && this.hasModels() == other.hasModels() && Objects.equals(this.models(), other.models());
    }

    public final String toString() {
        return ToString.builder((String)"DeviceSummary").add("DeviceName", (Object)this.deviceName()).add("DeviceArn", (Object)this.deviceArn()).add("Description", (Object)this.description()).add("DeviceFleetName", (Object)this.deviceFleetName()).add("IotThingName", (Object)this.iotThingName()).add("RegistrationTime", (Object)this.registrationTime()).add("LatestHeartbeat", (Object)this.latestHeartbeat()).add("Models", this.hasModels() ? this.models() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "DeviceArn": {
                return Optional.ofNullable(clazz.cast(this.deviceArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DeviceFleetName": {
                return Optional.ofNullable(clazz.cast(this.deviceFleetName()));
            }
            case "IotThingName": {
                return Optional.ofNullable(clazz.cast(this.iotThingName()));
            }
            case "RegistrationTime": {
                return Optional.ofNullable(clazz.cast(this.registrationTime()));
            }
            case "LatestHeartbeat": {
                return Optional.ofNullable(clazz.cast(this.latestHeartbeat()));
            }
            case "Models": {
                return Optional.ofNullable(clazz.cast(this.models()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceSummary, T> g) {
        return obj -> g.apply((DeviceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceName;
        private String deviceArn;
        private String description;
        private String deviceFleetName;
        private String iotThingName;
        private Instant registrationTime;
        private Instant latestHeartbeat;
        private List<EdgeModelSummary> models = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceSummary model) {
            this.deviceName(model.deviceName);
            this.deviceArn(model.deviceArn);
            this.description(model.description);
            this.deviceFleetName(model.deviceFleetName);
            this.iotThingName(model.iotThingName);
            this.registrationTime(model.registrationTime);
            this.latestHeartbeat(model.latestHeartbeat);
            this.models(model.models);
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDeviceFleetName() {
            return this.deviceFleetName;
        }

        @Override
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        public final String getIotThingName() {
            return this.iotThingName;
        }

        @Override
        public final Builder iotThingName(String iotThingName) {
            this.iotThingName = iotThingName;
            return this;
        }

        public final void setIotThingName(String iotThingName) {
            this.iotThingName = iotThingName;
        }

        public final Instant getRegistrationTime() {
            return this.registrationTime;
        }

        @Override
        public final Builder registrationTime(Instant registrationTime) {
            this.registrationTime = registrationTime;
            return this;
        }

        public final void setRegistrationTime(Instant registrationTime) {
            this.registrationTime = registrationTime;
        }

        public final Instant getLatestHeartbeat() {
            return this.latestHeartbeat;
        }

        @Override
        public final Builder latestHeartbeat(Instant latestHeartbeat) {
            this.latestHeartbeat = latestHeartbeat;
            return this;
        }

        public final void setLatestHeartbeat(Instant latestHeartbeat) {
            this.latestHeartbeat = latestHeartbeat;
        }

        public final List<EdgeModelSummary.Builder> getModels() {
            List<EdgeModelSummary.Builder> result = EdgeModelSummariesCopier.copyToBuilder(this.models);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder models(Collection<EdgeModelSummary> models) {
            this.models = EdgeModelSummariesCopier.copy(models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(EdgeModelSummary ... models) {
            this.models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<EdgeModelSummary.Builder> ... models) {
            this.models(Stream.of(models).map(c -> (EdgeModelSummary)((EdgeModelSummary.Builder)EdgeModelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModels(Collection<EdgeModelSummary.BuilderImpl> models) {
            this.models = EdgeModelSummariesCopier.copyFromBuilder(models);
        }

        public DeviceSummary build() {
            return new DeviceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceSummary> {
        public Builder deviceName(String var1);

        public Builder deviceArn(String var1);

        public Builder description(String var1);

        public Builder deviceFleetName(String var1);

        public Builder iotThingName(String var1);

        public Builder registrationTime(Instant var1);

        public Builder latestHeartbeat(Instant var1);

        public Builder models(Collection<EdgeModelSummary> var1);

        public Builder models(EdgeModelSummary ... var1);

        public Builder models(Consumer<EdgeModelSummary.Builder> ... var1);
    }
}

