/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.InferenceSpecification;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageValidationSpecification;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SourceAlgorithmSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateModelPackageRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateModelPackageRequest> {
    private static final SdkField<String> MODEL_PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageName").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::modelPackageName)).setter(CreateModelPackageRequest.setter(Builder::modelPackageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageName").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageDescription").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::modelPackageDescription)).setter(CreateModelPackageRequest.setter(Builder::modelPackageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageDescription").build()}).build();
    private static final SdkField<InferenceSpecification> INFERENCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InferenceSpecification").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::inferenceSpecification)).setter(CreateModelPackageRequest.setter(Builder::inferenceSpecification)).constructor(InferenceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSpecification").build()}).build();
    private static final SdkField<ModelPackageValidationSpecification> VALIDATION_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValidationSpecification").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::validationSpecification)).setter(CreateModelPackageRequest.setter(Builder::validationSpecification)).constructor(ModelPackageValidationSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationSpecification").build()}).build();
    private static final SdkField<SourceAlgorithmSpecification> SOURCE_ALGORITHM_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceAlgorithmSpecification").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::sourceAlgorithmSpecification)).setter(CreateModelPackageRequest.setter(Builder::sourceAlgorithmSpecification)).constructor(SourceAlgorithmSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAlgorithmSpecification").build()}).build();
    private static final SdkField<Boolean> CERTIFY_FOR_MARKETPLACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CertifyForMarketplace").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::certifyForMarketplace)).setter(CreateModelPackageRequest.setter(Builder::certifyForMarketplace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertifyForMarketplace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_NAME_FIELD, MODEL_PACKAGE_DESCRIPTION_FIELD, INFERENCE_SPECIFICATION_FIELD, VALIDATION_SPECIFICATION_FIELD, SOURCE_ALGORITHM_SPECIFICATION_FIELD, CERTIFY_FOR_MARKETPLACE_FIELD));
    private final String modelPackageName;
    private final String modelPackageDescription;
    private final InferenceSpecification inferenceSpecification;
    private final ModelPackageValidationSpecification validationSpecification;
    private final SourceAlgorithmSpecification sourceAlgorithmSpecification;
    private final Boolean certifyForMarketplace;

    private CreateModelPackageRequest(BuilderImpl builder) {
        super(builder);
        this.modelPackageName = builder.modelPackageName;
        this.modelPackageDescription = builder.modelPackageDescription;
        this.inferenceSpecification = builder.inferenceSpecification;
        this.validationSpecification = builder.validationSpecification;
        this.sourceAlgorithmSpecification = builder.sourceAlgorithmSpecification;
        this.certifyForMarketplace = builder.certifyForMarketplace;
    }

    public String modelPackageName() {
        return this.modelPackageName;
    }

    public String modelPackageDescription() {
        return this.modelPackageDescription;
    }

    public InferenceSpecification inferenceSpecification() {
        return this.inferenceSpecification;
    }

    public ModelPackageValidationSpecification validationSpecification() {
        return this.validationSpecification;
    }

    public SourceAlgorithmSpecification sourceAlgorithmSpecification() {
        return this.sourceAlgorithmSpecification;
    }

    public Boolean certifyForMarketplace() {
        return this.certifyForMarketplace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAlgorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.certifyForMarketplace());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelPackageRequest)) {
            return false;
        }
        CreateModelPackageRequest other = (CreateModelPackageRequest)((Object)obj);
        return Objects.equals(this.modelPackageName(), other.modelPackageName()) && Objects.equals(this.modelPackageDescription(), other.modelPackageDescription()) && Objects.equals(this.inferenceSpecification(), other.inferenceSpecification()) && Objects.equals(this.validationSpecification(), other.validationSpecification()) && Objects.equals(this.sourceAlgorithmSpecification(), other.sourceAlgorithmSpecification()) && Objects.equals(this.certifyForMarketplace(), other.certifyForMarketplace());
    }

    public String toString() {
        return ToString.builder((String)"CreateModelPackageRequest").add("ModelPackageName", (Object)this.modelPackageName()).add("ModelPackageDescription", (Object)this.modelPackageDescription()).add("InferenceSpecification", (Object)this.inferenceSpecification()).add("ValidationSpecification", (Object)this.validationSpecification()).add("SourceAlgorithmSpecification", (Object)this.sourceAlgorithmSpecification()).add("CertifyForMarketplace", (Object)this.certifyForMarketplace()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelPackageName": {
                return Optional.ofNullable(clazz.cast(this.modelPackageName()));
            }
            case "ModelPackageDescription": {
                return Optional.ofNullable(clazz.cast(this.modelPackageDescription()));
            }
            case "InferenceSpecification": {
                return Optional.ofNullable(clazz.cast(this.inferenceSpecification()));
            }
            case "ValidationSpecification": {
                return Optional.ofNullable(clazz.cast(this.validationSpecification()));
            }
            case "SourceAlgorithmSpecification": {
                return Optional.ofNullable(clazz.cast(this.sourceAlgorithmSpecification()));
            }
            case "CertifyForMarketplace": {
                return Optional.ofNullable(clazz.cast(this.certifyForMarketplace()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelPackageRequest, T> g) {
        return obj -> g.apply((CreateModelPackageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String modelPackageName;
        private String modelPackageDescription;
        private InferenceSpecification inferenceSpecification;
        private ModelPackageValidationSpecification validationSpecification;
        private SourceAlgorithmSpecification sourceAlgorithmSpecification;
        private Boolean certifyForMarketplace;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelPackageRequest model) {
            super(model);
            this.modelPackageName(model.modelPackageName);
            this.modelPackageDescription(model.modelPackageDescription);
            this.inferenceSpecification(model.inferenceSpecification);
            this.validationSpecification(model.validationSpecification);
            this.sourceAlgorithmSpecification(model.sourceAlgorithmSpecification);
            this.certifyForMarketplace(model.certifyForMarketplace);
        }

        public final String getModelPackageName() {
            return this.modelPackageName;
        }

        @Override
        public final Builder modelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
            return this;
        }

        public final void setModelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
        }

        public final String getModelPackageDescription() {
            return this.modelPackageDescription;
        }

        @Override
        public final Builder modelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
            return this;
        }

        public final void setModelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
        }

        public final InferenceSpecification.Builder getInferenceSpecification() {
            return this.inferenceSpecification != null ? this.inferenceSpecification.toBuilder() : null;
        }

        @Override
        public final Builder inferenceSpecification(InferenceSpecification inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification;
            return this;
        }

        public final void setInferenceSpecification(InferenceSpecification.BuilderImpl inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification != null ? inferenceSpecification.build() : null;
        }

        public final ModelPackageValidationSpecification.Builder getValidationSpecification() {
            return this.validationSpecification != null ? this.validationSpecification.toBuilder() : null;
        }

        @Override
        public final Builder validationSpecification(ModelPackageValidationSpecification validationSpecification) {
            this.validationSpecification = validationSpecification;
            return this;
        }

        public final void setValidationSpecification(ModelPackageValidationSpecification.BuilderImpl validationSpecification) {
            this.validationSpecification = validationSpecification != null ? validationSpecification.build() : null;
        }

        public final SourceAlgorithmSpecification.Builder getSourceAlgorithmSpecification() {
            return this.sourceAlgorithmSpecification != null ? this.sourceAlgorithmSpecification.toBuilder() : null;
        }

        @Override
        public final Builder sourceAlgorithmSpecification(SourceAlgorithmSpecification sourceAlgorithmSpecification) {
            this.sourceAlgorithmSpecification = sourceAlgorithmSpecification;
            return this;
        }

        public final void setSourceAlgorithmSpecification(SourceAlgorithmSpecification.BuilderImpl sourceAlgorithmSpecification) {
            this.sourceAlgorithmSpecification = sourceAlgorithmSpecification != null ? sourceAlgorithmSpecification.build() : null;
        }

        public final Boolean getCertifyForMarketplace() {
            return this.certifyForMarketplace;
        }

        @Override
        public final Builder certifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
            return this;
        }

        public final void setCertifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelPackageRequest build() {
            return new CreateModelPackageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateModelPackageRequest> {
        public Builder modelPackageName(String var1);

        public Builder modelPackageDescription(String var1);

        public Builder inferenceSpecification(InferenceSpecification var1);

        default public Builder inferenceSpecification(Consumer<InferenceSpecification.Builder> inferenceSpecification) {
            return this.inferenceSpecification((InferenceSpecification)((InferenceSpecification.Builder)InferenceSpecification.builder().applyMutation(inferenceSpecification)).build());
        }

        public Builder validationSpecification(ModelPackageValidationSpecification var1);

        default public Builder validationSpecification(Consumer<ModelPackageValidationSpecification.Builder> validationSpecification) {
            return this.validationSpecification((ModelPackageValidationSpecification)((ModelPackageValidationSpecification.Builder)ModelPackageValidationSpecification.builder().applyMutation(validationSpecification)).build());
        }

        public Builder sourceAlgorithmSpecification(SourceAlgorithmSpecification var1);

        default public Builder sourceAlgorithmSpecification(Consumer<SourceAlgorithmSpecification.Builder> sourceAlgorithmSpecification) {
            return this.sourceAlgorithmSpecification((SourceAlgorithmSpecification)((SourceAlgorithmSpecification.Builder)SourceAlgorithmSpecification.builder().applyMutation(sourceAlgorithmSpecification)).build());
        }

        public Builder certifyForMarketplace(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

