/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileSystemConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileSystemConfig> {
    private static final SdkField<String> MOUNT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MountPath").getter(FileSystemConfig.getter(FileSystemConfig::mountPath)).setter(FileSystemConfig.setter(Builder::mountPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountPath").build()}).build();
    private static final SdkField<Integer> DEFAULT_UID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DefaultUid").getter(FileSystemConfig.getter(FileSystemConfig::defaultUid)).setter(FileSystemConfig.setter(Builder::defaultUid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultUid").build()}).build();
    private static final SdkField<Integer> DEFAULT_GID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DefaultGid").getter(FileSystemConfig.getter(FileSystemConfig::defaultGid)).setter(FileSystemConfig.setter(Builder::defaultGid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultGid").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MOUNT_PATH_FIELD, DEFAULT_UID_FIELD, DEFAULT_GID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String mountPath;
    private final Integer defaultUid;
    private final Integer defaultGid;

    private FileSystemConfig(BuilderImpl builder) {
        this.mountPath = builder.mountPath;
        this.defaultUid = builder.defaultUid;
        this.defaultGid = builder.defaultGid;
    }

    public final String mountPath() {
        return this.mountPath;
    }

    public final Integer defaultUid() {
        return this.defaultUid;
    }

    public final Integer defaultGid() {
        return this.defaultGid;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mountPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultUid());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultGid());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSystemConfig)) {
            return false;
        }
        FileSystemConfig other = (FileSystemConfig)obj;
        return Objects.equals(this.mountPath(), other.mountPath()) && Objects.equals(this.defaultUid(), other.defaultUid()) && Objects.equals(this.defaultGid(), other.defaultGid());
    }

    public final String toString() {
        return ToString.builder((String)"FileSystemConfig").add("MountPath", (Object)this.mountPath()).add("DefaultUid", (Object)this.defaultUid()).add("DefaultGid", (Object)this.defaultGid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MountPath": {
                return Optional.ofNullable(clazz.cast(this.mountPath()));
            }
            case "DefaultUid": {
                return Optional.ofNullable(clazz.cast(this.defaultUid()));
            }
            case "DefaultGid": {
                return Optional.ofNullable(clazz.cast(this.defaultGid()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileSystemConfig, T> g) {
        return obj -> g.apply((FileSystemConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mountPath;
        private Integer defaultUid;
        private Integer defaultGid;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSystemConfig model) {
            this.mountPath(model.mountPath);
            this.defaultUid(model.defaultUid);
            this.defaultGid(model.defaultGid);
        }

        public final String getMountPath() {
            return this.mountPath;
        }

        @Override
        public final Builder mountPath(String mountPath) {
            this.mountPath = mountPath;
            return this;
        }

        public final void setMountPath(String mountPath) {
            this.mountPath = mountPath;
        }

        public final Integer getDefaultUid() {
            return this.defaultUid;
        }

        @Override
        public final Builder defaultUid(Integer defaultUid) {
            this.defaultUid = defaultUid;
            return this;
        }

        public final void setDefaultUid(Integer defaultUid) {
            this.defaultUid = defaultUid;
        }

        public final Integer getDefaultGid() {
            return this.defaultGid;
        }

        @Override
        public final Builder defaultGid(Integer defaultGid) {
            this.defaultGid = defaultGid;
            return this;
        }

        public final void setDefaultGid(Integer defaultGid) {
            this.defaultGid = defaultGid;
        }

        public FileSystemConfig build() {
            return new FileSystemConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileSystemConfig> {
        public Builder mountPath(String var1);

        public Builder defaultUid(Integer var1);

        public Builder defaultGid(Integer var1);
    }
}

