/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.MonitoringOutput;
import software.amazon.awssdk.services.sagemaker.model.MonitoringOutputsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoringOutputConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoringOutputConfig> {
    private static final SdkField<List<MonitoringOutput>> MONITORING_OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MonitoringOutputs").getter(MonitoringOutputConfig.getter(MonitoringOutputConfig::monitoringOutputs)).setter(MonitoringOutputConfig.setter(Builder::monitoringOutputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringOutputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MonitoringOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(MonitoringOutputConfig.getter(MonitoringOutputConfig::kmsKeyId)).setter(MonitoringOutputConfig.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORING_OUTPUTS_FIELD, KMS_KEY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<MonitoringOutput> monitoringOutputs;
    private final String kmsKeyId;

    private MonitoringOutputConfig(BuilderImpl builder) {
        this.monitoringOutputs = builder.monitoringOutputs;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public boolean hasMonitoringOutputs() {
        return this.monitoringOutputs != null && !(this.monitoringOutputs instanceof SdkAutoConstructList);
    }

    public List<MonitoringOutput> monitoringOutputs() {
        return this.monitoringOutputs;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMonitoringOutputs() ? this.monitoringOutputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringOutputConfig)) {
            return false;
        }
        MonitoringOutputConfig other = (MonitoringOutputConfig)obj;
        return this.hasMonitoringOutputs() == other.hasMonitoringOutputs() && Objects.equals(this.monitoringOutputs(), other.monitoringOutputs()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public String toString() {
        return ToString.builder((String)"MonitoringOutputConfig").add("MonitoringOutputs", this.hasMonitoringOutputs() ? this.monitoringOutputs() : null).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitoringOutputs": {
                return Optional.ofNullable(clazz.cast(this.monitoringOutputs()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringOutputConfig, T> g) {
        return obj -> g.apply((MonitoringOutputConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<MonitoringOutput> monitoringOutputs = DefaultSdkAutoConstructList.getInstance();
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringOutputConfig model) {
            this.monitoringOutputs(model.monitoringOutputs);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final Collection<MonitoringOutput.Builder> getMonitoringOutputs() {
            if (this.monitoringOutputs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.monitoringOutputs != null ? (Collection)this.monitoringOutputs.stream().map(MonitoringOutput::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder monitoringOutputs(Collection<MonitoringOutput> monitoringOutputs) {
            this.monitoringOutputs = MonitoringOutputsCopier.copy(monitoringOutputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitoringOutputs(MonitoringOutput ... monitoringOutputs) {
            this.monitoringOutputs(Arrays.asList(monitoringOutputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitoringOutputs(Consumer<MonitoringOutput.Builder> ... monitoringOutputs) {
            this.monitoringOutputs(Stream.of(monitoringOutputs).map(c -> (MonitoringOutput)((MonitoringOutput.Builder)MonitoringOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMonitoringOutputs(Collection<MonitoringOutput.BuilderImpl> monitoringOutputs) {
            this.monitoringOutputs = MonitoringOutputsCopier.copyFromBuilder(monitoringOutputs);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public MonitoringOutputConfig build() {
            return new MonitoringOutputConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoringOutputConfig> {
        public Builder monitoringOutputs(Collection<MonitoringOutput> var1);

        public Builder monitoringOutputs(MonitoringOutput ... var1);

        public Builder monitoringOutputs(Consumer<MonitoringOutput.Builder> ... var1);

        public Builder kmsKeyId(String var1);
    }
}

