/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus;
import software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsSortBy;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEdgePackagingJobsRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, ListEdgePackagingJobsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEdgePackagingJobsRequest.getter(ListEdgePackagingJobsRequest::nextToken)).setter(ListEdgePackagingJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListEdgePackagingJobsRequest.getter(ListEdgePackagingJobsRequest::maxResults)).setter(ListEdgePackagingJobsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimeAfter").getter(ListEdgePackagingJobsRequest.getter(ListEdgePackagingJobsRequest::creationTimeAfter)).setter(ListEdgePackagingJobsRequest.setter(Builder::creationTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimeBefore").getter(ListEdgePackagingJobsRequest.getter(ListEdgePackagingJobsRequest::creationTimeBefore)).setter(ListEdgePackagingJobsRequest.setter(Builder::creationTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTimeAfter").getter(ListEdgePackagingJobsRequest.getter(ListEdgePackagingJobsRequest::lastModifiedTimeAfter)).setter(ListEdgePackagingJobsRequest.setter(Builder::lastModifiedTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeAfter").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTimeBefore").getter(ListEdgePackagingJobsRequest.getter(ListEdgePackagingJobsRequest::lastModifiedTimeBefore)).setter(ListEdgePackagingJobsRequest.setter(Builder::lastModifiedTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeBefore").build()}).build();
    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NameContains").getter(ListEdgePackagingJobsRequest.getter(ListEdgePackagingJobsRequest::nameContains)).setter(ListEdgePackagingJobsRequest.setter(Builder::nameContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()}).build();
    private static final SdkField<String> MODEL_NAME_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelNameContains").getter(ListEdgePackagingJobsRequest.getter(ListEdgePackagingJobsRequest::modelNameContains)).setter(ListEdgePackagingJobsRequest.setter(Builder::modelNameContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelNameContains").build()}).build();
    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusEquals").getter(ListEdgePackagingJobsRequest.getter(ListEdgePackagingJobsRequest::statusEqualsAsString)).setter(ListEdgePackagingJobsRequest.setter(Builder::statusEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusEquals").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortBy").getter(ListEdgePackagingJobsRequest.getter(ListEdgePackagingJobsRequest::sortByAsString)).setter(ListEdgePackagingJobsRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(ListEdgePackagingJobsRequest.getter(ListEdgePackagingJobsRequest::sortOrderAsString)).setter(ListEdgePackagingJobsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, CREATION_TIME_AFTER_FIELD, CREATION_TIME_BEFORE_FIELD, LAST_MODIFIED_TIME_AFTER_FIELD, LAST_MODIFIED_TIME_BEFORE_FIELD, NAME_CONTAINS_FIELD, MODEL_NAME_CONTAINS_FIELD, STATUS_EQUALS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));
    private final String nextToken;
    private final Integer maxResults;
    private final Instant creationTimeAfter;
    private final Instant creationTimeBefore;
    private final Instant lastModifiedTimeAfter;
    private final Instant lastModifiedTimeBefore;
    private final String nameContains;
    private final String modelNameContains;
    private final String statusEquals;
    private final String sortBy;
    private final String sortOrder;

    private ListEdgePackagingJobsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.lastModifiedTimeAfter = builder.lastModifiedTimeAfter;
        this.lastModifiedTimeBefore = builder.lastModifiedTimeBefore;
        this.nameContains = builder.nameContains;
        this.modelNameContains = builder.modelNameContains;
        this.statusEquals = builder.statusEquals;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Instant creationTimeAfter() {
        return this.creationTimeAfter;
    }

    public Instant creationTimeBefore() {
        return this.creationTimeBefore;
    }

    public Instant lastModifiedTimeAfter() {
        return this.lastModifiedTimeAfter;
    }

    public Instant lastModifiedTimeBefore() {
        return this.lastModifiedTimeBefore;
    }

    public String nameContains() {
        return this.nameContains;
    }

    public String modelNameContains() {
        return this.modelNameContains;
    }

    public EdgePackagingJobStatus statusEquals() {
        return EdgePackagingJobStatus.fromValue(this.statusEquals);
    }

    public String statusEqualsAsString() {
        return this.statusEquals;
    }

    public ListEdgePackagingJobsSortBy sortBy() {
        return ListEdgePackagingJobsSortBy.fromValue(this.sortBy);
    }

    public String sortByAsString() {
        return this.sortBy;
    }

    public SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public String sortOrderAsString() {
        return this.sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelNameContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEdgePackagingJobsRequest)) {
            return false;
        }
        ListEdgePackagingJobsRequest other = (ListEdgePackagingJobsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.creationTimeAfter(), other.creationTimeAfter()) && Objects.equals(this.creationTimeBefore(), other.creationTimeBefore()) && Objects.equals(this.lastModifiedTimeAfter(), other.lastModifiedTimeAfter()) && Objects.equals(this.lastModifiedTimeBefore(), other.lastModifiedTimeBefore()) && Objects.equals(this.nameContains(), other.nameContains()) && Objects.equals(this.modelNameContains(), other.modelNameContains()) && Objects.equals(this.statusEqualsAsString(), other.statusEqualsAsString()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString());
    }

    public String toString() {
        return ToString.builder((String)"ListEdgePackagingJobsRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("CreationTimeAfter", (Object)this.creationTimeAfter()).add("CreationTimeBefore", (Object)this.creationTimeBefore()).add("LastModifiedTimeAfter", (Object)this.lastModifiedTimeAfter()).add("LastModifiedTimeBefore", (Object)this.lastModifiedTimeBefore()).add("NameContains", (Object)this.nameContains()).add("ModelNameContains", (Object)this.modelNameContains()).add("StatusEquals", (Object)this.statusEqualsAsString()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "CreationTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.creationTimeAfter()));
            }
            case "CreationTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.creationTimeBefore()));
            }
            case "LastModifiedTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimeAfter()));
            }
            case "LastModifiedTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimeBefore()));
            }
            case "NameContains": {
                return Optional.ofNullable(clazz.cast(this.nameContains()));
            }
            case "ModelNameContains": {
                return Optional.ofNullable(clazz.cast(this.modelNameContains()));
            }
            case "StatusEquals": {
                return Optional.ofNullable(clazz.cast(this.statusEqualsAsString()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEdgePackagingJobsRequest, T> g) {
        return obj -> g.apply((ListEdgePackagingJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private Instant creationTimeAfter;
        private Instant creationTimeBefore;
        private Instant lastModifiedTimeAfter;
        private Instant lastModifiedTimeBefore;
        private String nameContains;
        private String modelNameContains;
        private String statusEquals;
        private String sortBy;
        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEdgePackagingJobsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.creationTimeAfter(model.creationTimeAfter);
            this.creationTimeBefore(model.creationTimeBefore);
            this.lastModifiedTimeAfter(model.lastModifiedTimeAfter);
            this.lastModifiedTimeBefore(model.lastModifiedTimeBefore);
            this.nameContains(model.nameContains);
            this.modelNameContains(model.modelNameContains);
            this.statusEquals(model.statusEquals);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Instant getCreationTimeAfter() {
            return this.creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        public final Instant getCreationTimeBefore() {
            return this.creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        public final Instant getLastModifiedTimeAfter() {
            return this.lastModifiedTimeAfter;
        }

        @Override
        public final Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
            return this;
        }

        public final void setLastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
        }

        public final Instant getLastModifiedTimeBefore() {
            return this.lastModifiedTimeBefore;
        }

        @Override
        public final Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
            return this;
        }

        public final void setLastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
        }

        public final String getNameContains() {
            return this.nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        public final String getModelNameContains() {
            return this.modelNameContains;
        }

        @Override
        public final Builder modelNameContains(String modelNameContains) {
            this.modelNameContains = modelNameContains;
            return this;
        }

        public final void setModelNameContains(String modelNameContains) {
            this.modelNameContains = modelNameContains;
        }

        public final String getStatusEquals() {
            return this.statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(EdgePackagingJobStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ListEdgePackagingJobsSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEdgePackagingJobsRequest build() {
            return new ListEdgePackagingJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEdgePackagingJobsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder creationTimeAfter(Instant var1);

        public Builder creationTimeBefore(Instant var1);

        public Builder lastModifiedTimeAfter(Instant var1);

        public Builder lastModifiedTimeBefore(Instant var1);

        public Builder nameContains(String var1);

        public Builder modelNameContains(String var1);

        public Builder statusEquals(String var1);

        public Builder statusEquals(EdgePackagingJobStatus var1);

        public Builder sortBy(String var1);

        public Builder sortBy(ListEdgePackagingJobsSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

