/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePipelineRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdatePipelineRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineName").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::pipelineName)).setter(UpdatePipelineRequest.setter(Builder::pipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineName").build()}).build();
    private static final SdkField<String> PIPELINE_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineDisplayName").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::pipelineDisplayName)).setter(UpdatePipelineRequest.setter(Builder::pipelineDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDisplayName").build()}).build();
    private static final SdkField<String> PIPELINE_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineDefinition").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::pipelineDefinition)).setter(UpdatePipelineRequest.setter(Builder::pipelineDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDefinition").build()}).build();
    private static final SdkField<String> PIPELINE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineDescription").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::pipelineDescription)).setter(UpdatePipelineRequest.setter(Builder::pipelineDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDescription").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::roleArn)).setter(UpdatePipelineRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD, PIPELINE_DISPLAY_NAME_FIELD, PIPELINE_DEFINITION_FIELD, PIPELINE_DESCRIPTION_FIELD, ROLE_ARN_FIELD));
    private final String pipelineName;
    private final String pipelineDisplayName;
    private final String pipelineDefinition;
    private final String pipelineDescription;
    private final String roleArn;

    private UpdatePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.pipelineDisplayName = builder.pipelineDisplayName;
        this.pipelineDefinition = builder.pipelineDefinition;
        this.pipelineDescription = builder.pipelineDescription;
        this.roleArn = builder.roleArn;
    }

    public String pipelineName() {
        return this.pipelineName;
    }

    public String pipelineDisplayName() {
        return this.pipelineDisplayName;
    }

    public String pipelineDefinition() {
        return this.pipelineDefinition;
    }

    public String pipelineDescription() {
        return this.pipelineDescription;
    }

    public String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipelineRequest)) {
            return false;
        }
        UpdatePipelineRequest other = (UpdatePipelineRequest)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.pipelineDisplayName(), other.pipelineDisplayName()) && Objects.equals(this.pipelineDefinition(), other.pipelineDefinition()) && Objects.equals(this.pipelineDescription(), other.pipelineDescription()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"UpdatePipelineRequest").add("PipelineName", (Object)this.pipelineName()).add("PipelineDisplayName", (Object)this.pipelineDisplayName()).add("PipelineDefinition", (Object)this.pipelineDefinition()).add("PipelineDescription", (Object)this.pipelineDescription()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "PipelineDisplayName": {
                return Optional.ofNullable(clazz.cast(this.pipelineDisplayName()));
            }
            case "PipelineDefinition": {
                return Optional.ofNullable(clazz.cast(this.pipelineDefinition()));
            }
            case "PipelineDescription": {
                return Optional.ofNullable(clazz.cast(this.pipelineDescription()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipelineRequest, T> g) {
        return obj -> g.apply((UpdatePipelineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String pipelineName;
        private String pipelineDisplayName;
        private String pipelineDefinition;
        private String pipelineDescription;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipelineRequest model) {
            super(model);
            this.pipelineName(model.pipelineName);
            this.pipelineDisplayName(model.pipelineDisplayName);
            this.pipelineDefinition(model.pipelineDefinition);
            this.pipelineDescription(model.pipelineDescription);
            this.roleArn(model.roleArn);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final String getPipelineDisplayName() {
            return this.pipelineDisplayName;
        }

        @Override
        public final Builder pipelineDisplayName(String pipelineDisplayName) {
            this.pipelineDisplayName = pipelineDisplayName;
            return this;
        }

        public final void setPipelineDisplayName(String pipelineDisplayName) {
            this.pipelineDisplayName = pipelineDisplayName;
        }

        public final String getPipelineDefinition() {
            return this.pipelineDefinition;
        }

        @Override
        public final Builder pipelineDefinition(String pipelineDefinition) {
            this.pipelineDefinition = pipelineDefinition;
            return this;
        }

        public final void setPipelineDefinition(String pipelineDefinition) {
            this.pipelineDefinition = pipelineDefinition;
        }

        public final String getPipelineDescription() {
            return this.pipelineDescription;
        }

        @Override
        public final Builder pipelineDescription(String pipelineDescription) {
            this.pipelineDescription = pipelineDescription;
            return this;
        }

        public final void setPipelineDescription(String pipelineDescription) {
            this.pipelineDescription = pipelineDescription;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePipelineRequest build() {
            return new UpdatePipelineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePipelineRequest> {
        public Builder pipelineName(String var1);

        public Builder pipelineDisplayName(String var1);

        public Builder pipelineDefinition(String var1);

        public Builder pipelineDescription(String var1);

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

