/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ModelBiasAppSpecification;
import software.amazon.awssdk.services.sagemaker.model.ModelBiasBaselineConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelBiasJobInput;
import software.amazon.awssdk.services.sagemaker.model.MonitoringNetworkConfig;
import software.amazon.awssdk.services.sagemaker.model.MonitoringOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.MonitoringResources;
import software.amazon.awssdk.services.sagemaker.model.MonitoringStoppingCondition;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateModelBiasJobDefinitionRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateModelBiasJobDefinitionRequest> {
    private static final SdkField<String> JOB_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobDefinitionName").getter(CreateModelBiasJobDefinitionRequest.getter(CreateModelBiasJobDefinitionRequest::jobDefinitionName)).setter(CreateModelBiasJobDefinitionRequest.setter(Builder::jobDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinitionName").build()}).build();
    private static final SdkField<ModelBiasBaselineConfig> MODEL_BIAS_BASELINE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelBiasBaselineConfig").getter(CreateModelBiasJobDefinitionRequest.getter(CreateModelBiasJobDefinitionRequest::modelBiasBaselineConfig)).setter(CreateModelBiasJobDefinitionRequest.setter(Builder::modelBiasBaselineConfig)).constructor(ModelBiasBaselineConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelBiasBaselineConfig").build()}).build();
    private static final SdkField<ModelBiasAppSpecification> MODEL_BIAS_APP_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelBiasAppSpecification").getter(CreateModelBiasJobDefinitionRequest.getter(CreateModelBiasJobDefinitionRequest::modelBiasAppSpecification)).setter(CreateModelBiasJobDefinitionRequest.setter(Builder::modelBiasAppSpecification)).constructor(ModelBiasAppSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelBiasAppSpecification").build()}).build();
    private static final SdkField<ModelBiasJobInput> MODEL_BIAS_JOB_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelBiasJobInput").getter(CreateModelBiasJobDefinitionRequest.getter(CreateModelBiasJobDefinitionRequest::modelBiasJobInput)).setter(CreateModelBiasJobDefinitionRequest.setter(Builder::modelBiasJobInput)).constructor(ModelBiasJobInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelBiasJobInput").build()}).build();
    private static final SdkField<MonitoringOutputConfig> MODEL_BIAS_JOB_OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelBiasJobOutputConfig").getter(CreateModelBiasJobDefinitionRequest.getter(CreateModelBiasJobDefinitionRequest::modelBiasJobOutputConfig)).setter(CreateModelBiasJobDefinitionRequest.setter(Builder::modelBiasJobOutputConfig)).constructor(MonitoringOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelBiasJobOutputConfig").build()}).build();
    private static final SdkField<MonitoringResources> JOB_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobResources").getter(CreateModelBiasJobDefinitionRequest.getter(CreateModelBiasJobDefinitionRequest::jobResources)).setter(CreateModelBiasJobDefinitionRequest.setter(Builder::jobResources)).constructor(MonitoringResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobResources").build()}).build();
    private static final SdkField<MonitoringNetworkConfig> NETWORK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkConfig").getter(CreateModelBiasJobDefinitionRequest.getter(CreateModelBiasJobDefinitionRequest::networkConfig)).setter(CreateModelBiasJobDefinitionRequest.setter(Builder::networkConfig)).constructor(MonitoringNetworkConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateModelBiasJobDefinitionRequest.getter(CreateModelBiasJobDefinitionRequest::roleArn)).setter(CreateModelBiasJobDefinitionRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<MonitoringStoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StoppingCondition").getter(CreateModelBiasJobDefinitionRequest.getter(CreateModelBiasJobDefinitionRequest::stoppingCondition)).setter(CreateModelBiasJobDefinitionRequest.setter(Builder::stoppingCondition)).constructor(MonitoringStoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateModelBiasJobDefinitionRequest.getter(CreateModelBiasJobDefinitionRequest::tags)).setter(CreateModelBiasJobDefinitionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_NAME_FIELD, MODEL_BIAS_BASELINE_CONFIG_FIELD, MODEL_BIAS_APP_SPECIFICATION_FIELD, MODEL_BIAS_JOB_INPUT_FIELD, MODEL_BIAS_JOB_OUTPUT_CONFIG_FIELD, JOB_RESOURCES_FIELD, NETWORK_CONFIG_FIELD, ROLE_ARN_FIELD, STOPPING_CONDITION_FIELD, TAGS_FIELD));
    private final String jobDefinitionName;
    private final ModelBiasBaselineConfig modelBiasBaselineConfig;
    private final ModelBiasAppSpecification modelBiasAppSpecification;
    private final ModelBiasJobInput modelBiasJobInput;
    private final MonitoringOutputConfig modelBiasJobOutputConfig;
    private final MonitoringResources jobResources;
    private final MonitoringNetworkConfig networkConfig;
    private final String roleArn;
    private final MonitoringStoppingCondition stoppingCondition;
    private final List<Tag> tags;

    private CreateModelBiasJobDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.jobDefinitionName = builder.jobDefinitionName;
        this.modelBiasBaselineConfig = builder.modelBiasBaselineConfig;
        this.modelBiasAppSpecification = builder.modelBiasAppSpecification;
        this.modelBiasJobInput = builder.modelBiasJobInput;
        this.modelBiasJobOutputConfig = builder.modelBiasJobOutputConfig;
        this.jobResources = builder.jobResources;
        this.networkConfig = builder.networkConfig;
        this.roleArn = builder.roleArn;
        this.stoppingCondition = builder.stoppingCondition;
        this.tags = builder.tags;
    }

    public String jobDefinitionName() {
        return this.jobDefinitionName;
    }

    public ModelBiasBaselineConfig modelBiasBaselineConfig() {
        return this.modelBiasBaselineConfig;
    }

    public ModelBiasAppSpecification modelBiasAppSpecification() {
        return this.modelBiasAppSpecification;
    }

    public ModelBiasJobInput modelBiasJobInput() {
        return this.modelBiasJobInput;
    }

    public MonitoringOutputConfig modelBiasJobOutputConfig() {
        return this.modelBiasJobOutputConfig;
    }

    public MonitoringResources jobResources() {
        return this.jobResources;
    }

    public MonitoringNetworkConfig networkConfig() {
        return this.networkConfig;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public MonitoringStoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelBiasBaselineConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelBiasAppSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelBiasJobInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelBiasJobOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelBiasJobDefinitionRequest)) {
            return false;
        }
        CreateModelBiasJobDefinitionRequest other = (CreateModelBiasJobDefinitionRequest)((Object)obj);
        return Objects.equals(this.jobDefinitionName(), other.jobDefinitionName()) && Objects.equals(this.modelBiasBaselineConfig(), other.modelBiasBaselineConfig()) && Objects.equals(this.modelBiasAppSpecification(), other.modelBiasAppSpecification()) && Objects.equals(this.modelBiasJobInput(), other.modelBiasJobInput()) && Objects.equals(this.modelBiasJobOutputConfig(), other.modelBiasJobOutputConfig()) && Objects.equals(this.jobResources(), other.jobResources()) && Objects.equals(this.networkConfig(), other.networkConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateModelBiasJobDefinitionRequest").add("JobDefinitionName", (Object)this.jobDefinitionName()).add("ModelBiasBaselineConfig", (Object)this.modelBiasBaselineConfig()).add("ModelBiasAppSpecification", (Object)this.modelBiasAppSpecification()).add("ModelBiasJobInput", (Object)this.modelBiasJobInput()).add("ModelBiasJobOutputConfig", (Object)this.modelBiasJobOutputConfig()).add("JobResources", (Object)this.jobResources()).add("NetworkConfig", (Object)this.networkConfig()).add("RoleArn", (Object)this.roleArn()).add("StoppingCondition", (Object)this.stoppingCondition()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.jobDefinitionName()));
            }
            case "ModelBiasBaselineConfig": {
                return Optional.ofNullable(clazz.cast(this.modelBiasBaselineConfig()));
            }
            case "ModelBiasAppSpecification": {
                return Optional.ofNullable(clazz.cast(this.modelBiasAppSpecification()));
            }
            case "ModelBiasJobInput": {
                return Optional.ofNullable(clazz.cast(this.modelBiasJobInput()));
            }
            case "ModelBiasJobOutputConfig": {
                return Optional.ofNullable(clazz.cast(this.modelBiasJobOutputConfig()));
            }
            case "JobResources": {
                return Optional.ofNullable(clazz.cast(this.jobResources()));
            }
            case "NetworkConfig": {
                return Optional.ofNullable(clazz.cast(this.networkConfig()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelBiasJobDefinitionRequest, T> g) {
        return obj -> g.apply((CreateModelBiasJobDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String jobDefinitionName;
        private ModelBiasBaselineConfig modelBiasBaselineConfig;
        private ModelBiasAppSpecification modelBiasAppSpecification;
        private ModelBiasJobInput modelBiasJobInput;
        private MonitoringOutputConfig modelBiasJobOutputConfig;
        private MonitoringResources jobResources;
        private MonitoringNetworkConfig networkConfig;
        private String roleArn;
        private MonitoringStoppingCondition stoppingCondition;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelBiasJobDefinitionRequest model) {
            super(model);
            this.jobDefinitionName(model.jobDefinitionName);
            this.modelBiasBaselineConfig(model.modelBiasBaselineConfig);
            this.modelBiasAppSpecification(model.modelBiasAppSpecification);
            this.modelBiasJobInput(model.modelBiasJobInput);
            this.modelBiasJobOutputConfig(model.modelBiasJobOutputConfig);
            this.jobResources(model.jobResources);
            this.networkConfig(model.networkConfig);
            this.roleArn(model.roleArn);
            this.stoppingCondition(model.stoppingCondition);
            this.tags(model.tags);
        }

        public final String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        public final ModelBiasBaselineConfig.Builder getModelBiasBaselineConfig() {
            return this.modelBiasBaselineConfig != null ? this.modelBiasBaselineConfig.toBuilder() : null;
        }

        @Override
        public final Builder modelBiasBaselineConfig(ModelBiasBaselineConfig modelBiasBaselineConfig) {
            this.modelBiasBaselineConfig = modelBiasBaselineConfig;
            return this;
        }

        public final void setModelBiasBaselineConfig(ModelBiasBaselineConfig.BuilderImpl modelBiasBaselineConfig) {
            this.modelBiasBaselineConfig = modelBiasBaselineConfig != null ? modelBiasBaselineConfig.build() : null;
        }

        public final ModelBiasAppSpecification.Builder getModelBiasAppSpecification() {
            return this.modelBiasAppSpecification != null ? this.modelBiasAppSpecification.toBuilder() : null;
        }

        @Override
        public final Builder modelBiasAppSpecification(ModelBiasAppSpecification modelBiasAppSpecification) {
            this.modelBiasAppSpecification = modelBiasAppSpecification;
            return this;
        }

        public final void setModelBiasAppSpecification(ModelBiasAppSpecification.BuilderImpl modelBiasAppSpecification) {
            this.modelBiasAppSpecification = modelBiasAppSpecification != null ? modelBiasAppSpecification.build() : null;
        }

        public final ModelBiasJobInput.Builder getModelBiasJobInput() {
            return this.modelBiasJobInput != null ? this.modelBiasJobInput.toBuilder() : null;
        }

        @Override
        public final Builder modelBiasJobInput(ModelBiasJobInput modelBiasJobInput) {
            this.modelBiasJobInput = modelBiasJobInput;
            return this;
        }

        public final void setModelBiasJobInput(ModelBiasJobInput.BuilderImpl modelBiasJobInput) {
            this.modelBiasJobInput = modelBiasJobInput != null ? modelBiasJobInput.build() : null;
        }

        public final MonitoringOutputConfig.Builder getModelBiasJobOutputConfig() {
            return this.modelBiasJobOutputConfig != null ? this.modelBiasJobOutputConfig.toBuilder() : null;
        }

        @Override
        public final Builder modelBiasJobOutputConfig(MonitoringOutputConfig modelBiasJobOutputConfig) {
            this.modelBiasJobOutputConfig = modelBiasJobOutputConfig;
            return this;
        }

        public final void setModelBiasJobOutputConfig(MonitoringOutputConfig.BuilderImpl modelBiasJobOutputConfig) {
            this.modelBiasJobOutputConfig = modelBiasJobOutputConfig != null ? modelBiasJobOutputConfig.build() : null;
        }

        public final MonitoringResources.Builder getJobResources() {
            return this.jobResources != null ? this.jobResources.toBuilder() : null;
        }

        @Override
        public final Builder jobResources(MonitoringResources jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        public final void setJobResources(MonitoringResources.BuilderImpl jobResources) {
            this.jobResources = jobResources != null ? jobResources.build() : null;
        }

        public final MonitoringNetworkConfig.Builder getNetworkConfig() {
            return this.networkConfig != null ? this.networkConfig.toBuilder() : null;
        }

        @Override
        public final Builder networkConfig(MonitoringNetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        public final void setNetworkConfig(MonitoringNetworkConfig.BuilderImpl networkConfig) {
            this.networkConfig = networkConfig != null ? networkConfig.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final MonitoringStoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        @Override
        public final Builder stoppingCondition(MonitoringStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final void setStoppingCondition(MonitoringStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelBiasJobDefinitionRequest build() {
            return new CreateModelBiasJobDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateModelBiasJobDefinitionRequest> {
        public Builder jobDefinitionName(String var1);

        public Builder modelBiasBaselineConfig(ModelBiasBaselineConfig var1);

        default public Builder modelBiasBaselineConfig(Consumer<ModelBiasBaselineConfig.Builder> modelBiasBaselineConfig) {
            return this.modelBiasBaselineConfig((ModelBiasBaselineConfig)((ModelBiasBaselineConfig.Builder)ModelBiasBaselineConfig.builder().applyMutation(modelBiasBaselineConfig)).build());
        }

        public Builder modelBiasAppSpecification(ModelBiasAppSpecification var1);

        default public Builder modelBiasAppSpecification(Consumer<ModelBiasAppSpecification.Builder> modelBiasAppSpecification) {
            return this.modelBiasAppSpecification((ModelBiasAppSpecification)((ModelBiasAppSpecification.Builder)ModelBiasAppSpecification.builder().applyMutation(modelBiasAppSpecification)).build());
        }

        public Builder modelBiasJobInput(ModelBiasJobInput var1);

        default public Builder modelBiasJobInput(Consumer<ModelBiasJobInput.Builder> modelBiasJobInput) {
            return this.modelBiasJobInput((ModelBiasJobInput)((ModelBiasJobInput.Builder)ModelBiasJobInput.builder().applyMutation(modelBiasJobInput)).build());
        }

        public Builder modelBiasJobOutputConfig(MonitoringOutputConfig var1);

        default public Builder modelBiasJobOutputConfig(Consumer<MonitoringOutputConfig.Builder> modelBiasJobOutputConfig) {
            return this.modelBiasJobOutputConfig((MonitoringOutputConfig)((MonitoringOutputConfig.Builder)MonitoringOutputConfig.builder().applyMutation(modelBiasJobOutputConfig)).build());
        }

        public Builder jobResources(MonitoringResources var1);

        default public Builder jobResources(Consumer<MonitoringResources.Builder> jobResources) {
            return this.jobResources((MonitoringResources)((MonitoringResources.Builder)MonitoringResources.builder().applyMutation(jobResources)).build());
        }

        public Builder networkConfig(MonitoringNetworkConfig var1);

        default public Builder networkConfig(Consumer<MonitoringNetworkConfig.Builder> networkConfig) {
            return this.networkConfig((MonitoringNetworkConfig)((MonitoringNetworkConfig.Builder)MonitoringNetworkConfig.builder().applyMutation(networkConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder stoppingCondition(MonitoringStoppingCondition var1);

        default public Builder stoppingCondition(Consumer<MonitoringStoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((MonitoringStoppingCondition)((MonitoringStoppingCondition.Builder)MonitoringStoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

