/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.DataQualityAppSpecification;
import software.amazon.awssdk.services.sagemaker.model.DataQualityBaselineConfig;
import software.amazon.awssdk.services.sagemaker.model.DataQualityJobInput;
import software.amazon.awssdk.services.sagemaker.model.MonitoringNetworkConfig;
import software.amazon.awssdk.services.sagemaker.model.MonitoringOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.MonitoringResources;
import software.amazon.awssdk.services.sagemaker.model.MonitoringStoppingCondition;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDataQualityJobDefinitionResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeDataQualityJobDefinitionResponse> {
    private static final SdkField<String> JOB_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobDefinitionArn").getter(DescribeDataQualityJobDefinitionResponse.getter(DescribeDataQualityJobDefinitionResponse::jobDefinitionArn)).setter(DescribeDataQualityJobDefinitionResponse.setter(Builder::jobDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinitionArn").build()}).build();
    private static final SdkField<String> JOB_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobDefinitionName").getter(DescribeDataQualityJobDefinitionResponse.getter(DescribeDataQualityJobDefinitionResponse::jobDefinitionName)).setter(DescribeDataQualityJobDefinitionResponse.setter(Builder::jobDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinitionName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeDataQualityJobDefinitionResponse.getter(DescribeDataQualityJobDefinitionResponse::creationTime)).setter(DescribeDataQualityJobDefinitionResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<DataQualityBaselineConfig> DATA_QUALITY_BASELINE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataQualityBaselineConfig").getter(DescribeDataQualityJobDefinitionResponse.getter(DescribeDataQualityJobDefinitionResponse::dataQualityBaselineConfig)).setter(DescribeDataQualityJobDefinitionResponse.setter(Builder::dataQualityBaselineConfig)).constructor(DataQualityBaselineConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualityBaselineConfig").build()}).build();
    private static final SdkField<DataQualityAppSpecification> DATA_QUALITY_APP_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataQualityAppSpecification").getter(DescribeDataQualityJobDefinitionResponse.getter(DescribeDataQualityJobDefinitionResponse::dataQualityAppSpecification)).setter(DescribeDataQualityJobDefinitionResponse.setter(Builder::dataQualityAppSpecification)).constructor(DataQualityAppSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualityAppSpecification").build()}).build();
    private static final SdkField<DataQualityJobInput> DATA_QUALITY_JOB_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataQualityJobInput").getter(DescribeDataQualityJobDefinitionResponse.getter(DescribeDataQualityJobDefinitionResponse::dataQualityJobInput)).setter(DescribeDataQualityJobDefinitionResponse.setter(Builder::dataQualityJobInput)).constructor(DataQualityJobInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualityJobInput").build()}).build();
    private static final SdkField<MonitoringOutputConfig> DATA_QUALITY_JOB_OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataQualityJobOutputConfig").getter(DescribeDataQualityJobDefinitionResponse.getter(DescribeDataQualityJobDefinitionResponse::dataQualityJobOutputConfig)).setter(DescribeDataQualityJobDefinitionResponse.setter(Builder::dataQualityJobOutputConfig)).constructor(MonitoringOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualityJobOutputConfig").build()}).build();
    private static final SdkField<MonitoringResources> JOB_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobResources").getter(DescribeDataQualityJobDefinitionResponse.getter(DescribeDataQualityJobDefinitionResponse::jobResources)).setter(DescribeDataQualityJobDefinitionResponse.setter(Builder::jobResources)).constructor(MonitoringResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobResources").build()}).build();
    private static final SdkField<MonitoringNetworkConfig> NETWORK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkConfig").getter(DescribeDataQualityJobDefinitionResponse.getter(DescribeDataQualityJobDefinitionResponse::networkConfig)).setter(DescribeDataQualityJobDefinitionResponse.setter(Builder::networkConfig)).constructor(MonitoringNetworkConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeDataQualityJobDefinitionResponse.getter(DescribeDataQualityJobDefinitionResponse::roleArn)).setter(DescribeDataQualityJobDefinitionResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<MonitoringStoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StoppingCondition").getter(DescribeDataQualityJobDefinitionResponse.getter(DescribeDataQualityJobDefinitionResponse::stoppingCondition)).setter(DescribeDataQualityJobDefinitionResponse.setter(Builder::stoppingCondition)).constructor(MonitoringStoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_ARN_FIELD, JOB_DEFINITION_NAME_FIELD, CREATION_TIME_FIELD, DATA_QUALITY_BASELINE_CONFIG_FIELD, DATA_QUALITY_APP_SPECIFICATION_FIELD, DATA_QUALITY_JOB_INPUT_FIELD, DATA_QUALITY_JOB_OUTPUT_CONFIG_FIELD, JOB_RESOURCES_FIELD, NETWORK_CONFIG_FIELD, ROLE_ARN_FIELD, STOPPING_CONDITION_FIELD));
    private final String jobDefinitionArn;
    private final String jobDefinitionName;
    private final Instant creationTime;
    private final DataQualityBaselineConfig dataQualityBaselineConfig;
    private final DataQualityAppSpecification dataQualityAppSpecification;
    private final DataQualityJobInput dataQualityJobInput;
    private final MonitoringOutputConfig dataQualityJobOutputConfig;
    private final MonitoringResources jobResources;
    private final MonitoringNetworkConfig networkConfig;
    private final String roleArn;
    private final MonitoringStoppingCondition stoppingCondition;

    private DescribeDataQualityJobDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.jobDefinitionArn = builder.jobDefinitionArn;
        this.jobDefinitionName = builder.jobDefinitionName;
        this.creationTime = builder.creationTime;
        this.dataQualityBaselineConfig = builder.dataQualityBaselineConfig;
        this.dataQualityAppSpecification = builder.dataQualityAppSpecification;
        this.dataQualityJobInput = builder.dataQualityJobInput;
        this.dataQualityJobOutputConfig = builder.dataQualityJobOutputConfig;
        this.jobResources = builder.jobResources;
        this.networkConfig = builder.networkConfig;
        this.roleArn = builder.roleArn;
        this.stoppingCondition = builder.stoppingCondition;
    }

    public String jobDefinitionArn() {
        return this.jobDefinitionArn;
    }

    public String jobDefinitionName() {
        return this.jobDefinitionName;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public DataQualityBaselineConfig dataQualityBaselineConfig() {
        return this.dataQualityBaselineConfig;
    }

    public DataQualityAppSpecification dataQualityAppSpecification() {
        return this.dataQualityAppSpecification;
    }

    public DataQualityJobInput dataQualityJobInput() {
        return this.dataQualityJobInput;
    }

    public MonitoringOutputConfig dataQualityJobOutputConfig() {
        return this.dataQualityJobOutputConfig;
    }

    public MonitoringResources jobResources() {
        return this.jobResources;
    }

    public MonitoringNetworkConfig networkConfig() {
        return this.networkConfig;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public MonitoringStoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataQualityBaselineConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataQualityAppSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataQualityJobInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataQualityJobOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataQualityJobDefinitionResponse)) {
            return false;
        }
        DescribeDataQualityJobDefinitionResponse other = (DescribeDataQualityJobDefinitionResponse)((Object)obj);
        return Objects.equals(this.jobDefinitionArn(), other.jobDefinitionArn()) && Objects.equals(this.jobDefinitionName(), other.jobDefinitionName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.dataQualityBaselineConfig(), other.dataQualityBaselineConfig()) && Objects.equals(this.dataQualityAppSpecification(), other.dataQualityAppSpecification()) && Objects.equals(this.dataQualityJobInput(), other.dataQualityJobInput()) && Objects.equals(this.dataQualityJobOutputConfig(), other.dataQualityJobOutputConfig()) && Objects.equals(this.jobResources(), other.jobResources()) && Objects.equals(this.networkConfig(), other.networkConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDataQualityJobDefinitionResponse").add("JobDefinitionArn", (Object)this.jobDefinitionArn()).add("JobDefinitionName", (Object)this.jobDefinitionName()).add("CreationTime", (Object)this.creationTime()).add("DataQualityBaselineConfig", (Object)this.dataQualityBaselineConfig()).add("DataQualityAppSpecification", (Object)this.dataQualityAppSpecification()).add("DataQualityJobInput", (Object)this.dataQualityJobInput()).add("DataQualityJobOutputConfig", (Object)this.dataQualityJobOutputConfig()).add("JobResources", (Object)this.jobResources()).add("NetworkConfig", (Object)this.networkConfig()).add("RoleArn", (Object)this.roleArn()).add("StoppingCondition", (Object)this.stoppingCondition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.jobDefinitionArn()));
            }
            case "JobDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.jobDefinitionName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "DataQualityBaselineConfig": {
                return Optional.ofNullable(clazz.cast(this.dataQualityBaselineConfig()));
            }
            case "DataQualityAppSpecification": {
                return Optional.ofNullable(clazz.cast(this.dataQualityAppSpecification()));
            }
            case "DataQualityJobInput": {
                return Optional.ofNullable(clazz.cast(this.dataQualityJobInput()));
            }
            case "DataQualityJobOutputConfig": {
                return Optional.ofNullable(clazz.cast(this.dataQualityJobOutputConfig()));
            }
            case "JobResources": {
                return Optional.ofNullable(clazz.cast(this.jobResources()));
            }
            case "NetworkConfig": {
                return Optional.ofNullable(clazz.cast(this.networkConfig()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataQualityJobDefinitionResponse, T> g) {
        return obj -> g.apply((DescribeDataQualityJobDefinitionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String jobDefinitionArn;
        private String jobDefinitionName;
        private Instant creationTime;
        private DataQualityBaselineConfig dataQualityBaselineConfig;
        private DataQualityAppSpecification dataQualityAppSpecification;
        private DataQualityJobInput dataQualityJobInput;
        private MonitoringOutputConfig dataQualityJobOutputConfig;
        private MonitoringResources jobResources;
        private MonitoringNetworkConfig networkConfig;
        private String roleArn;
        private MonitoringStoppingCondition stoppingCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataQualityJobDefinitionResponse model) {
            super(model);
            this.jobDefinitionArn(model.jobDefinitionArn);
            this.jobDefinitionName(model.jobDefinitionName);
            this.creationTime(model.creationTime);
            this.dataQualityBaselineConfig(model.dataQualityBaselineConfig);
            this.dataQualityAppSpecification(model.dataQualityAppSpecification);
            this.dataQualityJobInput(model.dataQualityJobInput);
            this.dataQualityJobOutputConfig(model.dataQualityJobOutputConfig);
            this.jobResources(model.jobResources);
            this.networkConfig(model.networkConfig);
            this.roleArn(model.roleArn);
            this.stoppingCondition(model.stoppingCondition);
        }

        public final String getJobDefinitionArn() {
            return this.jobDefinitionArn;
        }

        @Override
        public final Builder jobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
            return this;
        }

        public final void setJobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
        }

        public final String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final DataQualityBaselineConfig.Builder getDataQualityBaselineConfig() {
            return this.dataQualityBaselineConfig != null ? this.dataQualityBaselineConfig.toBuilder() : null;
        }

        @Override
        public final Builder dataQualityBaselineConfig(DataQualityBaselineConfig dataQualityBaselineConfig) {
            this.dataQualityBaselineConfig = dataQualityBaselineConfig;
            return this;
        }

        public final void setDataQualityBaselineConfig(DataQualityBaselineConfig.BuilderImpl dataQualityBaselineConfig) {
            this.dataQualityBaselineConfig = dataQualityBaselineConfig != null ? dataQualityBaselineConfig.build() : null;
        }

        public final DataQualityAppSpecification.Builder getDataQualityAppSpecification() {
            return this.dataQualityAppSpecification != null ? this.dataQualityAppSpecification.toBuilder() : null;
        }

        @Override
        public final Builder dataQualityAppSpecification(DataQualityAppSpecification dataQualityAppSpecification) {
            this.dataQualityAppSpecification = dataQualityAppSpecification;
            return this;
        }

        public final void setDataQualityAppSpecification(DataQualityAppSpecification.BuilderImpl dataQualityAppSpecification) {
            this.dataQualityAppSpecification = dataQualityAppSpecification != null ? dataQualityAppSpecification.build() : null;
        }

        public final DataQualityJobInput.Builder getDataQualityJobInput() {
            return this.dataQualityJobInput != null ? this.dataQualityJobInput.toBuilder() : null;
        }

        @Override
        public final Builder dataQualityJobInput(DataQualityJobInput dataQualityJobInput) {
            this.dataQualityJobInput = dataQualityJobInput;
            return this;
        }

        public final void setDataQualityJobInput(DataQualityJobInput.BuilderImpl dataQualityJobInput) {
            this.dataQualityJobInput = dataQualityJobInput != null ? dataQualityJobInput.build() : null;
        }

        public final MonitoringOutputConfig.Builder getDataQualityJobOutputConfig() {
            return this.dataQualityJobOutputConfig != null ? this.dataQualityJobOutputConfig.toBuilder() : null;
        }

        @Override
        public final Builder dataQualityJobOutputConfig(MonitoringOutputConfig dataQualityJobOutputConfig) {
            this.dataQualityJobOutputConfig = dataQualityJobOutputConfig;
            return this;
        }

        public final void setDataQualityJobOutputConfig(MonitoringOutputConfig.BuilderImpl dataQualityJobOutputConfig) {
            this.dataQualityJobOutputConfig = dataQualityJobOutputConfig != null ? dataQualityJobOutputConfig.build() : null;
        }

        public final MonitoringResources.Builder getJobResources() {
            return this.jobResources != null ? this.jobResources.toBuilder() : null;
        }

        @Override
        public final Builder jobResources(MonitoringResources jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        public final void setJobResources(MonitoringResources.BuilderImpl jobResources) {
            this.jobResources = jobResources != null ? jobResources.build() : null;
        }

        public final MonitoringNetworkConfig.Builder getNetworkConfig() {
            return this.networkConfig != null ? this.networkConfig.toBuilder() : null;
        }

        @Override
        public final Builder networkConfig(MonitoringNetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        public final void setNetworkConfig(MonitoringNetworkConfig.BuilderImpl networkConfig) {
            this.networkConfig = networkConfig != null ? networkConfig.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final MonitoringStoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        @Override
        public final Builder stoppingCondition(MonitoringStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final void setStoppingCondition(MonitoringStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public DescribeDataQualityJobDefinitionResponse build() {
            return new DescribeDataQualityJobDefinitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDataQualityJobDefinitionResponse> {
        public Builder jobDefinitionArn(String var1);

        public Builder jobDefinitionName(String var1);

        public Builder creationTime(Instant var1);

        public Builder dataQualityBaselineConfig(DataQualityBaselineConfig var1);

        default public Builder dataQualityBaselineConfig(Consumer<DataQualityBaselineConfig.Builder> dataQualityBaselineConfig) {
            return this.dataQualityBaselineConfig((DataQualityBaselineConfig)((DataQualityBaselineConfig.Builder)DataQualityBaselineConfig.builder().applyMutation(dataQualityBaselineConfig)).build());
        }

        public Builder dataQualityAppSpecification(DataQualityAppSpecification var1);

        default public Builder dataQualityAppSpecification(Consumer<DataQualityAppSpecification.Builder> dataQualityAppSpecification) {
            return this.dataQualityAppSpecification((DataQualityAppSpecification)((DataQualityAppSpecification.Builder)DataQualityAppSpecification.builder().applyMutation(dataQualityAppSpecification)).build());
        }

        public Builder dataQualityJobInput(DataQualityJobInput var1);

        default public Builder dataQualityJobInput(Consumer<DataQualityJobInput.Builder> dataQualityJobInput) {
            return this.dataQualityJobInput((DataQualityJobInput)((DataQualityJobInput.Builder)DataQualityJobInput.builder().applyMutation(dataQualityJobInput)).build());
        }

        public Builder dataQualityJobOutputConfig(MonitoringOutputConfig var1);

        default public Builder dataQualityJobOutputConfig(Consumer<MonitoringOutputConfig.Builder> dataQualityJobOutputConfig) {
            return this.dataQualityJobOutputConfig((MonitoringOutputConfig)((MonitoringOutputConfig.Builder)MonitoringOutputConfig.builder().applyMutation(dataQualityJobOutputConfig)).build());
        }

        public Builder jobResources(MonitoringResources var1);

        default public Builder jobResources(Consumer<MonitoringResources.Builder> jobResources) {
            return this.jobResources((MonitoringResources)((MonitoringResources.Builder)MonitoringResources.builder().applyMutation(jobResources)).build());
        }

        public Builder networkConfig(MonitoringNetworkConfig var1);

        default public Builder networkConfig(Consumer<MonitoringNetworkConfig.Builder> networkConfig) {
            return this.networkConfig((MonitoringNetworkConfig)((MonitoringNetworkConfig.Builder)MonitoringNetworkConfig.builder().applyMutation(networkConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder stoppingCondition(MonitoringStoppingCondition var1);

        default public Builder stoppingCondition(Consumer<MonitoringStoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((MonitoringStoppingCondition)((MonitoringStoppingCondition.Builder)MonitoringStoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }
    }
}

