/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.ProfilingParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProfilerConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProfilerConfig> {
    private static final SdkField<String> S3_OUTPUT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3OutputPath").getter(ProfilerConfig.getter(ProfilerConfig::s3OutputPath)).setter(ProfilerConfig.setter(Builder::s3OutputPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputPath").build()}).build();
    private static final SdkField<Long> PROFILING_INTERVAL_IN_MILLISECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ProfilingIntervalInMilliseconds").getter(ProfilerConfig.getter(ProfilerConfig::profilingIntervalInMilliseconds)).setter(ProfilerConfig.setter(Builder::profilingIntervalInMilliseconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfilingIntervalInMilliseconds").build()}).build();
    private static final SdkField<Map<String, String>> PROFILING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ProfilingParameters").getter(ProfilerConfig.getter(ProfilerConfig::profilingParameters)).setter(ProfilerConfig.setter(Builder::profilingParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfilingParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OUTPUT_PATH_FIELD, PROFILING_INTERVAL_IN_MILLISECONDS_FIELD, PROFILING_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3OutputPath;
    private final Long profilingIntervalInMilliseconds;
    private final Map<String, String> profilingParameters;

    private ProfilerConfig(BuilderImpl builder) {
        this.s3OutputPath = builder.s3OutputPath;
        this.profilingIntervalInMilliseconds = builder.profilingIntervalInMilliseconds;
        this.profilingParameters = builder.profilingParameters;
    }

    public String s3OutputPath() {
        return this.s3OutputPath;
    }

    public Long profilingIntervalInMilliseconds() {
        return this.profilingIntervalInMilliseconds;
    }

    public boolean hasProfilingParameters() {
        return this.profilingParameters != null && !(this.profilingParameters instanceof SdkAutoConstructMap);
    }

    public Map<String, String> profilingParameters() {
        return this.profilingParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.profilingIntervalInMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfilingParameters() ? this.profilingParameters() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfilerConfig)) {
            return false;
        }
        ProfilerConfig other = (ProfilerConfig)obj;
        return Objects.equals(this.s3OutputPath(), other.s3OutputPath()) && Objects.equals(this.profilingIntervalInMilliseconds(), other.profilingIntervalInMilliseconds()) && this.hasProfilingParameters() == other.hasProfilingParameters() && Objects.equals(this.profilingParameters(), other.profilingParameters());
    }

    public String toString() {
        return ToString.builder((String)"ProfilerConfig").add("S3OutputPath", (Object)this.s3OutputPath()).add("ProfilingIntervalInMilliseconds", (Object)this.profilingIntervalInMilliseconds()).add("ProfilingParameters", this.hasProfilingParameters() ? this.profilingParameters() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3OutputPath": {
                return Optional.ofNullable(clazz.cast(this.s3OutputPath()));
            }
            case "ProfilingIntervalInMilliseconds": {
                return Optional.ofNullable(clazz.cast(this.profilingIntervalInMilliseconds()));
            }
            case "ProfilingParameters": {
                return Optional.ofNullable(clazz.cast(this.profilingParameters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProfilerConfig, T> g) {
        return obj -> g.apply((ProfilerConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3OutputPath;
        private Long profilingIntervalInMilliseconds;
        private Map<String, String> profilingParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProfilerConfig model) {
            this.s3OutputPath(model.s3OutputPath);
            this.profilingIntervalInMilliseconds(model.profilingIntervalInMilliseconds);
            this.profilingParameters(model.profilingParameters);
        }

        public final String getS3OutputPath() {
            return this.s3OutputPath;
        }

        @Override
        public final Builder s3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
            return this;
        }

        public final void setS3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
        }

        public final Long getProfilingIntervalInMilliseconds() {
            return this.profilingIntervalInMilliseconds;
        }

        @Override
        public final Builder profilingIntervalInMilliseconds(Long profilingIntervalInMilliseconds) {
            this.profilingIntervalInMilliseconds = profilingIntervalInMilliseconds;
            return this;
        }

        public final void setProfilingIntervalInMilliseconds(Long profilingIntervalInMilliseconds) {
            this.profilingIntervalInMilliseconds = profilingIntervalInMilliseconds;
        }

        public final Map<String, String> getProfilingParameters() {
            if (this.profilingParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.profilingParameters;
        }

        @Override
        public final Builder profilingParameters(Map<String, String> profilingParameters) {
            this.profilingParameters = ProfilingParametersCopier.copy(profilingParameters);
            return this;
        }

        public final void setProfilingParameters(Map<String, String> profilingParameters) {
            this.profilingParameters = ProfilingParametersCopier.copy(profilingParameters);
        }

        public ProfilerConfig build() {
            return new ProfilerConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProfilerConfig> {
        public Builder s3OutputPath(String var1);

        public Builder profilingIntervalInMilliseconds(Long var1);

        public Builder profilingParameters(Map<String, String> var1);
    }
}

