/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.UserContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelPackageGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelPackageGroup> {
    private static final SdkField<String> MODEL_PACKAGE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageGroupName").getter(ModelPackageGroup.getter(ModelPackageGroup::modelPackageGroupName)).setter(ModelPackageGroup.setter(Builder::modelPackageGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupName").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageGroupArn").getter(ModelPackageGroup.getter(ModelPackageGroup::modelPackageGroupArn)).setter(ModelPackageGroup.setter(Builder::modelPackageGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupArn").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_GROUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageGroupDescription").getter(ModelPackageGroup.getter(ModelPackageGroup::modelPackageGroupDescription)).setter(ModelPackageGroup.setter(Builder::modelPackageGroupDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupDescription").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ModelPackageGroup.getter(ModelPackageGroup::creationTime)).setter(ModelPackageGroup.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(ModelPackageGroup.getter(ModelPackageGroup::createdBy)).setter(ModelPackageGroup.setter(Builder::createdBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_GROUP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageGroupStatus").getter(ModelPackageGroup.getter(ModelPackageGroup::modelPackageGroupStatusAsString)).setter(ModelPackageGroup.setter(Builder::modelPackageGroupStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupStatus").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ModelPackageGroup.getter(ModelPackageGroup::tags)).setter(ModelPackageGroup.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_GROUP_NAME_FIELD, MODEL_PACKAGE_GROUP_ARN_FIELD, MODEL_PACKAGE_GROUP_DESCRIPTION_FIELD, CREATION_TIME_FIELD, CREATED_BY_FIELD, MODEL_PACKAGE_GROUP_STATUS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String modelPackageGroupName;
    private final String modelPackageGroupArn;
    private final String modelPackageGroupDescription;
    private final Instant creationTime;
    private final UserContext createdBy;
    private final String modelPackageGroupStatus;
    private final List<Tag> tags;

    private ModelPackageGroup(BuilderImpl builder) {
        this.modelPackageGroupName = builder.modelPackageGroupName;
        this.modelPackageGroupArn = builder.modelPackageGroupArn;
        this.modelPackageGroupDescription = builder.modelPackageGroupDescription;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.modelPackageGroupStatus = builder.modelPackageGroupStatus;
        this.tags = builder.tags;
    }

    public String modelPackageGroupName() {
        return this.modelPackageGroupName;
    }

    public String modelPackageGroupArn() {
        return this.modelPackageGroupArn;
    }

    public String modelPackageGroupDescription() {
        return this.modelPackageGroupDescription;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public UserContext createdBy() {
        return this.createdBy;
    }

    public ModelPackageGroupStatus modelPackageGroupStatus() {
        return ModelPackageGroupStatus.fromValue(this.modelPackageGroupStatus);
    }

    public String modelPackageGroupStatusAsString() {
        return this.modelPackageGroupStatus;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageGroupStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackageGroup)) {
            return false;
        }
        ModelPackageGroup other = (ModelPackageGroup)obj;
        return Objects.equals(this.modelPackageGroupName(), other.modelPackageGroupName()) && Objects.equals(this.modelPackageGroupArn(), other.modelPackageGroupArn()) && Objects.equals(this.modelPackageGroupDescription(), other.modelPackageGroupDescription()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.modelPackageGroupStatusAsString(), other.modelPackageGroupStatusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"ModelPackageGroup").add("ModelPackageGroupName", (Object)this.modelPackageGroupName()).add("ModelPackageGroupArn", (Object)this.modelPackageGroupArn()).add("ModelPackageGroupDescription", (Object)this.modelPackageGroupDescription()).add("CreationTime", (Object)this.creationTime()).add("CreatedBy", (Object)this.createdBy()).add("ModelPackageGroupStatus", (Object)this.modelPackageGroupStatusAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelPackageGroupName": {
                return Optional.ofNullable(clazz.cast(this.modelPackageGroupName()));
            }
            case "ModelPackageGroupArn": {
                return Optional.ofNullable(clazz.cast(this.modelPackageGroupArn()));
            }
            case "ModelPackageGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.modelPackageGroupDescription()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "ModelPackageGroupStatus": {
                return Optional.ofNullable(clazz.cast(this.modelPackageGroupStatusAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelPackageGroup, T> g) {
        return obj -> g.apply((ModelPackageGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelPackageGroupName;
        private String modelPackageGroupArn;
        private String modelPackageGroupDescription;
        private Instant creationTime;
        private UserContext createdBy;
        private String modelPackageGroupStatus;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackageGroup model) {
            this.modelPackageGroupName(model.modelPackageGroupName);
            this.modelPackageGroupArn(model.modelPackageGroupArn);
            this.modelPackageGroupDescription(model.modelPackageGroupDescription);
            this.creationTime(model.creationTime);
            this.createdBy(model.createdBy);
            this.modelPackageGroupStatus(model.modelPackageGroupStatus);
            this.tags(model.tags);
        }

        public final String getModelPackageGroupName() {
            return this.modelPackageGroupName;
        }

        @Override
        public final Builder modelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
            return this;
        }

        public final void setModelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
        }

        public final String getModelPackageGroupArn() {
            return this.modelPackageGroupArn;
        }

        @Override
        public final Builder modelPackageGroupArn(String modelPackageGroupArn) {
            this.modelPackageGroupArn = modelPackageGroupArn;
            return this;
        }

        public final void setModelPackageGroupArn(String modelPackageGroupArn) {
            this.modelPackageGroupArn = modelPackageGroupArn;
        }

        public final String getModelPackageGroupDescription() {
            return this.modelPackageGroupDescription;
        }

        @Override
        public final Builder modelPackageGroupDescription(String modelPackageGroupDescription) {
            this.modelPackageGroupDescription = modelPackageGroupDescription;
            return this;
        }

        public final void setModelPackageGroupDescription(String modelPackageGroupDescription) {
            this.modelPackageGroupDescription = modelPackageGroupDescription;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final UserContext.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        public final String getModelPackageGroupStatus() {
            return this.modelPackageGroupStatus;
        }

        @Override
        public final Builder modelPackageGroupStatus(String modelPackageGroupStatus) {
            this.modelPackageGroupStatus = modelPackageGroupStatus;
            return this;
        }

        @Override
        public final Builder modelPackageGroupStatus(ModelPackageGroupStatus modelPackageGroupStatus) {
            this.modelPackageGroupStatus(modelPackageGroupStatus == null ? null : modelPackageGroupStatus.toString());
            return this;
        }

        public final void setModelPackageGroupStatus(String modelPackageGroupStatus) {
            this.modelPackageGroupStatus = modelPackageGroupStatus;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public ModelPackageGroup build() {
            return new ModelPackageGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelPackageGroup> {
        public Builder modelPackageGroupName(String var1);

        public Builder modelPackageGroupArn(String var1);

        public Builder modelPackageGroupDescription(String var1);

        public Builder creationTime(Instant var1);

        public Builder createdBy(UserContext var1);

        default public Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return this.createdBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(createdBy)).build());
        }

        public Builder modelPackageGroupStatus(String var1);

        public Builder modelPackageGroupStatus(ModelPackageGroupStatus var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

