/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.CidrsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceIpConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceIpConfig> {
    private static final SdkField<List<String>> CIDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Cidrs").getter(SourceIpConfig.getter(SourceIpConfig::cidrs)).setter(SourceIpConfig.setter(Builder::cidrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidrs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDRS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> cidrs;

    private SourceIpConfig(BuilderImpl builder) {
        this.cidrs = builder.cidrs;
    }

    public boolean hasCidrs() {
        return this.cidrs != null && !(this.cidrs instanceof SdkAutoConstructList);
    }

    public List<String> cidrs() {
        return this.cidrs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceIpConfig)) {
            return false;
        }
        SourceIpConfig other = (SourceIpConfig)obj;
        return Objects.equals(this.cidrs(), other.cidrs());
    }

    public String toString() {
        return ToString.builder((String)"SourceIpConfig").add("Cidrs", this.cidrs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Cidrs": {
                return Optional.ofNullable(clazz.cast(this.cidrs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceIpConfig, T> g) {
        return obj -> g.apply((SourceIpConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> cidrs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SourceIpConfig model) {
            this.cidrs(model.cidrs);
        }

        public final Collection<String> getCidrs() {
            return this.cidrs;
        }

        @Override
        public final Builder cidrs(Collection<String> cidrs) {
            this.cidrs = CidrsCopier.copy(cidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrs(String ... cidrs) {
            this.cidrs(Arrays.asList(cidrs));
            return this;
        }

        public final void setCidrs(Collection<String> cidrs) {
            this.cidrs = CidrsCopier.copy(cidrs);
        }

        public SourceIpConfig build() {
            return new SourceIpConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceIpConfig> {
        public Builder cidrs(Collection<String> var1);

        public Builder cidrs(String ... var1);
    }
}

