/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.TransformJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransformJobSummary> {
    private static final SdkField<String> TRANSFORM_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransformJobName").getter(TransformJobSummary.getter(TransformJobSummary::transformJobName)).setter(TransformJobSummary.setter(Builder::transformJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJobName").build()}).build();
    private static final SdkField<String> TRANSFORM_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransformJobArn").getter(TransformJobSummary.getter(TransformJobSummary::transformJobArn)).setter(TransformJobSummary.setter(Builder::transformJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJobArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(TransformJobSummary.getter(TransformJobSummary::creationTime)).setter(TransformJobSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> TRANSFORM_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TransformEndTime").getter(TransformJobSummary.getter(TransformJobSummary::transformEndTime)).setter(TransformJobSummary.setter(Builder::transformEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformEndTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(TransformJobSummary.getter(TransformJobSummary::lastModifiedTime)).setter(TransformJobSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> TRANSFORM_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransformJobStatus").getter(TransformJobSummary.getter(TransformJobSummary::transformJobStatusAsString)).setter(TransformJobSummary.setter(Builder::transformJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJobStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(TransformJobSummary.getter(TransformJobSummary::failureReason)).setter(TransformJobSummary.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_JOB_NAME_FIELD, TRANSFORM_JOB_ARN_FIELD, CREATION_TIME_FIELD, TRANSFORM_END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, TRANSFORM_JOB_STATUS_FIELD, FAILURE_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transformJobName;
    private final String transformJobArn;
    private final Instant creationTime;
    private final Instant transformEndTime;
    private final Instant lastModifiedTime;
    private final String transformJobStatus;
    private final String failureReason;

    private TransformJobSummary(BuilderImpl builder) {
        this.transformJobName = builder.transformJobName;
        this.transformJobArn = builder.transformJobArn;
        this.creationTime = builder.creationTime;
        this.transformEndTime = builder.transformEndTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.transformJobStatus = builder.transformJobStatus;
        this.failureReason = builder.failureReason;
    }

    public String transformJobName() {
        return this.transformJobName;
    }

    public String transformJobArn() {
        return this.transformJobArn;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant transformEndTime() {
        return this.transformEndTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public TransformJobStatus transformJobStatus() {
        return TransformJobStatus.fromValue(this.transformJobStatus);
    }

    public String transformJobStatusAsString() {
        return this.transformJobStatus;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transformJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformJobSummary)) {
            return false;
        }
        TransformJobSummary other = (TransformJobSummary)obj;
        return Objects.equals(this.transformJobName(), other.transformJobName()) && Objects.equals(this.transformJobArn(), other.transformJobArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.transformEndTime(), other.transformEndTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.transformJobStatusAsString(), other.transformJobStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public String toString() {
        return ToString.builder((String)"TransformJobSummary").add("TransformJobName", (Object)this.transformJobName()).add("TransformJobArn", (Object)this.transformJobArn()).add("CreationTime", (Object)this.creationTime()).add("TransformEndTime", (Object)this.transformEndTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("TransformJobStatus", (Object)this.transformJobStatusAsString()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransformJobName": {
                return Optional.ofNullable(clazz.cast(this.transformJobName()));
            }
            case "TransformJobArn": {
                return Optional.ofNullable(clazz.cast(this.transformJobArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "TransformEndTime": {
                return Optional.ofNullable(clazz.cast(this.transformEndTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "TransformJobStatus": {
                return Optional.ofNullable(clazz.cast(this.transformJobStatusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransformJobSummary, T> g) {
        return obj -> g.apply((TransformJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transformJobName;
        private String transformJobArn;
        private Instant creationTime;
        private Instant transformEndTime;
        private Instant lastModifiedTime;
        private String transformJobStatus;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformJobSummary model) {
            this.transformJobName(model.transformJobName);
            this.transformJobArn(model.transformJobArn);
            this.creationTime(model.creationTime);
            this.transformEndTime(model.transformEndTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.transformJobStatus(model.transformJobStatus);
            this.failureReason(model.failureReason);
        }

        public final String getTransformJobName() {
            return this.transformJobName;
        }

        @Override
        public final Builder transformJobName(String transformJobName) {
            this.transformJobName = transformJobName;
            return this;
        }

        public final void setTransformJobName(String transformJobName) {
            this.transformJobName = transformJobName;
        }

        public final String getTransformJobArn() {
            return this.transformJobArn;
        }

        @Override
        public final Builder transformJobArn(String transformJobArn) {
            this.transformJobArn = transformJobArn;
            return this;
        }

        public final void setTransformJobArn(String transformJobArn) {
            this.transformJobArn = transformJobArn;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getTransformEndTime() {
            return this.transformEndTime;
        }

        @Override
        public final Builder transformEndTime(Instant transformEndTime) {
            this.transformEndTime = transformEndTime;
            return this;
        }

        public final void setTransformEndTime(Instant transformEndTime) {
            this.transformEndTime = transformEndTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getTransformJobStatus() {
            return this.transformJobStatus;
        }

        @Override
        public final Builder transformJobStatus(String transformJobStatus) {
            this.transformJobStatus = transformJobStatus;
            return this;
        }

        @Override
        public final Builder transformJobStatus(TransformJobStatus transformJobStatus) {
            this.transformJobStatus(transformJobStatus == null ? null : transformJobStatus.toString());
            return this;
        }

        public final void setTransformJobStatus(String transformJobStatus) {
            this.transformJobStatus = transformJobStatus;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public TransformJobSummary build() {
            return new TransformJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransformJobSummary> {
        public Builder transformJobName(String var1);

        public Builder transformJobArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder transformEndTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder transformJobStatus(String var1);

        public Builder transformJobStatus(TransformJobStatus var1);

        public Builder failureReason(String var1);
    }
}

