/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.Alarm;
import software.amazon.awssdk.services.sagemaker.model.AlarmListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoRollbackConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoRollbackConfig> {
    private static final SdkField<List<Alarm>> ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Alarms").getter(AutoRollbackConfig.getter(AutoRollbackConfig::alarms)).setter(AutoRollbackConfig.setter(Builder::alarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alarms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Alarm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Alarm> alarms;

    private AutoRollbackConfig(BuilderImpl builder) {
        this.alarms = builder.alarms;
    }

    public boolean hasAlarms() {
        return this.alarms != null && !(this.alarms instanceof SdkAutoConstructList);
    }

    public List<Alarm> alarms() {
        return this.alarms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlarms() ? this.alarms() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoRollbackConfig)) {
            return false;
        }
        AutoRollbackConfig other = (AutoRollbackConfig)obj;
        return this.hasAlarms() == other.hasAlarms() && Objects.equals(this.alarms(), other.alarms());
    }

    public String toString() {
        return ToString.builder((String)"AutoRollbackConfig").add("Alarms", this.hasAlarms() ? this.alarms() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alarms": {
                return Optional.ofNullable(clazz.cast(this.alarms()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoRollbackConfig, T> g) {
        return obj -> g.apply((AutoRollbackConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Alarm> alarms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoRollbackConfig model) {
            this.alarms(model.alarms);
        }

        public final Collection<Alarm.Builder> getAlarms() {
            if (this.alarms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.alarms != null ? (Collection)this.alarms.stream().map(Alarm::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder alarms(Collection<Alarm> alarms) {
            this.alarms = AlarmListCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Alarm ... alarms) {
            this.alarms(Arrays.asList(alarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Consumer<Alarm.Builder> ... alarms) {
            this.alarms(Stream.of(alarms).map(c -> (Alarm)((Alarm.Builder)Alarm.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAlarms(Collection<Alarm.BuilderImpl> alarms) {
            this.alarms = AlarmListCopier.copyFromBuilder(alarms);
        }

        public AutoRollbackConfig build() {
            return new AutoRollbackConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoRollbackConfig> {
        public Builder alarms(Collection<Alarm> var1);

        public Builder alarms(Alarm ... var1);

        public Builder alarms(Consumer<Alarm.Builder> ... var1);
    }
}

