/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus;
import software.amazon.awssdk.services.sagemaker.model.InputConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelArtifacts;
import software.amazon.awssdk.services.sagemaker.model.OutputConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.StoppingCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCompilationJobResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeCompilationJobResponse> {
    private static final SdkField<String> COMPILATION_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompilationJobName").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::compilationJobName)).setter(DescribeCompilationJobResponse.setter(Builder::compilationJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobName").build()}).build();
    private static final SdkField<String> COMPILATION_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompilationJobArn").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::compilationJobArn)).setter(DescribeCompilationJobResponse.setter(Builder::compilationJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobArn").build()}).build();
    private static final SdkField<String> COMPILATION_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompilationJobStatus").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::compilationJobStatusAsString)).setter(DescribeCompilationJobResponse.setter(Builder::compilationJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobStatus").build()}).build();
    private static final SdkField<Instant> COMPILATION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompilationStartTime").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::compilationStartTime)).setter(DescribeCompilationJobResponse.setter(Builder::compilationStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationStartTime").build()}).build();
    private static final SdkField<Instant> COMPILATION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompilationEndTime").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::compilationEndTime)).setter(DescribeCompilationJobResponse.setter(Builder::compilationEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationEndTime").build()}).build();
    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StoppingCondition").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::stoppingCondition)).setter(DescribeCompilationJobResponse.setter(Builder::stoppingCondition)).constructor(StoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::creationTime)).setter(DescribeCompilationJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::lastModifiedTime)).setter(DescribeCompilationJobResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::failureReason)).setter(DescribeCompilationJobResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<ModelArtifacts> MODEL_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelArtifacts").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::modelArtifacts)).setter(DescribeCompilationJobResponse.setter(Builder::modelArtifacts)).constructor(ModelArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArtifacts").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::roleArn)).setter(DescribeCompilationJobResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<InputConfig> INPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputConfig").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::inputConfig)).setter(DescribeCompilationJobResponse.setter(Builder::inputConfig)).constructor(InputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()}).build();
    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(DescribeCompilationJobResponse.getter(DescribeCompilationJobResponse::outputConfig)).setter(DescribeCompilationJobResponse.setter(Builder::outputConfig)).constructor(OutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPILATION_JOB_NAME_FIELD, COMPILATION_JOB_ARN_FIELD, COMPILATION_JOB_STATUS_FIELD, COMPILATION_START_TIME_FIELD, COMPILATION_END_TIME_FIELD, STOPPING_CONDITION_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD, MODEL_ARTIFACTS_FIELD, ROLE_ARN_FIELD, INPUT_CONFIG_FIELD, OUTPUT_CONFIG_FIELD));
    private final String compilationJobName;
    private final String compilationJobArn;
    private final String compilationJobStatus;
    private final Instant compilationStartTime;
    private final Instant compilationEndTime;
    private final StoppingCondition stoppingCondition;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String failureReason;
    private final ModelArtifacts modelArtifacts;
    private final String roleArn;
    private final InputConfig inputConfig;
    private final OutputConfig outputConfig;

    private DescribeCompilationJobResponse(BuilderImpl builder) {
        super(builder);
        this.compilationJobName = builder.compilationJobName;
        this.compilationJobArn = builder.compilationJobArn;
        this.compilationJobStatus = builder.compilationJobStatus;
        this.compilationStartTime = builder.compilationStartTime;
        this.compilationEndTime = builder.compilationEndTime;
        this.stoppingCondition = builder.stoppingCondition;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
        this.modelArtifacts = builder.modelArtifacts;
        this.roleArn = builder.roleArn;
        this.inputConfig = builder.inputConfig;
        this.outputConfig = builder.outputConfig;
    }

    public String compilationJobName() {
        return this.compilationJobName;
    }

    public String compilationJobArn() {
        return this.compilationJobArn;
    }

    public CompilationJobStatus compilationJobStatus() {
        return CompilationJobStatus.fromValue(this.compilationJobStatus);
    }

    public String compilationJobStatusAsString() {
        return this.compilationJobStatus;
    }

    public Instant compilationStartTime() {
        return this.compilationStartTime;
    }

    public Instant compilationEndTime() {
        return this.compilationEndTime;
    }

    public StoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public ModelArtifacts modelArtifacts() {
        return this.modelArtifacts;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public InputConfig inputConfig() {
        return this.inputConfig;
    }

    public OutputConfig outputConfig() {
        return this.outputConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCompilationJobResponse)) {
            return false;
        }
        DescribeCompilationJobResponse other = (DescribeCompilationJobResponse)((Object)obj);
        return Objects.equals(this.compilationJobName(), other.compilationJobName()) && Objects.equals(this.compilationJobArn(), other.compilationJobArn()) && Objects.equals(this.compilationJobStatusAsString(), other.compilationJobStatusAsString()) && Objects.equals(this.compilationStartTime(), other.compilationStartTime()) && Objects.equals(this.compilationEndTime(), other.compilationEndTime()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.modelArtifacts(), other.modelArtifacts()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.inputConfig(), other.inputConfig()) && Objects.equals(this.outputConfig(), other.outputConfig());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCompilationJobResponse").add("CompilationJobName", (Object)this.compilationJobName()).add("CompilationJobArn", (Object)this.compilationJobArn()).add("CompilationJobStatus", (Object)this.compilationJobStatusAsString()).add("CompilationStartTime", (Object)this.compilationStartTime()).add("CompilationEndTime", (Object)this.compilationEndTime()).add("StoppingCondition", (Object)this.stoppingCondition()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("FailureReason", (Object)this.failureReason()).add("ModelArtifacts", (Object)this.modelArtifacts()).add("RoleArn", (Object)this.roleArn()).add("InputConfig", (Object)this.inputConfig()).add("OutputConfig", (Object)this.outputConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompilationJobName": {
                return Optional.ofNullable(clazz.cast(this.compilationJobName()));
            }
            case "CompilationJobArn": {
                return Optional.ofNullable(clazz.cast(this.compilationJobArn()));
            }
            case "CompilationJobStatus": {
                return Optional.ofNullable(clazz.cast(this.compilationJobStatusAsString()));
            }
            case "CompilationStartTime": {
                return Optional.ofNullable(clazz.cast(this.compilationStartTime()));
            }
            case "CompilationEndTime": {
                return Optional.ofNullable(clazz.cast(this.compilationEndTime()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "ModelArtifacts": {
                return Optional.ofNullable(clazz.cast(this.modelArtifacts()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "InputConfig": {
                return Optional.ofNullable(clazz.cast(this.inputConfig()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCompilationJobResponse, T> g) {
        return obj -> g.apply((DescribeCompilationJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String compilationJobName;
        private String compilationJobArn;
        private String compilationJobStatus;
        private Instant compilationStartTime;
        private Instant compilationEndTime;
        private StoppingCondition stoppingCondition;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String failureReason;
        private ModelArtifacts modelArtifacts;
        private String roleArn;
        private InputConfig inputConfig;
        private OutputConfig outputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCompilationJobResponse model) {
            super(model);
            this.compilationJobName(model.compilationJobName);
            this.compilationJobArn(model.compilationJobArn);
            this.compilationJobStatus(model.compilationJobStatus);
            this.compilationStartTime(model.compilationStartTime);
            this.compilationEndTime(model.compilationEndTime);
            this.stoppingCondition(model.stoppingCondition);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.failureReason(model.failureReason);
            this.modelArtifacts(model.modelArtifacts);
            this.roleArn(model.roleArn);
            this.inputConfig(model.inputConfig);
            this.outputConfig(model.outputConfig);
        }

        public final String getCompilationJobName() {
            return this.compilationJobName;
        }

        @Override
        public final Builder compilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
            return this;
        }

        public final void setCompilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
        }

        public final String getCompilationJobArn() {
            return this.compilationJobArn;
        }

        @Override
        public final Builder compilationJobArn(String compilationJobArn) {
            this.compilationJobArn = compilationJobArn;
            return this;
        }

        public final void setCompilationJobArn(String compilationJobArn) {
            this.compilationJobArn = compilationJobArn;
        }

        public final String getCompilationJobStatus() {
            return this.compilationJobStatus;
        }

        @Override
        public final Builder compilationJobStatus(String compilationJobStatus) {
            this.compilationJobStatus = compilationJobStatus;
            return this;
        }

        @Override
        public final Builder compilationJobStatus(CompilationJobStatus compilationJobStatus) {
            this.compilationJobStatus(compilationJobStatus == null ? null : compilationJobStatus.toString());
            return this;
        }

        public final void setCompilationJobStatus(String compilationJobStatus) {
            this.compilationJobStatus = compilationJobStatus;
        }

        public final Instant getCompilationStartTime() {
            return this.compilationStartTime;
        }

        @Override
        public final Builder compilationStartTime(Instant compilationStartTime) {
            this.compilationStartTime = compilationStartTime;
            return this;
        }

        public final void setCompilationStartTime(Instant compilationStartTime) {
            this.compilationStartTime = compilationStartTime;
        }

        public final Instant getCompilationEndTime() {
            return this.compilationEndTime;
        }

        @Override
        public final Builder compilationEndTime(Instant compilationEndTime) {
            this.compilationEndTime = compilationEndTime;
            return this;
        }

        public final void setCompilationEndTime(Instant compilationEndTime) {
            this.compilationEndTime = compilationEndTime;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final ModelArtifacts.Builder getModelArtifacts() {
            return this.modelArtifacts != null ? this.modelArtifacts.toBuilder() : null;
        }

        @Override
        public final Builder modelArtifacts(ModelArtifacts modelArtifacts) {
            this.modelArtifacts = modelArtifacts;
            return this;
        }

        public final void setModelArtifacts(ModelArtifacts.BuilderImpl modelArtifacts) {
            this.modelArtifacts = modelArtifacts != null ? modelArtifacts.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final InputConfig.Builder getInputConfig() {
            return this.inputConfig != null ? this.inputConfig.toBuilder() : null;
        }

        @Override
        public final Builder inputConfig(InputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final void setInputConfig(InputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public DescribeCompilationJobResponse build() {
            return new DescribeCompilationJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCompilationJobResponse> {
        public Builder compilationJobName(String var1);

        public Builder compilationJobArn(String var1);

        public Builder compilationJobStatus(String var1);

        public Builder compilationJobStatus(CompilationJobStatus var1);

        public Builder compilationStartTime(Instant var1);

        public Builder compilationEndTime(Instant var1);

        public Builder stoppingCondition(StoppingCondition var1);

        default public Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((StoppingCondition)((StoppingCondition.Builder)StoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder failureReason(String var1);

        public Builder modelArtifacts(ModelArtifacts var1);

        default public Builder modelArtifacts(Consumer<ModelArtifacts.Builder> modelArtifacts) {
            return this.modelArtifacts((ModelArtifacts)((ModelArtifacts.Builder)ModelArtifacts.builder().applyMutation(modelArtifacts)).build());
        }

        public Builder roleArn(String var1);

        public Builder inputConfig(InputConfig var1);

        default public Builder inputConfig(Consumer<InputConfig.Builder> inputConfig) {
            return this.inputConfig((InputConfig)((InputConfig.Builder)InputConfig.builder().applyMutation(inputConfig)).build());
        }

        public Builder outputConfig(OutputConfig var1);

        default public Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return this.outputConfig((OutputConfig)((OutputConfig.Builder)OutputConfig.builder().applyMutation(outputConfig)).build());
        }
    }
}

