/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListWorkforcesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListWorkforcesResponse;
import software.amazon.awssdk.services.sagemaker.model.Workforce;

public class ListWorkforcesPublisher
implements SdkPublisher<ListWorkforcesResponse> {
    private final SageMakerAsyncClient client;
    private final ListWorkforcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkforcesPublisher(SageMakerAsyncClient client, ListWorkforcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkforcesPublisher(SageMakerAsyncClient client, ListWorkforcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkforcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkforcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Workforce> workforces() {
        Function<ListWorkforcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.workforces() != null) {
                return response.workforces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkforcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkforcesResponseFetcher
    implements AsyncPageFetcher<ListWorkforcesResponse> {
        private ListWorkforcesResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkforcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkforcesResponse> nextPage(ListWorkforcesResponse previousPage) {
            if (previousPage == null) {
                return ListWorkforcesPublisher.this.client.listWorkforces(ListWorkforcesPublisher.this.firstRequest);
            }
            return ListWorkforcesPublisher.this.client.listWorkforces((ListWorkforcesRequest)((Object)ListWorkforcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

