/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigListCopier;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleHook;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNotebookInstanceLifecycleConfigRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateNotebookInstanceLifecycleConfigRequest> {
    private static final SdkField<String> NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookInstanceLifecycleConfigName").getter(CreateNotebookInstanceLifecycleConfigRequest.getter(CreateNotebookInstanceLifecycleConfigRequest::notebookInstanceLifecycleConfigName)).setter(CreateNotebookInstanceLifecycleConfigRequest.setter(Builder::notebookInstanceLifecycleConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceLifecycleConfigName").build()}).build();
    private static final SdkField<List<NotebookInstanceLifecycleHook>> ON_CREATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OnCreate").getter(CreateNotebookInstanceLifecycleConfigRequest.getter(CreateNotebookInstanceLifecycleConfigRequest::onCreate)).setter(CreateNotebookInstanceLifecycleConfigRequest.setter(Builder::onCreate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnCreate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NotebookInstanceLifecycleHook::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<NotebookInstanceLifecycleHook>> ON_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OnStart").getter(CreateNotebookInstanceLifecycleConfigRequest.getter(CreateNotebookInstanceLifecycleConfigRequest::onStart)).setter(CreateNotebookInstanceLifecycleConfigRequest.setter(Builder::onStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnStart").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NotebookInstanceLifecycleHook::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD, ON_CREATE_FIELD, ON_START_FIELD));
    private final String notebookInstanceLifecycleConfigName;
    private final List<NotebookInstanceLifecycleHook> onCreate;
    private final List<NotebookInstanceLifecycleHook> onStart;

    private CreateNotebookInstanceLifecycleConfigRequest(BuilderImpl builder) {
        super(builder);
        this.notebookInstanceLifecycleConfigName = builder.notebookInstanceLifecycleConfigName;
        this.onCreate = builder.onCreate;
        this.onStart = builder.onStart;
    }

    public String notebookInstanceLifecycleConfigName() {
        return this.notebookInstanceLifecycleConfigName;
    }

    public boolean hasOnCreate() {
        return this.onCreate != null && !(this.onCreate instanceof SdkAutoConstructList);
    }

    public List<NotebookInstanceLifecycleHook> onCreate() {
        return this.onCreate;
    }

    public boolean hasOnStart() {
        return this.onStart != null && !(this.onStart instanceof SdkAutoConstructList);
    }

    public List<NotebookInstanceLifecycleHook> onStart() {
        return this.onStart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceLifecycleConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOnCreate() ? this.onCreate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOnStart() ? this.onStart() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNotebookInstanceLifecycleConfigRequest)) {
            return false;
        }
        CreateNotebookInstanceLifecycleConfigRequest other = (CreateNotebookInstanceLifecycleConfigRequest)((Object)obj);
        return Objects.equals(this.notebookInstanceLifecycleConfigName(), other.notebookInstanceLifecycleConfigName()) && this.hasOnCreate() == other.hasOnCreate() && Objects.equals(this.onCreate(), other.onCreate()) && this.hasOnStart() == other.hasOnStart() && Objects.equals(this.onStart(), other.onStart());
    }

    public String toString() {
        return ToString.builder((String)"CreateNotebookInstanceLifecycleConfigRequest").add("NotebookInstanceLifecycleConfigName", (Object)this.notebookInstanceLifecycleConfigName()).add("OnCreate", this.hasOnCreate() ? this.onCreate() : null).add("OnStart", this.hasOnStart() ? this.onStart() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotebookInstanceLifecycleConfigName": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceLifecycleConfigName()));
            }
            case "OnCreate": {
                return Optional.ofNullable(clazz.cast(this.onCreate()));
            }
            case "OnStart": {
                return Optional.ofNullable(clazz.cast(this.onStart()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNotebookInstanceLifecycleConfigRequest, T> g) {
        return obj -> g.apply((CreateNotebookInstanceLifecycleConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String notebookInstanceLifecycleConfigName;
        private List<NotebookInstanceLifecycleHook> onCreate = DefaultSdkAutoConstructList.getInstance();
        private List<NotebookInstanceLifecycleHook> onStart = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNotebookInstanceLifecycleConfigRequest model) {
            super(model);
            this.notebookInstanceLifecycleConfigName(model.notebookInstanceLifecycleConfigName);
            this.onCreate(model.onCreate);
            this.onStart(model.onStart);
        }

        public final String getNotebookInstanceLifecycleConfigName() {
            return this.notebookInstanceLifecycleConfigName;
        }

        @Override
        public final Builder notebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
            return this;
        }

        public final void setNotebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
        }

        public final Collection<NotebookInstanceLifecycleHook.Builder> getOnCreate() {
            if (this.onCreate instanceof SdkAutoConstructList) {
                return null;
            }
            return this.onCreate != null ? (Collection)this.onCreate.stream().map(NotebookInstanceLifecycleHook::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder onCreate(Collection<NotebookInstanceLifecycleHook> onCreate) {
            this.onCreate = NotebookInstanceLifecycleConfigListCopier.copy(onCreate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onCreate(NotebookInstanceLifecycleHook ... onCreate) {
            this.onCreate(Arrays.asList(onCreate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onCreate(Consumer<NotebookInstanceLifecycleHook.Builder> ... onCreate) {
            this.onCreate(Stream.of(onCreate).map(c -> (NotebookInstanceLifecycleHook)((NotebookInstanceLifecycleHook.Builder)NotebookInstanceLifecycleHook.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOnCreate(Collection<NotebookInstanceLifecycleHook.BuilderImpl> onCreate) {
            this.onCreate = NotebookInstanceLifecycleConfigListCopier.copyFromBuilder(onCreate);
        }

        public final Collection<NotebookInstanceLifecycleHook.Builder> getOnStart() {
            if (this.onStart instanceof SdkAutoConstructList) {
                return null;
            }
            return this.onStart != null ? (Collection)this.onStart.stream().map(NotebookInstanceLifecycleHook::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder onStart(Collection<NotebookInstanceLifecycleHook> onStart) {
            this.onStart = NotebookInstanceLifecycleConfigListCopier.copy(onStart);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onStart(NotebookInstanceLifecycleHook ... onStart) {
            this.onStart(Arrays.asList(onStart));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onStart(Consumer<NotebookInstanceLifecycleHook.Builder> ... onStart) {
            this.onStart(Stream.of(onStart).map(c -> (NotebookInstanceLifecycleHook)((NotebookInstanceLifecycleHook.Builder)NotebookInstanceLifecycleHook.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOnStart(Collection<NotebookInstanceLifecycleHook.BuilderImpl> onStart) {
            this.onStart = NotebookInstanceLifecycleConfigListCopier.copyFromBuilder(onStart);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNotebookInstanceLifecycleConfigRequest build() {
            return new CreateNotebookInstanceLifecycleConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNotebookInstanceLifecycleConfigRequest> {
        public Builder notebookInstanceLifecycleConfigName(String var1);

        public Builder onCreate(Collection<NotebookInstanceLifecycleHook> var1);

        public Builder onCreate(NotebookInstanceLifecycleHook ... var1);

        public Builder onCreate(Consumer<NotebookInstanceLifecycleHook.Builder> ... var1);

        public Builder onStart(Collection<NotebookInstanceLifecycleHook> var1);

        public Builder onStart(NotebookInstanceLifecycleHook ... var1);

        public Builder onStart(Consumer<NotebookInstanceLifecycleHook.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

