/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LabelCounters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LabelCounters> {
    private static final SdkField<Integer> TOTAL_LABELED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalLabeled").getter(LabelCounters.getter(LabelCounters::totalLabeled)).setter(LabelCounters.setter(Builder::totalLabeled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalLabeled").build()}).build();
    private static final SdkField<Integer> HUMAN_LABELED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HumanLabeled").getter(LabelCounters.getter(LabelCounters::humanLabeled)).setter(LabelCounters.setter(Builder::humanLabeled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLabeled").build()}).build();
    private static final SdkField<Integer> MACHINE_LABELED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MachineLabeled").getter(LabelCounters.getter(LabelCounters::machineLabeled)).setter(LabelCounters.setter(Builder::machineLabeled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MachineLabeled").build()}).build();
    private static final SdkField<Integer> FAILED_NON_RETRYABLE_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailedNonRetryableError").getter(LabelCounters.getter(LabelCounters::failedNonRetryableError)).setter(LabelCounters.setter(Builder::failedNonRetryableError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedNonRetryableError").build()}).build();
    private static final SdkField<Integer> UNLABELED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Unlabeled").getter(LabelCounters.getter(LabelCounters::unlabeled)).setter(LabelCounters.setter(Builder::unlabeled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unlabeled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_LABELED_FIELD, HUMAN_LABELED_FIELD, MACHINE_LABELED_FIELD, FAILED_NON_RETRYABLE_ERROR_FIELD, UNLABELED_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer totalLabeled;
    private final Integer humanLabeled;
    private final Integer machineLabeled;
    private final Integer failedNonRetryableError;
    private final Integer unlabeled;

    private LabelCounters(BuilderImpl builder) {
        this.totalLabeled = builder.totalLabeled;
        this.humanLabeled = builder.humanLabeled;
        this.machineLabeled = builder.machineLabeled;
        this.failedNonRetryableError = builder.failedNonRetryableError;
        this.unlabeled = builder.unlabeled;
    }

    public Integer totalLabeled() {
        return this.totalLabeled;
    }

    public Integer humanLabeled() {
        return this.humanLabeled;
    }

    public Integer machineLabeled() {
        return this.machineLabeled;
    }

    public Integer failedNonRetryableError() {
        return this.failedNonRetryableError;
    }

    public Integer unlabeled() {
        return this.unlabeled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalLabeled());
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLabeled());
        hashCode = 31 * hashCode + Objects.hashCode(this.machineLabeled());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedNonRetryableError());
        hashCode = 31 * hashCode + Objects.hashCode(this.unlabeled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelCounters)) {
            return false;
        }
        LabelCounters other = (LabelCounters)obj;
        return Objects.equals(this.totalLabeled(), other.totalLabeled()) && Objects.equals(this.humanLabeled(), other.humanLabeled()) && Objects.equals(this.machineLabeled(), other.machineLabeled()) && Objects.equals(this.failedNonRetryableError(), other.failedNonRetryableError()) && Objects.equals(this.unlabeled(), other.unlabeled());
    }

    public String toString() {
        return ToString.builder((String)"LabelCounters").add("TotalLabeled", (Object)this.totalLabeled()).add("HumanLabeled", (Object)this.humanLabeled()).add("MachineLabeled", (Object)this.machineLabeled()).add("FailedNonRetryableError", (Object)this.failedNonRetryableError()).add("Unlabeled", (Object)this.unlabeled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalLabeled": {
                return Optional.ofNullable(clazz.cast(this.totalLabeled()));
            }
            case "HumanLabeled": {
                return Optional.ofNullable(clazz.cast(this.humanLabeled()));
            }
            case "MachineLabeled": {
                return Optional.ofNullable(clazz.cast(this.machineLabeled()));
            }
            case "FailedNonRetryableError": {
                return Optional.ofNullable(clazz.cast(this.failedNonRetryableError()));
            }
            case "Unlabeled": {
                return Optional.ofNullable(clazz.cast(this.unlabeled()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelCounters, T> g) {
        return obj -> g.apply((LabelCounters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer totalLabeled;
        private Integer humanLabeled;
        private Integer machineLabeled;
        private Integer failedNonRetryableError;
        private Integer unlabeled;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelCounters model) {
            this.totalLabeled(model.totalLabeled);
            this.humanLabeled(model.humanLabeled);
            this.machineLabeled(model.machineLabeled);
            this.failedNonRetryableError(model.failedNonRetryableError);
            this.unlabeled(model.unlabeled);
        }

        public final Integer getTotalLabeled() {
            return this.totalLabeled;
        }

        @Override
        public final Builder totalLabeled(Integer totalLabeled) {
            this.totalLabeled = totalLabeled;
            return this;
        }

        public final void setTotalLabeled(Integer totalLabeled) {
            this.totalLabeled = totalLabeled;
        }

        public final Integer getHumanLabeled() {
            return this.humanLabeled;
        }

        @Override
        public final Builder humanLabeled(Integer humanLabeled) {
            this.humanLabeled = humanLabeled;
            return this;
        }

        public final void setHumanLabeled(Integer humanLabeled) {
            this.humanLabeled = humanLabeled;
        }

        public final Integer getMachineLabeled() {
            return this.machineLabeled;
        }

        @Override
        public final Builder machineLabeled(Integer machineLabeled) {
            this.machineLabeled = machineLabeled;
            return this;
        }

        public final void setMachineLabeled(Integer machineLabeled) {
            this.machineLabeled = machineLabeled;
        }

        public final Integer getFailedNonRetryableError() {
            return this.failedNonRetryableError;
        }

        @Override
        public final Builder failedNonRetryableError(Integer failedNonRetryableError) {
            this.failedNonRetryableError = failedNonRetryableError;
            return this;
        }

        public final void setFailedNonRetryableError(Integer failedNonRetryableError) {
            this.failedNonRetryableError = failedNonRetryableError;
        }

        public final Integer getUnlabeled() {
            return this.unlabeled;
        }

        @Override
        public final Builder unlabeled(Integer unlabeled) {
            this.unlabeled = unlabeled;
            return this;
        }

        public final void setUnlabeled(Integer unlabeled) {
            this.unlabeled = unlabeled;
        }

        public LabelCounters build() {
            return new LabelCounters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LabelCounters> {
        public Builder totalLabeled(Integer var1);

        public Builder humanLabeled(Integer var1);

        public Builder machineLabeled(Integer var1);

        public Builder failedNonRetryableError(Integer var1);

        public Builder unlabeled(Integer var1);
    }
}

