/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ProcessingJob;
import software.amazon.awssdk.services.sagemaker.model.TrainingJob;
import software.amazon.awssdk.services.sagemaker.model.TransformJob;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrialComponentSourceDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrialComponentSourceDetail> {
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TrialComponentSourceDetail.getter(TrialComponentSourceDetail::sourceArn)).setter(TrialComponentSourceDetail.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<TrainingJob> TRAINING_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrialComponentSourceDetail.getter(TrialComponentSourceDetail::trainingJob)).setter(TrialComponentSourceDetail.setter(Builder::trainingJob)).constructor(TrainingJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJob").build()}).build();
    private static final SdkField<ProcessingJob> PROCESSING_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrialComponentSourceDetail.getter(TrialComponentSourceDetail::processingJob)).setter(TrialComponentSourceDetail.setter(Builder::processingJob)).constructor(ProcessingJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJob").build()}).build();
    private static final SdkField<TransformJob> TRANSFORM_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrialComponentSourceDetail.getter(TrialComponentSourceDetail::transformJob)).setter(TrialComponentSourceDetail.setter(Builder::transformJob)).constructor(TransformJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJob").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ARN_FIELD, TRAINING_JOB_FIELD, PROCESSING_JOB_FIELD, TRANSFORM_JOB_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceArn;
    private final TrainingJob trainingJob;
    private final ProcessingJob processingJob;
    private final TransformJob transformJob;

    private TrialComponentSourceDetail(BuilderImpl builder) {
        this.sourceArn = builder.sourceArn;
        this.trainingJob = builder.trainingJob;
        this.processingJob = builder.processingJob;
        this.transformJob = builder.transformJob;
    }

    public String sourceArn() {
        return this.sourceArn;
    }

    public TrainingJob trainingJob() {
        return this.trainingJob;
    }

    public ProcessingJob processingJob() {
        return this.processingJob;
    }

    public TransformJob transformJob() {
        return this.transformJob;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformJob());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrialComponentSourceDetail)) {
            return false;
        }
        TrialComponentSourceDetail other = (TrialComponentSourceDetail)obj;
        return Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.trainingJob(), other.trainingJob()) && Objects.equals(this.processingJob(), other.processingJob()) && Objects.equals(this.transformJob(), other.transformJob());
    }

    public String toString() {
        return ToString.builder((String)"TrialComponentSourceDetail").add("SourceArn", (Object)this.sourceArn()).add("TrainingJob", (Object)this.trainingJob()).add("ProcessingJob", (Object)this.processingJob()).add("TransformJob", (Object)this.transformJob()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "TrainingJob": {
                return Optional.ofNullable(clazz.cast(this.trainingJob()));
            }
            case "ProcessingJob": {
                return Optional.ofNullable(clazz.cast(this.processingJob()));
            }
            case "TransformJob": {
                return Optional.ofNullable(clazz.cast(this.transformJob()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrialComponentSourceDetail, T> g) {
        return obj -> g.apply((TrialComponentSourceDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceArn;
        private TrainingJob trainingJob;
        private ProcessingJob processingJob;
        private TransformJob transformJob;

        private BuilderImpl() {
        }

        private BuilderImpl(TrialComponentSourceDetail model) {
            this.sourceArn(model.sourceArn);
            this.trainingJob(model.trainingJob);
            this.processingJob(model.processingJob);
            this.transformJob(model.transformJob);
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final TrainingJob.Builder getTrainingJob() {
            return this.trainingJob != null ? this.trainingJob.toBuilder() : null;
        }

        @Override
        public final Builder trainingJob(TrainingJob trainingJob) {
            this.trainingJob = trainingJob;
            return this;
        }

        public final void setTrainingJob(TrainingJob.BuilderImpl trainingJob) {
            this.trainingJob = trainingJob != null ? trainingJob.build() : null;
        }

        public final ProcessingJob.Builder getProcessingJob() {
            return this.processingJob != null ? this.processingJob.toBuilder() : null;
        }

        @Override
        public final Builder processingJob(ProcessingJob processingJob) {
            this.processingJob = processingJob;
            return this;
        }

        public final void setProcessingJob(ProcessingJob.BuilderImpl processingJob) {
            this.processingJob = processingJob != null ? processingJob.build() : null;
        }

        public final TransformJob.Builder getTransformJob() {
            return this.transformJob != null ? this.transformJob.toBuilder() : null;
        }

        @Override
        public final Builder transformJob(TransformJob transformJob) {
            this.transformJob = transformJob;
            return this;
        }

        public final void setTransformJob(TransformJob.BuilderImpl transformJob) {
            this.transformJob = transformJob != null ? transformJob.build() : null;
        }

        public TrialComponentSourceDetail build() {
            return new TrialComponentSourceDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrialComponentSourceDetail> {
        public Builder sourceArn(String var1);

        public Builder trainingJob(TrainingJob var1);

        default public Builder trainingJob(Consumer<TrainingJob.Builder> trainingJob) {
            return this.trainingJob((TrainingJob)((TrainingJob.Builder)TrainingJob.builder().applyMutation(trainingJob)).build());
        }

        public Builder processingJob(ProcessingJob var1);

        default public Builder processingJob(Consumer<ProcessingJob.Builder> processingJob) {
            return this.processingJob((ProcessingJob)((ProcessingJob.Builder)ProcessingJob.builder().applyMutation(processingJob)).build());
        }

        public Builder transformJob(TransformJob var1);

        default public Builder transformJob(Consumer<TransformJob.Builder> transformJob) {
            return this.transformJob((TransformJob)((TransformJob.Builder)TransformJob.builder().applyMutation(transformJob)).build());
        }
    }
}

