/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.MonitoringJobDefinition;
import software.amazon.awssdk.services.sagemaker.model.ScheduleConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoringScheduleConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoringScheduleConfig> {
    private static final SdkField<ScheduleConfig> SCHEDULE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MonitoringScheduleConfig.getter(MonitoringScheduleConfig::scheduleConfig)).setter(MonitoringScheduleConfig.setter(Builder::scheduleConfig)).constructor(ScheduleConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfig").build()}).build();
    private static final SdkField<MonitoringJobDefinition> MONITORING_JOB_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MonitoringScheduleConfig.getter(MonitoringScheduleConfig::monitoringJobDefinition)).setter(MonitoringScheduleConfig.setter(Builder::monitoringJobDefinition)).constructor(MonitoringJobDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringJobDefinition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_CONFIG_FIELD, MONITORING_JOB_DEFINITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final ScheduleConfig scheduleConfig;
    private final MonitoringJobDefinition monitoringJobDefinition;

    private MonitoringScheduleConfig(BuilderImpl builder) {
        this.scheduleConfig = builder.scheduleConfig;
        this.monitoringJobDefinition = builder.monitoringJobDefinition;
    }

    public ScheduleConfig scheduleConfig() {
        return this.scheduleConfig;
    }

    public MonitoringJobDefinition monitoringJobDefinition() {
        return this.monitoringJobDefinition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringJobDefinition());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringScheduleConfig)) {
            return false;
        }
        MonitoringScheduleConfig other = (MonitoringScheduleConfig)obj;
        return Objects.equals(this.scheduleConfig(), other.scheduleConfig()) && Objects.equals(this.monitoringJobDefinition(), other.monitoringJobDefinition());
    }

    public String toString() {
        return ToString.builder((String)"MonitoringScheduleConfig").add("ScheduleConfig", (Object)this.scheduleConfig()).add("MonitoringJobDefinition", (Object)this.monitoringJobDefinition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduleConfig": {
                return Optional.ofNullable(clazz.cast(this.scheduleConfig()));
            }
            case "MonitoringJobDefinition": {
                return Optional.ofNullable(clazz.cast(this.monitoringJobDefinition()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringScheduleConfig, T> g) {
        return obj -> g.apply((MonitoringScheduleConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ScheduleConfig scheduleConfig;
        private MonitoringJobDefinition monitoringJobDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringScheduleConfig model) {
            this.scheduleConfig(model.scheduleConfig);
            this.monitoringJobDefinition(model.monitoringJobDefinition);
        }

        public final ScheduleConfig.Builder getScheduleConfig() {
            return this.scheduleConfig != null ? this.scheduleConfig.toBuilder() : null;
        }

        @Override
        public final Builder scheduleConfig(ScheduleConfig scheduleConfig) {
            this.scheduleConfig = scheduleConfig;
            return this;
        }

        public final void setScheduleConfig(ScheduleConfig.BuilderImpl scheduleConfig) {
            this.scheduleConfig = scheduleConfig != null ? scheduleConfig.build() : null;
        }

        public final MonitoringJobDefinition.Builder getMonitoringJobDefinition() {
            return this.monitoringJobDefinition != null ? this.monitoringJobDefinition.toBuilder() : null;
        }

        @Override
        public final Builder monitoringJobDefinition(MonitoringJobDefinition monitoringJobDefinition) {
            this.monitoringJobDefinition = monitoringJobDefinition;
            return this;
        }

        public final void setMonitoringJobDefinition(MonitoringJobDefinition.BuilderImpl monitoringJobDefinition) {
            this.monitoringJobDefinition = monitoringJobDefinition != null ? monitoringJobDefinition.build() : null;
        }

        public MonitoringScheduleConfig build() {
            return new MonitoringScheduleConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoringScheduleConfig> {
        public Builder scheduleConfig(ScheduleConfig var1);

        default public Builder scheduleConfig(Consumer<ScheduleConfig.Builder> scheduleConfig) {
            return this.scheduleConfig((ScheduleConfig)((ScheduleConfig.Builder)ScheduleConfig.builder().applyMutation(scheduleConfig)).build());
        }

        public Builder monitoringJobDefinition(MonitoringJobDefinition var1);

        default public Builder monitoringJobDefinition(Consumer<MonitoringJobDefinition.Builder> monitoringJobDefinition) {
            return this.monitoringJobDefinition((MonitoringJobDefinition)((MonitoringJobDefinition.Builder)MonitoringJobDefinition.builder().applyMutation(monitoringJobDefinition)).build());
        }
    }
}

