/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateExperimentResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, CreateExperimentResponse> {
    private static final SdkField<String> EXPERIMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateExperimentResponse.getter(CreateExperimentResponse::experimentArn)).setter(CreateExperimentResponse.setter(Builder::experimentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_ARN_FIELD));
    private final String experimentArn;

    private CreateExperimentResponse(BuilderImpl builder) {
        super(builder);
        this.experimentArn = builder.experimentArn;
    }

    public String experimentArn() {
        return this.experimentArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExperimentResponse)) {
            return false;
        }
        CreateExperimentResponse other = (CreateExperimentResponse)((Object)obj);
        return Objects.equals(this.experimentArn(), other.experimentArn());
    }

    public String toString() {
        return ToString.builder((String)"CreateExperimentResponse").add("ExperimentArn", (Object)this.experimentArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExperimentArn": {
                return Optional.ofNullable(clazz.cast(this.experimentArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateExperimentResponse, T> g) {
        return obj -> g.apply((CreateExperimentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String experimentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExperimentResponse model) {
            super(model);
            this.experimentArn(model.experimentArn);
        }

        public final String getExperimentArn() {
            return this.experimentArn;
        }

        @Override
        public final Builder experimentArn(String experimentArn) {
            this.experimentArn = experimentArn;
            return this;
        }

        public final void setExperimentArn(String experimentArn) {
            this.experimentArn = experimentArn;
        }

        @Override
        public CreateExperimentResponse build() {
            return new CreateExperimentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateExperimentResponse> {
        public Builder experimentArn(String var1);
    }
}

