/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.HumanTaskUiSummary;
import software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisResponse;

public class ListHumanTaskUisPublisher
implements SdkPublisher<ListHumanTaskUisResponse> {
    private final SageMakerAsyncClient client;
    private final ListHumanTaskUisRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListHumanTaskUisPublisher(SageMakerAsyncClient client, ListHumanTaskUisRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListHumanTaskUisPublisher(SageMakerAsyncClient client, ListHumanTaskUisRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListHumanTaskUisResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListHumanTaskUisResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<HumanTaskUiSummary> humanTaskUiSummaries() {
        Function<ListHumanTaskUisResponse, Iterator> getIterator = response -> {
            if (response != null && response.humanTaskUiSummaries() != null) {
                return response.humanTaskUiSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListHumanTaskUisResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListHumanTaskUisResponseFetcher
    implements AsyncPageFetcher<ListHumanTaskUisResponse> {
        private ListHumanTaskUisResponseFetcher() {
        }

        public boolean hasNextPage(ListHumanTaskUisResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListHumanTaskUisResponse> nextPage(ListHumanTaskUisResponse previousPage) {
            if (previousPage == null) {
                return ListHumanTaskUisPublisher.this.client.listHumanTaskUis(ListHumanTaskUisPublisher.this.firstRequest);
            }
            return ListHumanTaskUisPublisher.this.client.listHumanTaskUis((ListHumanTaskUisRequest)((Object)ListHumanTaskUisPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

