/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TargetPlatformArch {
    X86_64("X86_64"),
    X86("X86"),
    ARM64("ARM64"),
    ARM_EABI("ARM_EABI"),
    ARM_EABIHF("ARM_EABIHF"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TargetPlatformArch(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetPlatformArch fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TargetPlatformArch.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetPlatformArch> knownValues() {
        return Stream.of(TargetPlatformArch.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

